var EXPORTED_SYMBOLS = ["ConfigFile"];

// Config file handling
//
// Reads a configuration file
//
// The only useful function here is ConfigFile.getconfigvalue(name)
// When called the first time, it loads the config file. In any case,
// it returns the config value corresponding to name.


Components.utils.import('resource://indexdata/util/io.js');
Components.utils.import('resource://indexdata/util/logging.js');
Components.utils.import('resource://indexdata/runtime/StepError.js');

//var logger = logging.getLogger('configfile');
var logger = logging.getLogger('');

var ConfigFile = {
    configfilename: "/etc/cf-proxy/cproxy.cfg",
    loaded: false,
    configs: {},

    loadconfigs: function(task) {
        try {
            var file = Components.classes["@mozilla.org/file/local;1"].
                createInstance(Components.interfaces.nsILocalFile);
            file.initWithPath(this.configfilename);
            var istream = Components.
                classes["@mozilla.org/network/file-input-stream;1"].
                createInstance(Components.interfaces.nsIFileInputStream);
            istream.init(file, 0x01, 0444, 0);
            istream.QueryInterface(Components.interfaces.nsILineInputStream);
            //task.debug("loading config file " + this.configfilename );
            var line = {};
            var hasmore = true;
            while (hasmore) {
                hasmore = istream.readLine(line);
                var l = line.value;
                l = l.replace( /\#.*$/,''); // strip comments
                var m = l.match( /^([^ :]+) *: *(.*)$/);
                if (m) {
                    var k = m[1];
                    var v = m[2];
                    this.configs[k] = v;
                }
            };
            istream.close();
            this.loaded = true;
        } catch (e) {
            task.warn("Can not load config file '" +
                this.configfilename + "' : " + e.message );
            this.loaded = true; // Actually not, no point in trying again
            /*
            // TODO - Check if in the engine, and throw an error there
            // But not in the builder - people can run a builder without
            // write access to /etc!
            throw new StepError("Can not load config file '" +
                this.configfilename + "' :" + e.message );
            */
        }
    },

    getconfigvalue: function( task, name ) {
        if (!this.loaded)
            this.loadconfigs(task);
        return this.configs[name];
    },

};

