var EXPORTED_SYMBOLS = ["progressListen"];
var Cc = Components.classes;
var Ci = Components.interfaces;
const STATE_START = Ci.nsIWebProgressListener.STATE_START;
const STATE_TRANSFERRING = Ci.nsIWebProgressListener.STATE_TRANSFERRING;
const STATE_STOP = Ci.nsIWebProgressListener.STATE_STOP;
const STATE_REDIRECTING = Ci.nsIWebProgressListener.STATE_REDIRECTING;
const STATE_IS_DOCUMENT = Ci.nsIWebProgressListener.STATE_IS_DOCUMENT;
const NOTIFY_ALL = Ci.nsIWebProgress.NOTIFY_ALL;

const OBSRV = Cc["@mozilla.org/observer-service;1"]
  .getService(Ci.nsIObserverService);

var progressListen = {
  started: null,
  progress: null,
  task: null,
  isEngine: false,
  redirectedFrom: null,
  waitXHR: true,
  minQuiet: 50,
  quietTime: 50,
  quietTimer: Cc["@mozilla.org/timer;1"]
    .createInstance(Ci.nsITimer),
  defaultConf: {
    quietTime: 50,
    waitXHR: true,
  },

  getDisplayName: function() {
    return "nsIWebProgressListener and nsIObserverService";
  },

  draw : function(surface, conf) {
    Components.utils.import('resource://indexdata/util/xmlHelper.js');

    xmlHelper.appendNode(surface, "label", null,
      { control: "quietTime", value:"New load threshold (ms):" });
    var quietTime = xmlHelper.appendNode(surface, "textbox", null,
      { id:"quietTime", value:conf.quietTime||this.defaultConf.quietTime});
    quietTime.addEventListener("input", function(e) {
      conf.quietTime = parseInt(quietTime.value);
    }, false);

    var attributes = { label: "Wait for XMLHttpRequests? (nsIObserver)" };
    if (conf.waitXHR || (conf.waitXHR === undefined && this.defaultConf.waitXHR))
      attributes.checked = true;
    var check = xmlHelper.appendNode(surface, "checkbox", null, attributes);
    check.addEventListener("command", function(e) {
      conf.waitXHR = this.checked;
    }, false);
  },

  wait: function(task, conf, step) {
    this.progress = task.connector.getPageWindow();
    if (!this.progress.addProgressListener)  {
      this.progress = Cc["@mozilla.org/docloaderservice;1"].getService(Ci.nsIWebProgress);
      this.isEngine = true;
    }
    this.progress.addProgressListener(progressListen, NOTIFY_ALL);
    this.task = task;
    this.step = step;

    // conf checking and defaults
    if (conf.waitXHR===undefined)
      this.waitXHR = this.defaultConf.waitXHR;
    else
      this.waitXHR = conf.waitXHR;
    if (conf.quietTime)
      this.quietTime = conf.quietTime;
    else
      this.quietTime = this.defaultConf.quietTime;
    if (this.quietTime < this.minQuiet) this.quietTime = this.minQuiet;

    this.started = {observer:[], progress:[], progress_document:[]};

    if (this.waitXHR) {
      OBSRV.addObserver(this, "http-on-modify-request", false);
      OBSRV.addObserver(this, "http-on-examine-response", false);
      OBSRV.addObserver(this, "http-on-examine-cached-response", false);
      OBSRV.addObserver(this, "http-on-examine-merged-response", false);
    }
  },

  detatch: function () {
    if (this.progress)
      this.progress.removeProgressListener(this);
    this.progress = null;
    if (this.waitXHR) {
      OBSRV.removeObserver(this, "http-on-modify-request");
      OBSRV.removeObserver(this, "http-on-examine-response");
      OBSRV.removeObserver(this, "http-on-examine-cached-response");
      OBSRV.removeObserver(this, "http-on-examine-merged-response");
    }
  },

  onTimeout: function () {
    for (let key in this.started) {
      let started = this.started[key];
      this.task.warn("(" + key
                     + ") Following pages taking too long to finish:",
                     this.step);
      for (let i=0; i<started.length; i++) {
        this.task.warn("*" + started[i].name, this.step);
      }
    } 
  },

  // This is implementing nsISupports and lets things know what interfaces
  // this object handles.  Naturally we're a progress listener but we also
  // can provide weak references to ourself thanks to XPConnect.
  QueryInterface: function(aIID) {
    if (aIID.equals(Ci.nsIWebProgressListener) ||
        aIID.equals(Ci.nsIObserver) ||
        aIID.equals(Ci.nsISupportsWeakReference) ||
        aIID.equals(Ci.nsISupports))
      return this;
    throw Components.results.NS_NOINTERFACE;
  },

  removeRequest: function (aRequest, key) {
    let started = this.started[key];
    for (var i=0; i<started.length; i++) {
      if (started[i] === aRequest) {
        started.splice(i, 1);
        this.task.debug("REMOVED " + key + " request: " + aRequest.name, this.step);
        break;
      }
    }
  },

  requestStart: function (aRequest, key) {
    // Guarantee unique requests
    this.removeRequest(aRequest, key);
    this.task.info("  started: " + aRequest.name, this.step);
    this.task.addRunDatumUrlEvent(aRequest.name, "start", this.step);
    this.started[key].push(aRequest);
  },

  keysEmpty: function (obj) {
    let total = 0;
    for (let key in obj) {
      total += obj[key].length;
    }
    return total === 0;
  },

  requestStop: function (aRequest, key) {
    let httpChannel;
    let statusText = "";
    // Not all requests are HTTP channels
    try {
      //TODO: This works but why slow it down more, commenting just in case
      //httpChannel = aRequest.QueryInterface(Ci.nsIHttpChannel);
    } catch (e) {
    }
    // TODO: This slows it down too much or something and responses get missed
    if (false && typeof(httpChannel) === 'object') {
      statusText += " ("+ httpChannel.responseStatus + " " + httpChannel.responseStatusText + ") ";
      if (httpChannel.responseStatus < 400) {
        this.task.info("  completed" + statusText + aRequest.name, this.step);
      } else {
        this.task.warn("  failed" + statusText + aRequest.name, this.step);
      }
      var headerText = "  REQUEST: \n";
      let visitor = {
        "channel": httpChannel,
        "host":httpChannel.URI.host,
        "visitHeader": function (header, value) {
          headerText += "  " + header + ": " + value + "\n"
        }
      }
      httpChannel.visitRequestHeaders(visitor);
      this.task.debug(headerText, this.step);
      headerText = "  RESPONSE: \n";
      httpChannel.visitResponseHeaders(visitor);
      this.task.debug(headerText, this.step);
    } else {
      //this.task.info("  completed (no HTTP status) " + aRequest.name, this.step);
      this.task.info("  completed " + aRequest.name, this.step);
    }

    this.task.addRunDatumUrlEvent(aRequest.name, "stop", this.step);
    // Remove it from the array of pages we're waiting for
    this.removeRequest(aRequest, key);
    if (this.keysEmpty(this.started.progress)
         && this.keysEmpty(this.started.progress_document)
         && this.keysEmpty(this.started.observer)) {
      var context = this;
      this.task.info("  All pages loaded, waiting.", this.step);
      // The array of pending pages is empty, wait to allow new requests to start.
      this.quietTimer.initWithCallback(function () {
        if (context.keysEmpty(context.started)) {
          context.task.info("No new requests, load complete.", context.step);
          Components.utils.import('resource://indexdata/util/waitForLoad.js');
          waitForLoad.detatch();
        }
      }, this.quietTime, Ci.nsITimer.TYPE_ONE_SHOT);
    }
  },

  observe: function(subject, topic, data) {
    let channel = subject.QueryInterface(Ci.nsIChannel);
    if (topic === "http-on-examine-response"
        || topic === "http-on-examine-cached-response"
        || topic === "http-on-examine-merged-response")  {
      this.requestStop(subject, 'observer');
    } else if (topic === "http-on-modify-request") {
      try {
        let callbacks = channel.notificationCallbacks;
        let xhrRequest = callbacks ?
                           callbacks.getInterface(Ci.nsIXMLHttpRequest)
                           : null;
        // Only use the observer for XHR requests. To use the observer for
        // all requests use justObserve.js
        if (xhrRequest && topic === "http-on-modify-request") {
          this.requestStart(subject, 'observer');
        }
      } catch (e) {
      }
    }  
  },

  onStateChange: function(aWebProgress, aRequest, aFlag, aStatus) {
    // This fires when the load event is initiated

    // Old dump code to get hex output
    // dump("STATE FLAG: 0x" + parseInt(aFlag.toString(2).substr(-8),2).toString(16) + " " + aRequest.name + "\n");

    // Function to dump a list of associated flags.
    var wplFlagDump = function(flags, req) {
      var output;
      var flagStrings = "STATE_START STATE_REDIRECTING STATE_TRANSFERRING STATE_NEGOTIATING STATE_STOP STATE_IS_REQUEST STATE_IS_DOCUMENT STATE_IS_NETWORK STATE_IS_WINDOW STATE_RESTORING STATE_IS_INSECURE STATE_IS_BROKEN STATE_IS_SECURE STATE_SECURE_HIGH STATE_SECURE_MED STATE_SECURE_LOW".split(" ");
      output = ("onStateChange FLAGS! " + req.name + " ::: ");
      for (var i=0; i<flagStrings.length; i++) {
        if (eval("Ci.nsIWebProgressListener." + flagStrings[i] + " & flags"))
          output += (flagStrings[i] + " ");
      }
      return output;
    };

    this.task.debug (wplFlagDump(aFlag, aRequest), this.step);
    if (aFlag & STATE_IS_DOCUMENT) {
      if (aFlag & STATE_START) {
        this.requestStart(aRequest, 'progress_document');
      }
      if (aFlag & STATE_STOP || aFlag & STATE_REDIRECTING) {
        this.requestStop(aRequest, 'progress_document');
      }
    } else {
      if (aFlag & STATE_START) {
        this.requestStart(aRequest, 'progress');
      }
      if (aFlag & STATE_STOP) {
        this.requestStop(aRequest, 'progress');
      }
    } 
    for (let key in this.started) {
      var started = this.started[key];
      this.task.debug (started.length + " " + key + " requests REMAIN:");
      for (var i=0; i<started.length; i++) {
        this.task.debug("   " + i + ". " + started[i].name, this.step);
      }
    }
    return 0;
  },

  onProgressChange: function(aProgress, aRequest, aCurSelfProgress, aMaxSelfProgress, aCurTotalProgress, aMaxTotalProgress) {
      var dumpRequest = aRequest
      if ( dumpRequest == null ) // defensive coding
          dumpRequest = { name: "NULL" };
    this.task.debug("  Progress: " + dumpRequest.name + " cur=" + aCurSelfProgress + " max=" + aMaxSelfProgress + " curTotal=" + aCurTotalProgress + " maxTotal=" + aMaxTotalProgress, this.step);
    return 0;
  },
  onLocationChange: function(aProgress, aRequest, aURI) {return 0;},
  onStatusChange: function() {return 0;},
  onSecurityChange: function() {return 0;},
  onLinkIconAvailable: function() {return 0;}
};
