var EXPORTED_SYMBOLS = ["Level", "logging"];

var Level = {
  DEBUG: 0,
  INFO: 1,
  WARN: 2,
  ERROR: 3,
  getName: function (level) {
    var levelName = "UNKNOWN";
    for (var name in Level) {
      if (Level[name] == level) {
        return name;
      }
    }
  },
  hasLevel: function (levelName) {
    return this.hasOwnProperty(levelName) ? true : false;
  }
};

//basic STDOUT appender
var ConsoleAppender = function() { this.name = "console"};
ConsoleAppender.prototype.append = function (prefix, levelName, message) {
  dump(prefix + levelName + " " + message + "\n");
};

ConsoleAppender.prototype.toString = function() {
  return "ConsoleAppender";
};


var Logger = function (parent, level, appenders, qName) {
  this._qName = qName;
  this._level = typeof level == "number" ? level : parent.getLevel();
  this._appenders = typeof appenders == "object"
    ? appenders : parent.getAppenders().slice();
};

Logger.prototype.toString = function () {
  return this._qName;
};

Logger.prototype._timestamp = function () {
  //return msecs = new Date().toString()+" ";

  // left fill numbers with zero: 8 => "08"
  function ft (number) {
	return number >= 10 ? "" + number : "0" + number;
  }

  try {
    //return new Date().format("H:i:s-d/m" );
    var dt = new Date();
    var da = dt.getDate();
    var mo = dt.getMonth() + 1;
    var hr = dt.getHours();
    var mi = dt.getMinutes();
    var se = dt.getSeconds();
    return "" + ft(hr) + ":" + ft(mi) + ":" + ft(se) +
           "-" + ft(da) + "/" + ft(mo) + " ";
  } catch (e) {
    return "??";  // should not happen
      // was needed when I messed with the time format, but
      // leaving here just in case things go wrong - can't
      // risk loosing logs...
  }

}

Logger.prototype.log = function (level, message, prefix) {
  if (level < this._level) return;
  var levelName = Level.getName(level);
  if (!prefix) prefix = "";
  prefix = this._timestamp() + prefix;
  if (typeof message == "object" && message != null) {
    //pick up exceptions
    //duck typing, we consider every object to be an exception if contains
    //the following
    if ("name" in message && "message" in message && "fileName" in message
        && "lineNumber" in message && "stack" in message) {
      message = message.name + ": '" + message.message + "' at "
        + message.fileName + ":" + message.lineNumber + "\nstack trace:\n"
        + message.stack;
    }
  }
  for (var i=0; i<this._appenders.length; i++) {
    this._appenders[i].append(prefix, levelName, message);
  }
};
Logger.prototype.debug = function (message, prefix) {
    this.log(Level.DEBUG, message, prefix);
};
Logger.prototype.info = function (message, prefix) {
    this.log(Level.INFO, message, prefix);
};
Logger.prototype.warn = function (message, prefix) {
    this.log(Level.WARN, message, prefix);
};
Logger.prototype.error = function (message, prefix) {
    this.log(Level.ERROR, message, prefix);
};
Logger.prototype.getLevel = function () {
  return this._level;
};
Logger.prototype.setLevel = function (level) {
  this._level = level;
};
Logger.prototype.getAppenders = function () {
  return this._appenders;
};
Logger.prototype.addAppender = function (appender) {
    this._appenders.push(appender);
};

Logger.prototype.removeAppender = function (appender) {
  for (var i=0; i<this._appenders.length; i++) {
    if (appender === this._appenders[i])
      this._appenders[i].splice(i,1);
      return true;
  }
  return false;
};

function dumpObjR(obj, rlevel, level, seen, indent, initIndent, dumpFunc) {
  if (seen.indexOf(obj) == -1) {
    seen.push(obj);
    for (var key in obj) {
      try {
        var val = obj[key];
        if (typeof val == "function") {
          if (dumpFunc) val = "function"; else continue;
        }
        dump(indent+key+"="+val+"\n");
        if ((rlevel < 0 || level < rlevel) && typeof val == "object"
            && val != null && val != undefined)
          dumpObjR(val, rlevel, level+1, seen, indent+initIndent, initIndent, dumpFunc);
      } catch (e) {
        dump(indent+"[cannot read '" + key + "' - " + e.message + "]\n");
      }
    }
  } else {
    dump(indent+"[repeated reference, object already dumped]\n");
  }
}

Logger.prototype.dumpObj = function (obj, rlevel, dumpFunc, indentWith) {
  var rl = typeof rlevel == "number" ? rlevel : 0;
  var c = typeof indentWith == "string" ? indentWith : " ";
  var dF = typeof dumpFunc == "boolean" ? dumpFunc : false;
  var seen = [];
  // standard to string first, then traverse
  var type = typeof obj;
  dump("Dump: " + type + " " + obj + "\n");
  if (type == "object")
    dumpObjR(obj, rl, 0, seen, c, c, dumpFunc);
};

// PRIVATE to rdump()
Logger.prototype._rdump1 = function (obj, level, seenKeys) {
  if (seenKeys[obj]) return "[LOOP]";
  seenKeys[obj] = 1;

  var indent = "";
  for (var i = 0; i < level; i++) indent += "  ";

  if (typeof obj === "undefined") {
    return "undefined";
  } else if (typeof obj === "number") {
    return obj;
  } else if (typeof obj === "string") {
    return '"' + obj + '"';
  } else if (Array.isArray(obj)) {
    var res = "array [\n";
    for (var key in obj) {
      var val = this._rdump1(obj[key], level+1, seenKeys);
      res += indent + "  " + key + ": " + val + "\n";
    }
    return res + indent + "]";

  } else if (typeof obj == "object") {
    var res = "object {\n";
    for (var key in obj) {
      var val = this._rdump1(obj[key], level+1, seenKeys);
      res += indent + "  " + key + " => " + val + "\n";
    }
    return res + indent + "}";
  }

  return "unsupported object type " + typeof obj;
};

// Recursive dump routine: returns a string; does NOT log it.
Logger.prototype.rdump = function (obj) {
  var seenKeys = [];
  return this._rdump1(obj, 0, seenKeys);
};

// Test with:
//      var foo = [ 4, "foo", [ 5, 6, { foo: 34, bar: 32 }]];
//      foo.push(foo);
//      print(rdump(foo));
//      print(rdump(foo));


var logging = {
  /**
   * Root logger initliazed to a deafult, console appender.
  **/
  _loggers: {},
  _init: function () {
    var prefs = Components.classes["@mozilla.org/preferences-service;1"]
      .getService(Components.interfaces.nsIPrefService)
      .getBranch("indexdata.cf.");
    var level = Level.INFO;
    try {
      var rlPref = prefs.getCharPref("logging.root");
      if (Level.hasLevel(rlPref)) level = Level[rlPref];
    } catch (e) {}; //silent if no property
    dump("Root logging set to " + Level.getName(level) + "\n");
    var rl = new Logger(null, level, [new ConsoleAppender()], 'root');
    this._loggers['root'] = rl;
  },
  /**
   * Retrieve logger with a qualified name.
  **/
  getLogger: function (qName) {
    if (!qName) return this._loggers['root'];
    if (this._loggers[qName]) {
      return this._loggers[qName];
    } else { return this.createLogger(qName); }
  },
  /**
   * Creates logger with optional default level and appenders - if none
   * specified uses the values from the root logger.
  **/
  createLogger: function (qName, level, /*array*/ appenders) {
    this._loggers[qName] =
      new Logger(this._loggers['root'], level, appenders, qName);
    return this._loggers[qName];
  },
  modifyLoggers: function (/*array*/ appenders) {
    for (key in this._loggers) {
	  this._loggers[key]._appenders = appenders;
    }
  }
};
logging._init();
