var EXPORTED_SYMBOLS = ["mozHelper"];

var mozHelper = {
  getDoc: function () {
    var mainWindow = window.QueryInterface(Components.interfaces.nsIInterfaceRequestor)
      .getInterface(Components.interfaces.nsIWebNavigation)
      .QueryInterface(Components.interfaces.nsIDocShellTreeItem)
      .rootTreeItem
      .QueryInterface(Components.interfaces.nsIInterfaceRequestor)
      .getInterface(Components.interfaces.nsIDOMWindow);

  },
  openWindow: function (cb, url, name, features) {
    var ww = Components.classes["@mozilla.org/embedcomp/window-watcher;1"]
      .getService(Components.interfaces.nsIWindowWatcher);
    var win = ww.openWindow(null, url, name, features, null);
    win.addEventListener("load", cb, false);
    return win;
  },
  openBrowser: function (cb) {
    return mozHelper.openWindow(cb, "chrome://cfbuilder/content/page.xul", 
        "Browser", "chrome,centerscreen,height=800,width=600");
  },
  openOrFocusWindow: function (cb, url, name, features) {
    var ww = Components.classes["@mozilla.org/embedcomp/window-watcher;1"]
      .getService(Components.interfaces.nsIWindowWatcher);
    var win = ww.getWindowByName(name, null);
    if (win == null) {
      win = ww.openWindow(null, url, name, features, null);
      win.addEventListener("load", cb, false);
    } else {
      win.focus();
    }
    return win;
  }
};
