var ExtractChronology = function () {
  this.conf = {
    container: undefined,
    "in": undefined,
    out: undefined,
  };
};

ExtractChronology.regexps =
  [
   // Category, then regexp, then pairs of match-indexes and destination field
   [ "volume", /(\d+)\s*\((\d+)\)/,         [1, "volume"], [2, "issue"] ],
   [ "pages",  /(\d+)\s*(-|–|&ndash;)\s*(\d+)/, [1, "page"], [3, "endpage"] ],
   [ "year",   /\b[a-z]{3}\s+(\d{4})\b/i,   [1, "date"] ], // ### ignores month
   [ "volume", /Volume\s+(\d+)/i,           [1, "volume"] ],
   [ "issue",  /Issue\s+(\d+)/i,            [1, "issue"] ],
   // Fallback follows if we can't do any better at guessing a year
   [ "year",   /\b[A-Z][a-z]+\s+(\d{4})\b/, [1, "date"] ],
  ];

/*
 * Strategy: we work our way down the list of pre-cooked regular
 * expressions, trying each one against the input string.  When we get
 * a match, we copy the matching sub-expressions into the specified
 * output fields, remove the whole of the matching string, and make a
 * note that we have a match in the specified category.  Subsequent
 * regular expressions in the same category are skipped, so that we
 * avoid accidentally overwriting a good match with a less good one.
 */
ExtractChronology.extract = function(s) {
  var results = [];

  for (var i = 0; i < ExtractChronology.regexps.length; i++) {
    var ref = ExtractChronology.regexps[i];
    var matches = ref[1].exec(s);
    if (!matches) {
      //print("'" + s + "' does not match " + ref[1] + "\n");
    } else {
      //print("'" + s + "' matches " + ref[1] + "\n");
      s = s.replace(ref[1], "");
      for (var j = 2; j < ref.length; j++) {
        var pair = ref[j];
        results[pair[1]] = matches[pair[0]];
        //print("set '" + pair[1] + "' to match #" + pair[0] + " = '" + matches[pair[0]]+ "'");
      }
    }
  }

  var summary = "";
  for (var key in results) {
    if (summary) summary += ", ";
    summary += key + "=" + results[key];
  }

  return summary;
}


var Citations =
  [
   // Scirus
   "Toxicology , 276 (1), p.49-57,  Sep 2010 The mechanisms",
   "Biopolymers , 93 (9), p.764-776,  Sep 2010 ...of the",
   "Applied microbiology and biotechnology , 87 (3), p.899-911,  Jul 2010 Mycotoxins are",
   // Wiley Online Library
   "Biopolymers Volume 32, Issue 12, December 1992, Pages: 1643–1664, F. Eisenhaber and W. Schulz Article first published online : 1 FEB 2004, DOI: 10.1002/bip.360321207 Abstract PDF(1584K) References",
   "Regulated Rivers: Research & Management Volume 12, Issue 4-5, July 1996, Pages: 535–545, S. HELLSTEN, M. MARTTUNEN, R. PALOMÄKI, J. RIIHIMÄKI and E. ALASAARELA Article first published online : 4 DEC 1998, DOI: 10.1002/(SICI)1099-1646(199607)12:4/5<535::AID-RRR408>3.0.CO;2-Q Abstract PDF(827K) References",
   "Hydrological Processes Volume 16, Issue 12, 30 August 2002, Pages: 2497–2498,  Article first published online : 7 AUG 2002, DOI: 10.1002/hyp.5065 Abstract PDF(54K)",
   "Korrosion und Korrosionsschutz Egon Kunze, Pages: 2333&ndash;2412, 2009 Published Online : 16 MAR 2009, DOI: 10.1002/9783527625659.ch5d Summary PDF(4466K) References",
   // Cambridge Journals
   "Epidemiology and Infection ,  Volume 13 ,  Issue 04  , pp 393 -402  doi:10.1017/S0022172400005490  (About doi) , Available on CJO 15 May 2009 ",
   "Experimental Agriculture ,  Volume 23 ,  Issue 02  , pp 201 -206  doi:10.1017/S0014479700016999  (About doi) , Available on CJO 03 October 2008 ",
   "The Journal of Agricultural Science ,  Volume 137 ,  Issue 03  , pp 307 -318  doi:10.1017/S0021859601001411  (About doi) , Available on CJO 23 January 2002 ",
   ];

for (var i = 0; i < Citations.length; i++) {
  s = Citations[i];
  print((i+1) + " of " + Citations.length + ": " + s);
  print("\t" + ExtractChronology.extract(s));
}
