var EXPORTED_SYMBOLS = ["waitForLoad"];
Components.utils.import('resource://indexdata/util/xmlHelper.js');
Components.utils.import('resource://indexdata/util/loadDetectors/progressListen.js');
Components.utils.import('resource://indexdata/util/loadDetectors/justObserve.js');
Components.utils.import('resource://indexdata/util/loadDetectors/windowEvent.js');

var waitForLoad = {
  timer: null,
  startTime: null,
  detector: null,
  conf: null,
  detectors: {
    "justObserve":justObserve,
    "progressListen":progressListen,
    "windowEvent":windowEvent
  },
  task: null,
  isEngine: false,
  defaultConf: {
    detector: "progressListen",
    timeout: 30000,
    errorOnTimeout: true
  },

  wait: function(task, conf, step) {
    task.info("Waiting for page to load:", step);
    if (this.detector != null) {
      this.detector.detatch();
      task.warn("Previous page wait did not end cleanly.", step);
    }

    if (conf && !conf.active) return;
    if (!conf) var conf = this.defaultConf;
    if (!conf.detector) conf.detector = this.defaultConf.detector;
    if (!conf.timeout) conf.timeout = this.defaultConf.timeout;
    if (typeof conf.errorOnTimeout === "undefined")
      conf.errorOnTimeout = (conf.timeout >= 30000);
    this.task = task;
    this.step = step;
    this.conf = conf;
    this.detector = this.detectors[conf.detector];
    this.detector.wait(task, conf);

    // Interrupt the task.
    var context = this;
    this.timer = task.interrupt(conf.timeout, function () {
      if (context.detector.onTimeout) context.detector.onTimeout();
      let errorText = "Page timed out after " + conf.timeout + "ms";
      if (context.conf.errorOnTimeout) {
        context.detatch(errorText);
      } else {
         context.task.warn("Page timed out after " + conf.timeout + "ms, continuing with DOM as-is.", context.step);
         context.detatch();
      }
      return true;
    });

    this.startTime = +new Date();
  },

  detatch: function(error) {
    var elapsed = ((+new Date()) - this.startTime) / 1000;
    this.timer.cancel();
    this.detector.detatch();
    this.detector = null;
    if (this.task) {
      if (error) {
        this.task._error(error, this.step);
        throw new Error("Failure during page load after " + elapsed + " seconds.");
      } else {
        var msg = "Load complete in " + elapsed + " seconds.";
        this.task.info(msg, this.step);
        this.task.data.system.location = this.task.connector.getRealPageUrl();
      }
    } else {
      throw new Error("Load detector missing task, cannot continue.");
    }
    if (this.task.connector.getPageDoc().documentElement) {
      this.task.resume();
    } else {
      throw new Error("Document empty---no root element.");
    }
  },

  stepXul: function (surface, conf) {
    if (typeof(conf) !== 'object')
      throw new Error("Invalid conf object for waitForLoad.stepXul()");
    if (!conf.active)
      conf.active = false;

    // container
    var box = xmlHelper.appendNode(surface, "hbox");

    // checkbox
    var attributes = { label: "Wait for page load?" };
    if (conf.active)
      attributes.checked = true;
    var check = xmlHelper.appendNode(box, "checkbox", null, attributes);
    check.addEventListener("command", function(e) {
      conf.active = this.checked;
    }, false);

    // config button
    attributes = {"label": "Configure load detection..."};
    if (conf.detector)
      attributes.style = "font-weight:bold;";
    var button = xmlHelper.appendNode(box, "button", null, attributes);
    var context = this;
    button.addEventListener("command", function(e) {
      Components.utils.import("resource://indexdata/ui/app.js");
      var confWin = app.mainWindow.open(
        'chrome://cfbuilder/content/load_detector_config.xul',
        'loadDetectorWindow', 'chrome,resizable=yes');
      // is there a nicer way to pass this reference?
      confWin.conf = conf;
      confWin.focus();
    }, false);
    return box;
  },


  drawConfig: function (win) {
    var conf = win.conf;
    var doc = win.document;

    var timeoutInput = doc.getElementById("timeout");
    if (conf.timeout)
      timeoutInput.value = conf.timeout;
    else
      timeoutInput.value = waitForLoad.defaultConf.timeout;
    timeoutInput.addEventListener("input", function(e) {
      conf.timeout = parseInt(timeoutInput.value);
    }, false);

    if (typeof conf.errorOnTimeout === "undefined")
      conf.errorOnTimeout = (conf.timeout >= 30000);
    var errTimeCheck = doc.getElementById("errorOnTimeout");
    if (conf.errorOnTimeout) errTimeCheck.checked = true;
    errTimeCheck.addEventListener("command", function(e) {
      conf.errorOnTimeout = this.checked;
    }, false);

    var detectorMenu = doc.getElementById("detectorMenu");
    var detectorPopup = detectorMenu.firstChild;
    var detectorSurface = doc.getElementById("specificBox");
    for (key in waitForLoad.detectors) {
      var d = waitForLoad.detectors[key];
      var selected = false;
      if (conf.detector) {
        if (conf.detector==key)
          selected = true;
      }
      else if (waitForLoad.defaultConf.detector==key)
        selected = true;
      var item = xmlHelper.appendNode(detectorPopup, "menuitem", null,
        {label:d.getDisplayName(), value:key, selected:selected});
      if (selected)
        detectorMenu.selectedIndex = detectorMenu.getIndexOfItem(item);
    }

    waitForLoad.detectors[detectorMenu.selectedItem.value].draw(detectorSurface, conf);

    detectorMenu.addEventListener("select", function(e) {
      conf.detector = detectorMenu.selectedItem.value;
      xmlHelper.emptyChildren(detectorSurface);
      waitForLoad.detectors[conf.detector].draw(detectorSurface, conf);
    }, false);
  }
};
