var EXPORTED_SYMBOLS = ["xulHelper"];
var xulHelper = null;

// Only initialise the xulHelper object in the builder TODO: proper separation of app
let xulAppInfo = Components.classes["@mozilla.org/xre/app-info;1"].getService(Components.interfaces.nsIXULAppInfo);
if (xulAppInfo.name !=="ConnectorFramework") { /* BEGIN BUILDER ONLY WRAPPER */

var EXPORTED_SYMBOLS = ["xulHelper"];
Components.utils.import('resource://indexdata/util/xmlHelper.js');
Components.utils.import('resource://indexdata/util/jsonPathHelper.js');
Components.utils.import('resource://indexdata/thirdparty/jsonPath.js');
Components.utils.import('resource://indexdata/util/inspector.js');
Components.utils.import('resource://indexdata/ui/XpathRefine.js');
Components.utils.import('resource://indexdata/ui/app.js');
Components.utils.import('resource://indexdata/util/logging.js');

var logger = logging.getLogger();

xulHelper = {

  // since we want to leave listhead and listcols and such
  clearList: function(list) {
    var items = list.getElementsByTagName('listitem');
    while(items.length > 0) {
      list.removeChild(items[items.length - 1]);
    }
  },

  // we often only want to add flex if horizontal
  onlyFlexSideways: function(element, box, flex) {
    if (typeof(flex) !== 'number') flex = 1;
    if (app.mainWindow.getComputedStyle(box)
        .getPropertyValue('-moz-box-orient') === 'horizontal') {
      element.setAttribute('flex', flex);
    }
  },

  // Separator - a line across the surface
  // style can be one of: groove, groove-thin, thin
  separator: function(parentnode, style) {
    if ( ! style )
      style = "groove";
    var attributes = { class: style };
    var sep = xmlHelper.appendNode(parentnode,"separator", null, attributes);
  },
  
  // Simple helpers to produce input elements for the step-editing screens
  captionField: function(parentnode, caption, attributes) {
    //var capt = xmlHelper.appendNode(parentnode, "caption", caption, attributes);
    // TODO - This ought to avoid some warnings about XUL elements...
    if ( ! attributes )
      attributes = {};
    attributes["label"] = caption;
    var capt = xmlHelper.appendNode(parentnode, "caption", null, attributes);
    return capt;
  },

  labelField: function(parentnode, caption, attributes) {
    if ( ! attributes )
      attributes = {};
    attributes["value"] = caption;
    var lbl = xmlHelper.appendNode(parentnode, "label", null, attributes);
    return lbl;
  },

  inputField: function(parentnode, step, confindex, caption, captionWidth, attributes) {
    var hbox = xmlHelper.appendNode(parentnode, "hbox", null,
        { align: "center" }, null);
    // Callers passing flex through to the field will also need the hbox to flex.
    // But only horizontally.
    if ( attributes && attributes["flex"] ) {
      xulHelper.onlyFlexSideways(hbox, parentnode, attributes["flex"]);
    }
    var captattr = { width: captionWidth };
    if (captionWidth === undefined)
      captattr = { flex:1 };
    xulHelper.captionField(hbox, caption, captattr );
    return xulHelper.inputFieldOnly(hbox, step, confindex, attributes);
  },

  inputFieldOnly: function(parentnode, step, confindex, attributes) {
    if (attributes == null) attributes = {};
    if (confindex != "") {
      var v = step.conf[confindex];
      attributes.value = (v == undefined) ? "" : v;
    }
    var input = xmlHelper.appendNode(parentnode, "textbox", null, attributes, null);

    input.addEventListener("input", function(e) {
      if (confindex != "") {
        step.conf[confindex] = input.value;
        logger.debug("Change event on input [" + confindex  + "] " +
            "'" + input.value + "'\n");
      }
    }, false);

    input.cf_setValue = function(v) {
      if ( confindex != "" )
        step.conf[confindex] = v;
      input.value = v;
    };
    return input;
  },

  xpathField: function(parentnode, step, confindex, caption) {
    var hbox = xmlHelper.appendNode(parentnode, "hbox", null, null, null);
    //var input = xulHelper.inputField(hbox, step, confindex, caption);
    // Detail: this creates another hbox inside the current one, do we care?
    // caption
    xmlHelper.appendNode(hbox, "caption", caption,
      { width: 220 }, null);
    var input = xulHelper.singleNodeField(hbox, step, confindex);
    return input;
  },

  selectField: function(parentnode, step, confindex, caption, options, attributes) {
    var hbox = xmlHelper.appendNode(parentnode, "hbox", null, { align: "center" }, null);
    xmlHelper.appendNode(hbox, "caption", caption, null, null);
    if (!attributes)
        attributes = {};
    var menulist = xmlHelper.appendNode(hbox, "menulist", null, attributes, null);
    var menupop = xmlHelper.appendNode(menulist, "menupopup", null, null, null);
    var v = step.conf[confindex];
    var selidx = -1
    var i = 0;
    for ( var optname in options ) {
      if (!v){ // value not set, default to the first
        v=optname;
        step.conf[confindex]=v;
      }
      var disp = options[optname];
      if (!disp)
        disp = optname;
      var attrs = { "label": disp, "value" : optname };
      if ( v == optname ) {
        attrs.selected = true;
        selidx = i;
      }
      xmlHelper.appendNode(menupop, "menuitem", null, attrs, null );
      i++;
    }
    // Some times the selected item doesn't stick! This forces it
    if ( menulist.selectedIndex < 0 ) {
      logger.debug("forcing selectField selection to " + selidx + "\n");
      menulist.selectedIndex = selidx;
    }
    menulist.addEventListener("command", function(e) {
        step.conf[confindex]=menulist.value;
    }, false);
    return menulist;
  },


  // Basically an input field that remembers its history, and offers a pull-down
  // option to select one of the previous values. The history is kept in the
  // config, under the histindex.
  // DEPRECATED - Was only used by parse_xpattern, long time ago
  historySelectField: function(parentnode, step, confindex, caption, histindex) {
    var hbox = xmlHelper.appendNode(parentnode, "hbox", null, null, null);
    xmlHelper.appendNode(hbox, "caption", caption, { width: 220 }, null);
    var menulist = xmlHelper.appendNode(hbox, "menulist");
    menulist.setAttribute("editable",true);
    var menupop = xmlHelper.appendNode(menulist, "menupopup");
    prependHistory();

    menulist.addEventListener("command", function(e) {
      logger.debug("historySelectField: command event v='" + menulist.value + "' " +
             " l='" + menulist.label + "'\n");
      step.conf[confindex] = menulist.value;
      prependHistory();
    },false);

    menulist.addEventListener("change", function(e) {
      logger.debug("historySelectField: change event  v='" + menulist.value + "' " +
          " l='" + menulist.label + "'\n");
      step.conf[confindex] = menulist.value;
      prependHistory();
    },false);

    menulist.setNewValue = function(val) {
      logger.debug("setNewValue: old='" + step.conf[confindex] + "' " +
           "new='" + val + "'\n");
      menulist.value = val;
      prependHistory(val);
    }; // setnewValue
    return menulist;

    function prependHistory(newval) {  // inside historySelectField
      var newhist = [];
      if (newval && newval != step.conf[confindex]) { // new is usually undefined
        logger.debug("prependHistory: starting with " +
            "Old: '" + step.conf[confindex] + "' " +
            "new: '" + newval + "' \n");
        var oldval = step.conf[confindex];
        newhist.push(newval);
        step.conf[confindex] = newval;
        newhist.push(oldval);
      } else {
        newhist.push ( step.conf[confindex] );
        logger.debug("prependHistory: starting with '" + step.conf[confindex] + "' \n");
      }
      if ( step.conf[histindex] == undefined){
        logger.debug("prependHistory: Creating new history\n");
        step.conf[histindex] = [];
      }
      logger.debug("prependHistory: before: h.length=" + step.conf[histindex].length + "\n");
      var i;
      for ( let i=0; (i<step.conf[histindex].length) && (newhist.length<10); i++) {
        if (step.conf[histindex][i] != step.conf[confindex] ) {
          logger.debug("_prependHistory: adding '" + step.conf[histindex][i] + "' \n");
          newhist.push(step.conf[histindex][i]);
        }
      }
      step.conf[histindex] = newhist;
      logger.debug("prependHistory: after: h.length=" + step.conf[histindex].length + "\n");
      logger.debug("prependHistory: menupop= " + menupop + "\n");
      xmlHelper.emptyChildren(menupop);
      for ( let i=0; i<step.conf[histindex].length; i++) {
        var val = step.conf[histindex][i];
        xmlHelper.appendNode(menupop, "menuitem", null,
          { label: val, value: val, selected: (i==0) });
      }
      //xmlHelper.dumpxml(menulist);
    }; // prependHistory inside historySelectField


  }, // historySelectField

  // Simple pull-down menu.
  // Takes a simple array of strings for the values OR an array of object
  // of the form {key:"display value", value:"some value"}
  // extraoptions is usually not provided, but can be used to add options to
  // the beginning of the list, for example ["none"].
  // Some times all the values come from extraoptions, and options itself
  // can be empty.
  //
  // ...or takes a hash with option values mapping to display names,
  // for example { 'ti': 'Title', 'au': 'Author' }
  arraySelectField: function(parentnode, step, confindex, options, extraoptions) {
    logger.debug("arraySelectField: Starting with " + options.length + " items -----\n");
    var theSelectedItem = undefined;
    var i;

    if ( ! options ) {
      // defensive coding, any kind of non-value will do
      
      logger.debug("arraySelectField called without options\n");
      logger.debug("confindex='" + confindex + "'\n");
      logger.debug("options='" + options + "'\n");
      logger.debug("extraoptions='" + extraoptions + "'\n");
      
      options = [];
    } else if (typeof(options) != "object") {
      throw new Error("Invalid options parameter to arraySelectField.");
    }

    var menulist = xmlHelper.appendNode(parentnode, "menulist");
    var menupop = xmlHelper.appendNode(menulist, "menupopup");
    var selected = (!confindex || !step.conf[confindex]);

    // build menu one way for an array, somewhat differently for a hash/object
    if (Array.isArray(options)) {
      if (extraoptions && extraoptions.length) {
        var dedupped = [];
        for (let i = 0; i < extraoptions.length; i++) {
          var val = extraoptions[i];
          if (val !== "" && options.indexOf(val) < 0) {
            dedupped.push(val);
          }
        }
        options = dedupped.concat(options);
      }

      for (let i = 0; i < options.length; i++) {
        let item = options[i];
        let key = '';
        let value = '';
        if (typeof item == 'object' && 'value' in item && 'key' in item) {
          key = item.key;
          value = item.value;
        } else {
          key = item;
          value = item;
        }
        if (confindex && step.conf[confindex] == value)
          selected = true;
        if (!confindex && i==0)
          selected = true;
        if (selected) {
          theSelectedItem = xmlHelper.appendNode(menupop, "menuitem", null,
            { label: key, value: value, selected: true });
        } else {
          xmlHelper.appendNode(menupop, "menuitem", null,
            { label: key, value: value });
        }
        selected = false;
      }
    } else {
      for (var key in options) {
        if (confindex && step.conf[confindex] == options[key])
          selected = true;

        if (selected) {
          theSelectedItem = xmlHelper.appendNode(menupop, "menuitem", null,
            { label: key, value: options[key], selected: true });
        } else {
          xmlHelper.appendNode(menupop, "menuitem", null,
            { label: key, value: options[key] });
        }
        selected = false;
      }
    }
    // the above setting of the selected attribute on the menuitem
    // elements doesn't seem to always stick, but setting the
    // selectedItem won't work the first time a step is drawn.
    // so we do one, and if it wasn't enough, we do the other
    if (menulist.selectedIndex < 0)
      menulist.selectedItem = theSelectedItem;

    if (menulist.selectedItem && menulist.selectedItem.value) {
        if (confindex) {
            logger.debug("*** arraySelectField() setting conf[" + confindex + "]\n");
            step.conf[confindex] = menulist.selectedItem.value;
            logger.debug("*** arraySelectField() has set conf[" + confindex + "]\n");
        }
      logger.debug("setting step.conf[" + confindex + "] to '" + step.conf[confindex] + "'\n");
    }

    menulist.addEventListener("command", function(e) {
        if (confindex) {
            step.conf[confindex] = menulist.selectedItem.value;
        }
      }, false);
    logger.debug("arraySelectField() returning " + menulist + " = <" + menulist.localName + ">\n");
    return menulist;
  },

  // Force the selection to value. If not found, leaves untouched,
  // unless makeit is true, in which case will make the new option
  // at the end of the list
  selectMenulistItemWithValue: function(menulist, value, makeit) {
    var i = 0;
    logger.debug("selectMenulistItemWithValue() searching '" + menulist + "' " +
         "(type '" + typeof(menulist) + "' " +
         "with localName '" + menulist.localName + "') " +
         "for '" + value + "', count = " + menulist.itemCount + "\n");
    while (i < menulist.itemCount) {
      var item = menulist.getItemAtIndex(i);
      
      logger.debug("selectMenulistItemWithValue() comparing '" + item.value + "' " +
           "with '" + value + "' => " + (item.value == value) + "\n");
      
      if (item.value == value) {
        menulist.selectedItem = item;
        return true;
      }
      i++;
    }
    if ( makeit ) {
      // TODO - There is some sort of race condition here,
      // if I add debug dumps here, all works. If not, it fails
      // with "menulist.appendItem is not a function" See bub 7138
      try {
        var newitem = menulist.appendItem( value, value )
        menulist.selectedItem = newitem;
      } catch(e) {
        logger.debug("Caught an error when appending a menu item " + e + "\n");
        for ( var f in menulist )
          if ( typeof(menulist[f]) == "function" ) // kills some time
            logger.debug("menulist has function " + f + "\n");
        try {
          var newitem = menulist.appendItem( value, value )
          menulist.selectedItem = newitem;
          logger.debug("menulist.appendItem worked the second time !!!\n");
        } catch(e) {
          logger.debug("Again caught an error when appending a menu item " + e +"\n");
        }
      }
      // Actually, we should not normally get here at all, but we tend to
      // do so, because earlier, menulist.itemCount is undefined, so we
      // fail to check if the item is in the list already. Another sympton
      // of the same bug, I bet.
    } else {
      // no item found, so nothing should be selected
      menulist.selectedIndex = -1;
    }
    return false;
  },

  // A single (editable?) pull-down to select a parameter name from
  // the template, given a jspnPath prefix. For example, select
  // from the children of $.output to get the list of regular
  // output parameters.
  // groups is a boolean, defaulting to false, in which case it takes
  // only regular names. If true, it selects instead from available
  // items that are groups in the own right.
  // TODO - At some point we should refactor jsonPathField to use this
  singleJsonPathField: function( surface, step, confindex, caption,
                    jsonPrefix,  groups, extraoptions ) {
    logger.debug("singleJsonPathField starting g=" + groups +
         " p='" + jsonPrefix + "'\n");
    if (!groups)
        groups = false;
    var hb = xmlHelper.appendNode(surface, "hbox", null, {align: "center"});
    xulHelper.onlyFlexSideways(hb, surface);
    if (caption)
      xmlHelper.appendNode(hb, "caption", caption);
    var templ = step.task.getTemplate().properties.data;
    var obj = jsonPath(templ, jsonPrefix);
    if ( !obj ) {
      logger.debug("singleJsonPathField: '" + jsonPrefix + "' failed, " +
           "trying output.results\n");
      obj = jsonPath(templ, "$.output.results"); // a good guess
    }
    if ( !obj ) {
      logger.debug("singleJsonPathField: '" + jsonPrefix + "' failed, plain output\n");
      obj = jsonPath(templ, "$.output"); // another good guess
    }
    //obj = obj[0][0]; // it seems always to be a double array ??!!
    // but if there was no such thing in the template, we get nothing much
    // and can't dereference it. Defensive coding below:
    if ( Array.isArray(obj) )
      obj=obj[0];
    if ( Array.isArray(obj) )
      obj=obj[0];
    logger.debug("got obj: " + obj + "\n");
    logger.debug(JSON.stringify(obj) + "\n");
    var list = [];
    for ( var k in obj ) {
      if ( groups ) {
        if ( obj[k].length != 0 )  // contains elements, is a group
          list.push(k);
      } else {
        if ( obj[k].length == 0 ) // plain variable
          list.push(k);
      }
    }
    var ret = xulHelper.arraySelectField(hb, step, confindex, list,
                                         extraoptions);
    logger.debug("singleJsonPathField done \n");
    return ret;
  }, // singleJsonPathField

  // jsonPathField displays a jsonPath, usually path+key, in one of different ways:
  //   - basic mode: pull-downs for each level
  //   - advanced mode: edit boxes for path and key
  //   - menu mode: pull-down menu to choose from $vars in templates
  //   - constant mode: Simple input for the constant value
  //   - Also displays a menu to choose between these, and to control
  //     all kinds of things.
  // surface is where to draw it, typically a hbox
  // step is a pointer to the step that includes this control
  // confObj is the configuration for the step.
  // confKey is an index to the configuration, to which the helper applies.
  //   normally those are step.conf and something like 'jp'
  //   but they can also be an array, and a numerical index.
  // Caption is optional
  // The optional 'initial' argument is a jsonPath to be used if nothing in conf.
  // The optional 'options' argument is an object with various flags to control the
  // inputs:
  //   - rwmode: one of 'r', 'w', 'rw' to indicate if the variable is to be used
  //     for reading, writing, or both. If write, enables the replace/append/concat options
  //   - singlevalue: true: we are only interested in a single value, disables
  //     append/concat options.
  //   - nulltext: to be displayed if the value is null.
  //   - nullmenutext: menu text for null value. Allows it to be selected in menu mode
  //   - constantallowed: boolean to allow constant values instead of jsonpath.
  //     Implies 'r'.
  //   - expandvariables: boolean to enable the user to select if the constant
  //     value should have embedded {$.variables} expanded.
  //   - constantbuttons: Preset values for constants. An array (so we can
  //     control the order) of objects with at least:
  //      - label to display
  //      - menulabel, in case different from above.
  //      - value to use
  //      - drawbutton: Indicates that a button is to be drawn. default: true
  //      - drawmenu: Indicates that a menu item is to be drawn. default. true
  //  - containermode: 
  //    - leafnodes: only select leaf nodes (default)
  //    - containers: only select containers, not leaf nodes ($.output.results)
  //    - anynode: select anything at all
  //    - containerpath: select containers, keep them in path, set the key to '*'
  //      (special case for the for_each step that ignores the key)
  //  - updatemplate: If seeing a variable not found in the template, add it there.
  //    defaults to true.
  // If omitted, options defaults the rwmode from the presence of spec.append, and
  // has decent defaults to the rest. That way, things remain backwards compatible
  // for old steps that use this helper.
  // TODO More flags
  //  - Updatetemplate: true - if we have a selection not known in the template,
  //    add it there, so it will be available in other steps. Perhaps default to
  //    yes if writemode.
  // TODO - At the moment the returned box has an additional method, redraw()
  // that can be used if some step decides to change things, and needs to have the
  // UI reflect those changes. The plan is to do all such manipulation inside this
  // helper, controled by extra options.
  // TODO - Allow this to be used with stand-alone jsonPath that is not part of
  // any confObj. For example by checking for confObj = null, and then assigning
  // spec = confkey directly. Or something.
  jsonPathField: function(surface, step, confObj, confKey, caption, initial, options) {
    var context = this;
    // predeclare the draw function, so it can be called from the other
    // drawXxx functions
    let draw;
    
    var outerBox = xmlHelper.appendNode(surface, "hbox", null, {align:"center"});
    xulHelper.onlyFlexSideways(outerBox, surface);
    if (caption)
      xmlHelper.appendNode(outerBox, "caption", caption);
    let box = xmlHelper.appendNode(outerBox, "hbox", null,
                                   {align: "center", flex: 1});
    let optionbox = xmlHelper.appendNode(outerBox, "hbox", null,
                                   {align: "center", flex: 1});

    if ( typeof(options) !== "object" ) {
      options = {  };
    }
    var spec = confObj[confKey];
    if (typeof(spec) !== "object") {
      if (typeof(initial) === "object" && initial )
        spec = initial;
      else
        spec = {}; // ### Should we not set path and key to empty?
      confObj[confKey] = spec;
      logger.debug("jpm: initialized spec to " + JSON.stringify(spec) );
    }
    if ( typeof(options.rwmode) !== "string" ) { // default from the actual jsonPath
      if (spec.append)
        options.rwmode = "w";
      else
        options.rwmode = "r";
    }
    // a single button can be passed as the object directly, make an array here
    if ( options.constantbuttons ) {
      if ( ! Array.isArray( options.constantbuttons ) )
        options.constantbuttons = [ options.constantbuttons ] ;
    }
    if ( !options.containermode ) {
      options.containermode = "leafnodes";
    }
    
    var docontainers =  false; // allow selection of containers 
    var docontainersonly = false; // allow selection of containers only
    var containerpath = false; // force key to '*'
    switch ( options.containermode ) {
      case "anynode":
        docontainers = true;
        break;
      case "containers":
        docontainersonly = true;
        docontainers = true;
        break;
      case "containerpath":
        docontainersonly = true;
        docontainers = true;
        containerpath = true;
        break;
      case "leafnodes":
        // use the defaults set above
        break;
      default:
        throw new Error("jsonPathHelper called with a bad containermode '" +
          options.containermode + "'");
    }; // switch
    
    if ( typeof(options.updatetemplate) == "undefined" )
      options.updatetemplate = true;
    
    let drawBasic = function() {
      //logger.debug("drawing Basic for " + spec.path + " " + spec.key );
      if (containerpath) // the basic mode would fail with jps without a key, transforms
        return false;   // the last component into a key, and looses the [*] in it.
      xmlHelper.emptyChildren(box);
      var lists = [];
      var popups = [];
      var toSelect = [];
      lists.push(xmlHelper.appendNode(box, "menulist", null,
        {pos: 0}));
      popups.push(xmlHelper.appendNode(lists[lists.length - 1], "menupopup"));
      lists.push(xmlHelper.appendNode(box, "menulist", null,
        {flex: 1, pos: 1, editable: true}));
      popups.push(xmlHelper.appendNode(lists[lists.length - 1], "menupopup"));
      lists.push(xmlHelper.appendNode(box, "menulist", null,
        {flex: 1, pos: 2, editable: true, hidden: true}));
      popups.push(xmlHelper.appendNode(lists[lists.length - 1], "menupopup"));
      lists.push(xmlHelper.appendNode(box, "menulist", null,
        {flex: 1, pos: 3, editable: true, hidden: true}));
      popups.push(xmlHelper.appendNode(lists[lists.length - 1], "menupopup"));

      if (spec.path) {
        // Matches a JSONpath like:
        // $.output.results[*].holdings[*]
        // with groups for the keys
        let keyRegex = /^\$\.(\w*)(?:\.(\w*)\[\*\])?(?:\.(\w*)\[\*\])?$/

        let matches = keyRegex.exec(spec.path);
        if (matches) {
          for (let i = 1; i < matches.length; i++) {
            if (matches[i]) {
              // regex groups create a sparse array
              toSelect.push(matches[i]);
            }
          }
        } else {
          return false;
        }
      }

      if (spec.key) {
        toSelect.push(spec.key);
      }

      var tmpl = step.task.getTemplate().properties.data;

      // If we have no path or key, start with the first space:
      if (toSelect.length === 0) toSelect = [Object.keys(step.task.data)[0]];

      for (var i = 0; i < toSelect.length; i++) {
        var addSeparator = false;
        var theSelectedItem = false;
        var nextTemplate = false;

        lists[i].removeAttribute('hidden');

        if (i===0) {
          var obj = step.task.data;
        } else {
          let jp = jsonPathHelper.pathFromArray(toSelect.slice(0, i));
          var obj = jsonPath(step.task.data, jp)[0];
          if (tmpl) var tmplObj = jsonPath(tmpl, jp)[0];
        }

        // Add existing values to dropdown
        for (let key in obj) {
          addSeparator = true;
          if (key == toSelect[i]) {
            theSelectedItem = xmlHelper.appendNode(popups[i], "menuitem", null,
            {label: key, value: key, selected: true});
          } else {
            xmlHelper.appendNode(popups[i], "menuitem", null,
            {label: key, value: key});
          }
        }

        // Add values from template
        if (tmplObj) {
          if (addSeparator === true) {
            xmlHelper.appendNode(popups[i], "menuseparator");
            addSeparator = false;
          }
          for (let key in tmplObj) {
            addSeparator = true;
            if (key == toSelect[i]) {
              theSelectedItem = xmlHelper.appendNode(popups[i], "menuitem", null,
              {label: key, value: key, selected: true});
              nextTemplate = tmplObj[key];
            } else {
              xmlHelper.appendNode(popups[i], "menuitem", null,
              {label: key, value: key});
            }
          }
        }

        // Add selected item if not already there
        if (toSelect[i] && !theSelectedItem) {
          if (addSeparator === true)
            xmlHelper.appendNode(popups[i], "menuseparator");
          theSelectedItem = xmlHelper.appendNode(popups[i], "menuitem", null,
            {label: toSelect[i], value: toSelect[i], selected: true});
        }

        if (theSelectedItem) {
          lists[i].selectedItem = theSelectedItem;
        } else {
          // Nothing wound up selected, select the first one
          lists[i].selectedIndex = 0;
          nextTemplate = tmplObj ? tmplObj[lists[i].value] : false;
        }
      }

      // Show template children even though top level objects aren't templated.
      // This, I think, is better than including the session object explicitly
      // in all templates, etc.
      if (i === 1 && typeof(tmpl) === 'object') {
        nextTemplate = tmpl[toSelect[0]];
      } else if (Array.isArray(nextTemplate) && typeof(nextTemplate[0]) === "object") {
        // Record template is always the first element
        nextTemplate = nextTemplate[0];
      } else nextTemplate = false;

      // Enable next drop box if it has a template
      if (nextTemplate && i < lists.length) {
        lists[i].removeAttribute('hidden');
        for (let key in nextTemplate) {
          xmlHelper.appendNode(popups[i], "menuitem", null,
          {label: key, value: key});
        }
      }

      var updateConf = function (e) {
        let selected = [];
        for (let i = 0; i < lists.length; i++) {
          if (lists[i].value)
            selected.push(lists[i].value);
        }
        let newSpec = jsonPathHelper.specFromArray(selected);
        spec.path = newSpec.path;
        spec.key = newSpec.key;
      }

      var handleSelection = function (e) {
        // Reset remaining select fields
        for (let j = Number(e.currentTarget.getAttribute("pos")) + 1; j < lists.length; j++) {
          lists[j].selectedIndex = -1;
          lists[j].setAttribute("hidden", true);
        }
        updateConf();
        // Need to redraw in case template has nested items below this
        // and more drop-downs need to be enabled/populated.
        drawBasic();
      }

      for (let i = 0; i < lists.length; i++) {
        lists[i].addEventListener("command", handleSelection, false);
        lists[i].addEventListener("change", handleSelection, false);
        lists[i].addEventListener("input", updateConf, false);
      }
      spec.displaymode = "basic"; 
      return true;  // did draw it all right
    } // jsonPathField.drawBasic

    
    let drawAdvanced = function() {
      xmlHelper.emptyChildren(box);
      //logger.debug("drawing advanced for " + spec.path + " " + spec.key );
      var pathField = xmlHelper.appendNode(box, "textbox", null,
        {"value": spec.path || "", "flex": 3, "minwidth": 120});
      var keyField = xmlHelper.appendNode(box, "textbox", null,
        {"value": spec.key || "", "flex": 1, "minwidth": 20});

      pathField.addEventListener("input",
        function (e) {spec['path'] = pathField.value}, false);
      pathField.addEventListener("change",
        function (e) {spec['path'] = pathField.value}, false);
      keyField.addEventListener("input",
        function (e) {spec['key'] = keyField.value}, false);
      keyField.addEventListener("change",
        function (e) {spec['key'] = keyField.value}, false);
      spec.displaymode = "adv"; // in case we tried to draw basic, but had
        // to fall back on adv, set the mode here, so the menu shows right
      return true;  // did draw it all right
    } // jsonPathField.drawAdvanced


    let drawMenu = function() {
      var dispstr="";
      
      // helper to build one menu item (not a submenu)
      var varmenupoint = function ( menu, label, path, key, checked ) {
        if ( containerpath ) { // transform to a full path plus wildcard
          path = path + "." + key + "[*]";
          key = "";
        }
        let attrs = { type: "radio", name: "var"};
        if (checked)
          attrs.checked = true;
        let mi = xulHelper.menuitem(menu, label, attrs );
        mi.cf_path = path;
        mi.cf_key = key;
        mi.addEventListener("click", function(e) {
          //logger.debug("jpm: Click on " +
          //    " p=" + mi.cf_path + " k=" + mi.cf_key );
          dispstr = mi.cf_path + "." + mi.cf_key; 
          spec.path = mi.cf_path;
          spec.key = mi.cf_key;
          // trigger a change event, for those steps that have a listener
          // on the box we end up returning.
          // the regular inputs do this already. But not the menus...
          var doc = step.getPageDoc();
          var che = doc.createEvent("HTMLEvents");
          che.initEvent( "change", true, true );
          ret = box.dispatchEvent(che);
          draw(true); // refresh the markers '...' and '*' and the step pane
        }, false); // click
          
        return checked;  
      }; // varmenupoint

      // helper to check if a template node contains containers
      var containscontainers = function(template) {
        if ( Array.isArray(template) )
          return containscontainers(template[0]);
        for ( let k in template ) {
          if ( JSON.stringify(template[k]).length >= 3 ) {
            return true; // found a container
              // that is one that is longer than '{}' or '[]'
          }
        }
        return false;
      }; // containscontainers
      
      // helper to recursively build the menu structures
      // prefix is the path up to this item, $.input
      // suffix is an optional string like [*] to be appended to the path
      // firstpoint is an optional object to define an extra element in the
      // menu: label, path, key, checked
      var variablemenu = function(menu, template, prefix, suffix, firstpoint) {
        if ( ! suffix )
          suffix = "";
        //logger.debug("jpm: recursing into " + prefix + suffix +  ": " + JSON.stringify(template) );
        let foundit = false;
        if ( typeof(template) == "object" ) {
          if ( Array.isArray(template) ) {
            //logger.debug("jpm: template is an array, recursing into [*]");
            foundit |= variablemenu(menu, template[0], prefix, "[*]", firstpoint);
          } else { // regular object
            if ( firstpoint && firstpoint.label ) {
              foundit |= varmenupoint( menu, firstpoint.label, 
                  firstpoint.path, firstpoint.key, firstpoint.checked );
              xulHelper.menuseparator(menu);
              //logger.debug("jpm: firstpoint: " + JSON.stringify(firstpoint) );
            }
            for ( let k in template ) {
              let pathsofar = prefix + suffix + "." + k;
              let indicator = "";
              if ( pathsofar == dispstr.substr(0, pathsofar.length) ) {
                //logger.debug("jpm: along the right path: " + pathsofar + " to " + dispstr );
                indicator = "...";
              }
              if ( k == "_" ) {
                // skip the dummy key we may have added into the template to force arrays
              }
              else if ( JSON.stringify(template[k]).length < 3 ) {
                // Regular (empty) array, '[]'  as we have for normal $.vars
                // or an empty object, '{}' as we may have for facets, fullquery, etc
                // unfortunately, checks like t[k] === {} do not work !
                if ( ! docontainersonly )
                  foundit |= varmenupoint( menu, k, prefix+suffix, 
                                           k, (pathsofar==dispstr) );
              } else { // submenu
                if ( ! docontainersonly || containscontainers(template[k]) ){
                  // regular submenu
                  let fe = {};
                  if ( docontainers ) {
                    fe.label = "[" + k + " itself]";
                    fe.path = prefix + suffix;
                    fe.key = k;
                    fe.checked = ( indicator != "" );
                  };
                  let menulabel = k + indicator;
                  let attrs = { type: "radio", name: "var"};
                  let sm = xulHelper.menu(menu, menulabel, null, attrs);
                  foundit |= variablemenu(sm, template[k], pathsofar, null, fe );
                  sm.cf_path = pathsofar;
                  sm.cf_key = k;
                  // Unfortunately, I never got onclick to work reliably on menus
                  // events bubble around, but the one actually clicked on does not
                  // always get the event. At least if it is empty, like ours may
                  // be.
                  //logger.debug("jpm: submenu " + k + " p=" + pathsofar );
                } else { // make a regular menu point for the terminal container
                  varmenupoint(menu, k, prefix+suffix, k, (indicator != "") );
                }
              }
            } // k loop
          }
        } else {
          logger.debug("jpm: template is not an object: " + typeof(template) );
          // should not happen
        }
        return foundit;
      }; // variablemenu helper

      // helper to check if we have the path in the template, and if not, 
      // add it there, so we can later select it from the menus.
      var checktemplate = function ( template, path ) {
        logger.debug("jpm: checktemplate: '" + path + "'" );
        if ( !template || !path )
          return;
        if ( Array.isArray(template) ) { // recurse into arrays
          checktemplate(template[0], path);
          return;
        }
        let is_array = false;
        let m = path.match( /^\$?\.?([^.]+)(.*)?$/ );
        if ( !m )
          return;
        let k = m[1];
        if ( !k || k == "$" ) 
          return;
        if ( k.match( /\[\*\]$/ ) ){
          k = k.replace ( /\[\*\]$/, "" );
          is_array = true;
          //logger.debug("jpm: checktemplate: simplified array k to '" + k + "' from '" + path + "'" +
          //  "templ type " + typeof(template[k]) );
        }
        if ( typeof(template[k]) == "undefined" ) {
          //logger.debug("jpm: checktemplate: typeof(template[" + k + "]) is " + typeof(template[k]) );
          if ( is_array ) {
            template[k] = [ { "_": null } ]; // this is dirty. We add an element
              // and later we filter it away. All this in order to make the json of
              // this to be longer than 3 chars, so it checks as an array.
          } else {
            template[k] = {}
          }
          logger.debug("jpm: checktemplate: added " + k + ": is_array=" + is_array );
        }
        checktemplate( template[k], m[2] );
      };

      // varmenu itself
      xmlHelper.emptyChildren(box);
      
      let mbox = xmlHelper.appendNode(box, "hbox", null,
                                    {align: "center", flex: 1});

      dispstr = "$.??";      
      if ( spec.path )
        dispstr = spec.path + "." + spec.key;
      else if ( options.nulltext )
        dispstr = options.nulltext;
      logger.debug("jpm: drawing menu item " + dispstr );
      if ( dispstr.match( /\{\$\./ ) ) {
        logger.debug("jpm: Spec contains subexpressions, can not do in menu mode");
        return false;
      }

      let templ = step.task.getTemplate().properties.data;
      //logger.debug("jpm: Got template " + JSON.stringify(templ) );
      if ( spec.path && spec.key)
        checktemplate(templ, spec.path + "." + spec.key);
      else if ( spec.path ) 
        checktemplate(templ, spec.path );

      let varmenu = xulHelper.menu(mbox, dispstr, {"align":"left"} );
      let foundit = variablemenu(varmenu, templ, "$" );
      foundit |= ( ! spec.path );  // accept an empty spec
      if ( ! foundit ) {
        logger.debug("jpm: did not find the leaf node " + dispstr);
        return false;
      }
      if ( options.nullmenutext ) { // Add a menu point for the null value
        xulHelper.menuseparator(varmenu);
        let attrs = { type: "radio", name: "var"};
        if ( !spec.path ) { // null
          attrs.checked = true;
        }
        let nullitem = xulHelper.menuitem(varmenu, options.nullmenutext, attrs );
        nullitem.addEventListener("click", function(e) {
          logger.debug("jpm: Click null " );
          spec.path = "";
          spec.key = "";
          spec.useconstant = false;
          draw(true);
        }, false);
      }
      
      if ( options.constantallowed ) { // menu point to switch to constant
      xulHelper.menuitem(varmenu, "Constant", null )
        .addEventListener("click", function(e) {
          spec.displaymode = "const";
          spec.useconstant = true;
          logger.debug("jpm: switching to constant mode");
          draw(true);
        },false);
      }

      // Open the whole menu on first click (still within drawMenu)
      varmenu.addEventListener("popupshown", function (e) {
        //logger.debug("jpm: popupshown on " + e.target.cf_path + " with " +
        //  e.target.cf_menu.itemCount + " items" );
        //logger.debug("jpm: first is " + typeof( e.target.cf_menu.getItemAtIndex(0) ) );
        let i = 0;
        for ( i = 0; i < e.target.cf_menu.itemCount; i++ ) {
          let it = e.target.cf_menu.getItemAtIndex(i);
          let pa = it.cf_path ;
          if ( it.cf_menupopup )
            pa = it.cf_menupopup.cf_path;
          //logger.debug("jpm: item["+i+"] is " + it.cf_path + " m=" + it.cf_menu +
          //  " nn=" + it.nodeName +
          //  " p=" + it.cf_menupopup +
          //  " pa=" + pa );
          if ( it.nodeName == "menu" ) {
            if ( pa == dispstr.substr(0, pa.length) ) {
              //logger.debug("jpm: Opening " + pa );
              it.open = true;
            }
          } else if ( pa && it.nodeName == "menuitem" ) {
            let pak = pa + "." + it.cf_key
            if (  pak == dispstr ) {
            //if (  pak == dispstr.substr(0, pak.length) ) {
              //logger.debug("jpm: checking " + pak );
              it.setAttribute("checked", "true");
            } else {
              //logger.debug("jpm: unchecking " + pak );
              it.setAttribute("checked", "false");
            }
          }
        } // for
      }, false);

      //logger.debug("jpm: Done drawing menu " + dispstr );
      spec.displaymode = "menu";
      return true;
    } // jsonPathField.drawMenu()

    
    // Draw the input field for a constant value
    let drawConstant = function() {
      xmlHelper.emptyChildren(box);
      logger.debug("drawing constant for " + spec.path + " " + spec.key +
          " " + spec.useconstant + ": '" + spec.constantvalue + "'" );
      // since we display this, we know we want to use a constant
      spec.useconstant = true;

      // Mark constant with double quotes
      xmlHelper.appendNode(box, "caption", '"');
      
      var constField = xmlHelper.appendNode(box, "textbox", null,
        {"value": spec.constantvalue || "", "flex": 3, "minwidth": 120});
      xmlHelper.appendNode(box, "caption", '"');

      if ( options.constantbuttons && Array.isArray(options.constantbuttons) ) {
        for ( let i = 0; i<options.constantbuttons.length; i++ ) {
          let item = options.constantbuttons[i];
          if ( typeof(item.drawbutton) == "undefined" || item.drawbutton  ) {
            let but = xmlHelper.appendNode(box, "button", null,
                                            { label: item.label });
            but.addEventListener("command", function(e) {
              logger.debug("jpm: constant button " + item.label +
                ": " + item.value );
              spec.constantvalue = item.value;
              draw(true);
            }, false );
          }

        }
      } 

      constField.addEventListener("input", function (e) {
        spec.constantvalue = constField.value;
        logger.debug("jpm: constantvalue: " + spec.constantvalue );
      }, false);
      constField.addEventListener("change", function (e) {
        spec.constantvalue = constField.value;
        logger.debug("jpm: constantvalue: " + spec.constantvalue );
      }, false);
      return true;
    } // jsonPathField.drawConstant()

    
    // Options menu
    let drawOptionMenu = function() {
      xmlHelper.emptyChildren(optionbox);
      let dispstr = "Options";
      let appendoptions = false;
      if ( options.rwmode == "w" || options.rwmode == "rw" ) {
        if ( options.singlevalue ) {
          spec.append = jsonPathHelper.REPLACE;
        } else {
          appendoptions = true;
          if ( spec.append )
            dispstr += " [" + jsonPathHelper.captions[spec.append].substr(0,1)+ "]";
        }
      } // rw
      if ( spec.useconstant && spec.expandvariables )
        dispstr += " {$.var}"; 

      let optmenu = xulHelper.menu(optionbox, dispstr, {"align":"left"} );
      let attrs = { type:"radio", name:"mode", checked: ( spec.displaymode == "menu") };
      xulHelper.menuitem(optmenu, "Menu mode", attrs ).
        addEventListener("click", function(e) {
          spec.displaymode = "menu";
          spec.useconstant = false;
          draw(false);
        },false);
      attrs = { type:"radio", name:"mode", checked: ( spec.displaymode == "basic") };
      xulHelper.menuitem(optmenu, "Basic mode", attrs ).
        addEventListener("click", function(e) {
          spec.displaymode = "basic";
          spec.useconstant = false;
          draw(false);
        },false);
      attrs = { type:"radio", name:"mode", checked: ( spec.displaymode == "adv") };
      xulHelper.menuitem(optmenu, "Advanced mode", attrs ).
        addEventListener("click", function(e) {
          spec.displaymode = "adv";
          spec.useconstant = false;
          draw(false);
        },false);

      if ( options.constantallowed ) {
        xulHelper.menuseparator(optmenu);
        attrs = { type:"radio", name:"mode", checked: ( spec.displaymode == "const") };
        xulHelper.menuitem(optmenu, "Constant", attrs )
          .addEventListener("click", function(e) {
            spec.displaymode = "const";
            spec.useconstant = true;
            logger.debug("jpm: switching to constant mode");
            draw(true);
          },false);
        if ( options.constantbuttons && Array.isArray(options.constantbuttons) ) {
          for ( let i = 0; i<options.constantbuttons.length; i++ ) {
            let item = options.constantbuttons[i];
            if ( ! item.menulabel )
              item.menulabel = "  " + item.label;
            if ( typeof(item.drawmenu) == "undefined" || item.drawmenu ) {
              xulHelper.menuitem(optmenu, item.menulabel )
                .addEventListener("click", function(e) {
                  spec.displaymode = "const";
                  spec.useconstant = true;
                  spec.constantvalue = item.value;
                  logger.debug("jpm: Selected constant " + item.label );
                  draw(true);
                },false);
            } 
          } // constant loop
        } 
      } // constantallowed
      if ( spec.displaymode == "const" && options.expandvariables ) {
        if ( ! spec.expandvariables )  // coerce into a boolean
          spec.expandvariables = false;
        attrs = { type:"checkbox", checked: spec.expandvariables };
        xulHelper.menuitem(optmenu, "Expand {$.var}", attrs )
          .addEventListener("click", function(e) {
            spec.expandvariables = ! spec.expandvariables;
            logger.debug("jpm: toggling expandvars to " + spec.expandvariables + " a=" + JSON.stringify(attrs) );
            draw(true);
          },false);
      }
      if ( appendoptions ) {
        xulHelper.menuseparator(optmenu);
        for ( let ao = jsonPathHelper.APPEND; ao <= jsonPathHelper.REPLACE; ao++ ) {
          let caption = jsonPathHelper.captions[ao];
          let attrs = { type: "radio", name: "appendmode" };
          let aocopy = ao;
          if ( spec.append == ao )
            attrs.checked = true;
          let aoitem = xulHelper.menuitem(optmenu, caption, attrs );
          aoitem.addEventListener("click", function(e) {
            logger.debug("Opt menu: click on " + caption + " =" + aocopy);
            spec.append = aocopy;
            drawOptionMenu(); // redraw to get the selection mark right
            step.task.connector.onStepParametersUpdate(step); // update step pane
          }, false);

        }
      }

    }; // drawOptionMenu of jsonPathField


    
    // The actual draw function
    // Decides which of the drawXxx functions to call
    // if somethingchanged is true (or undefined), also updates the step pane
    // Note that in xulrunner24, we can define
    //   function (somethingchanged = true )
    // but this breaks under xulrunner 10
    draw = function( somethingchanged ) {
      if ( !spec ) 
      logger.debug("jpm: starting draw with mode " + spec.displaymode + " for " +
        spec.path + " " + spec.key );
      if ( typeof(somethingchanged) == "undefined" )
        somethingchanged = true;
      if ( ! spec.displaymode )
        spec.displaymode = "menu";
      // TODO - if not specified, check a user pref to see what they like.
      if ( spec.useconstant ) 
        spec.displaymode = "const" ;
      switch ( spec.displaymode ) {
        case "const":
          drawConstant(); // should succeed always!
          break;
        case "menu":
          if ( drawMenu() )
            break; // if fails, fall through
        case "basic":
          if ( drawBasic() )
            break;
        case "adv":
        default:
          drawAdvanced();
      } // switch
      if ( somethingchanged ) {
        logger.debug("jpm: something changed");
        step.task.connector.onStepParametersUpdate(step);
      }
      drawOptionMenu();
    } // jsonPathField.draw
    
    draw(false);
    box.redraw = draw; // A callback
      // TODO - This should not be needed, but at the moment it is
      // for example in nav_to, we have a button to use the current URL.
      // That sets the values directly, and needs to call redraw to make
      // things visible. In some future version we should have all such
      // functionality included in the helper, and not needed in the steps.
      // Although there may always be special cases...
    return box;
  }, // jsonPathField

  jsonPathMapField: function(surface, step, inKey, outKey, defaultIn, defaultOut) {
    let box = xmlHelper.appendNode(surface, "vbox");
    let inBox = xulHelper.jsonPathField(box, step, step.conf, inKey, "Source: ", defaultIn,
                                        { rwmode:"r" } );
    let outBox = xulHelper.jsonPathField(box, step, step.conf, outKey, "Output: ",
                                         defaultOut || {append:jsonPathHelper.REPLACE},
                                        { rwmode:"w" } );

    if (!step.conf[outKey]) step.conf[outKey] = {unchanged:true};
    else if (!step.conf[outKey].key) step.conf[outKey].unchanged = true;

    // Update unchanged target to represent
    let updateOut = function (e) {
      if (step.conf[outKey].unchanged && e.target.localName !== 'button') {
        Components.utils.import("resource://indexdata/ui/taskPane.js");
        step.conf[outKey].key = step.conf[inKey].key;
        step.conf[outKey].path = step.conf[inKey].path;
        xmlHelper.emptyChildren(taskPane.stepBox);
        step.draw(taskPane.stepBox);
      }
    }
    inBox.addEventListener("command", updateOut, false);
    inBox.addEventListener("change", updateOut, false);

    // Mark target changed
    let outChanged = function (e) { delete step.conf[outKey].unchanged; };
    outBox.addEventListener("command", function (e) { outChanged(); }, false);
    outBox.addEventListener("change", outChanged, false);

    return box;
  }, 

  // node selector, optionally takes a function to call against
  // the node once selected
  singleNodeField: function(surface, step, confKey, func) {
    var text = "";

    if (confKey)
      text = xmlHelper.nodeSpecToString(step.conf[confKey]);
    var hbox = xmlHelper.appendNode(surface, "hbox", null, {"align":"center", "flex":1}, null);
    var inbox = xmlHelper.appendNode(hbox, "vbox", null, {"flex":1}, null);
    var input = xmlHelper.appendNode(inbox, "textbox", null,
        {"value": text, "flex": 1, "minwidth": 160}, null);
    var selectButton = xmlHelper.appendNode(hbox, "button", null,
        {"label": "Select node"}, null);
    var refineButton = xmlHelper.appendNode(hbox, "button", null,
        {"label": "Refine xpath"}, null);

    var subtext = xmlHelper.appendNode(inbox, "description", null, {"class":"subtext"}, null);

    var testXpathUpdateConf = function(e) {
      let newNodeSpec = xmlHelper.nodeSpecFromString(input.value);
      // only test xpaths that don't depend on replacements
      if (input.value.indexOf("{$") === -1) {
        let matchCount = xmlHelper.getMatchCountByNodeSpec(step.getPageDoc(), newNodeSpec);
        if (matchCount === 1) {
          input.removeAttribute("class");
          subtext.setAttribute("value", "");
        } else if (matchCount > 1) {
          input.setAttribute("class", "incomplete");
          subtext.setAttribute("value", "Warning: " + matchCount + " elements match this XPath.");
        } else {
          subtext.setAttribute("value", "Warning: No elements match this XPath.");
        }
      }
      if (confKey) step.conf[confKey] = newNodeSpec;
    };

    // Defensive coding, occasionally we have a plain old string
    // in the conf. This converts to a proper nodeSpec.
    if ( confKey && typeof(step.conf[confKey]) == "string" ) {
      var newNodeSpec = xmlHelper.nodeSpecFromString(step.conf[confKey]);
      step.conf[confKey] = newNodeSpec;
    }

    input.addEventListener("input", testXpathUpdateConf, false);
    input.addEventListener("change", testXpathUpdateConf, false);

    var context = this;
    var selectNode = function(e) {
      app.newHl(step.getPageDoc(), function() {
        var node = this;
        if ( node.cf_datanode ) {
          node = node.cf_datanode;
        }
        var nodeSpec = xmlHelper.getNodeSpec(node, true);
        input.value = xmlHelper.nodeSpecToString(nodeSpec);
        if (confKey) {
          step.conf[confKey] = nodeSpec;
        }
        app.highlighter.destroy();
        step.task.connector.onStepParametersUpdate(step);
        refineButton.removeAttribute("disabled");
        input.removeAttribute("class");
        if (func) func(this);
        return false;
      });
    };
    selectButton.addEventListener("command", selectNode, false);

    refineButton.addEventListener("command", function(e) {
      let target = xmlHelper.getElementByNodeSpec(step.getPageDoc(), step.conf[confKey]);
      if (target) { 
        new XpathRefine(target, step.conf[confKey]['xpath'], function (x) {
          step.conf[confKey]['xpath'] = x;
          input.value = xmlHelper.nodeSpecToString(step.conf[confKey]);
          input.removeAttribute("class");
          step.task.connector.onStepParametersUpdate(step);
        });
      }
    }, false);

    // TODO: This doesn't trigger the node selector, so we can't have it start out in selection mode when you add
    //selectNode();
    return input;
  },

  // helpers to highlight nodes, and to remove the highlights
  // the userhighlight boolean tells if the highlight comes
  // directly from the user, of from matching.
  // If the node has cf_displaynode or cf_datanode set, does
  // the highlighting for that too (without recursing, as those
  // tend to be cyclical!)
  highlightNode: function(node, color, userhighlight ) {
    var nodes = [ node ];
    try { // Defensive coding, things go wrong if we look at a document that
          // is gone away (as when moving to a new page, or closing a tab)
      nodes = [ node, node.cf_displaynode, node.cf_datanode  ];
    } catch (e) {
      logger.debug("xulHelper.highlightNode: Caught exception " + e + 
        " Ignoring it. Probably something funny with the current page");
    }
    var displaycolor = color;
    //if ( node.getAttribute && node.getAttribute("cf_user_highlight") == color)
    //  userhighlight = true; // use has highlighted this before
    // Doesn't work, userhighlights everything
    if ( !userhighlight ) { // Dim the color a bit, if not user-selected
      var m = color.match( /#(..)(..)(..)$/ );
      if ( m ) {
        var r = parseInt(m[1],16);
        var g = parseInt(m[2],16);
        var b = parseInt(m[3],16);
        r = Math.floor( r / 2 ) + 127;
        g = Math.floor( g / 2 ) + 127;
        b = Math.floor( b / 2 ) + 127;
        var rgb = r * 256 * 256 + g * 256 + b;
        displaycolor =rgb.toString(16);
        while ( displaycolor.length < 6 )
          displaycolor = "0" + displaycolor;
        displaycolor = "#" + displaycolor;
      }
    }
    for ( var i in nodes ) {
      var n = nodes[i];
      if (n) {
        var old = "" ;
        if ( n.style ) {
          old = n.style.backgroundColor;
          n.style.backgroundColor=displaycolor;
        }
        if ( n.getAttribute ) {
          // for some reason, CDATA nodes seem not to have getAttribute()
          var oldattr = n.getAttribute("cf_old_style");
          if (oldattr == undefined ) {
            n.setAttribute("cf_old_style",old);
          }
          n.setAttribute("cf_orig_highlight", color); 
          if (userhighlight) {
            n.setAttribute("cf_user_highlight",color);
          }
        }
      }
    }
  }, // highlightNode

  getHighlight: function( n ) {
    if (!n) //defensive coding, should not happen
      return "";
    if ( n.getAttribute ) {
      if ( n.hasAttribute("cf_orig_highlight") )
        return n.getAttribute("cf_orig_highlight");
      if ( n.hasAttribute("cf_user_highlight") )
        return n.getAttribute("cf_user_highlight");
    }
    if ( n.style )
      return n.style.backgroundColor;
    return "";
  }, // getHighlight

  // Reapply the original highlight
  // in case the node has been highlighted dimly, this brightens it up
  rehighlightNode: function( n ) {
      if ( n && n.getAttribute && n.style )
        n.style.backgroundColor = n.getAttribute("cf_orig_highlight");
  }, // rehighlightNode
  
  unhighlightNode: function(node, userhighlight ) {
    var nodes = [ node, node.cf_displaynode, node.cf_datanode  ];
    for ( var i in nodes ) {
      var n = nodes[i];
      if (n) {
        if ( n.getAttribute) {
          var old = n.getAttribute("cf_old_style") ;
          if (old != undefined) {
            if ( n.style )
              n.style.backgroundColor = old;
            n.cf_old_style = undefined;
          }
          n.removeAttribute("cf_orig_highlight");
          if (userhighlight) {
            n.removeAttribute("cf_user_highlight");
          }
        }
      }
    }
  },

  unhighlightAll: function(node, userhighlight) {
    while (node != null) {
      xulHelper.unhighlightNode(node,userhighlight);
      xulHelper.unhighlightAll(node.firstChild,userhighlight);
      node = node.nextSibling;
      // do not recurse to nextSibling, or long pages risk
      // "too much recursion".
    }
  },

  /*
   * Creates a tab-box on the specified node consisting one tab for
   * each of the strings in the array of titles, and using the
   * specified set of attributes for the top-level tabbox element.
   * Returns an array of nodes representing the tab panels.
   * Each tab panel has a member cf_tab that is the tab linked to this
   * panel, so you can listen on its command event to detect when
   * the user clicks.
   */
  tabBox: function(node, titles, attributes) {
    var res = [];
    var box = xmlHelper.appendNode(node, "tabbox", null, attributes);
    var tabs = xmlHelper.appendNode(box, "tabs");
    var tabarray = [];
    for (var i = 0; i < titles.length; i++) {
      var tabattrs = { label: titles[i] };
      if (i == 0) tabattrs.selected = true;
      tabarray[i] = xmlHelper.appendNode(tabs, "tab", null, tabattrs);
    }
    var panels = xmlHelper.appendNode(box, "tabpanels", null,
                     { flex: 1 } );
    for (var i = 0; i < titles.length; i++) {
      var thistab = xmlHelper.appendNode(panels, "tabpanel", null,
                  { style:'overflow: auto;'} );
      thistab.cf_tab = tabarray[i];
      res.push(thistab);
    }
    return res;
  },

  checkbox: function(surface, step, confindex, label, attrs) {
    if (!attrs )
        attrs = {};
    if (label )
        attrs.label = label;
    if (confindex != "" && step.conf[confindex]) {
      attrs.checked = true;
    }
    var cb = xmlHelper.appendNode(surface, "checkbox", null, attrs);
    cb.addEventListener("command", function(e) {
      if (confindex != "")
        step.conf[confindex] = this.checked;
    }, false);

    cb.cf_setValue = function(v) {
      if ( confindex != "" )
        step.conf[confindex] = v;
      cb.checked = v;
    };

    return cb;
  },

  makeValueListener: function(obj, key) {
    return function(e) {
      obj[key] = e.target.value;
    };
  },

  makeToggleListener: function(obj, key) {
    return function(e) {
      obj[key] = !obj[key];
    };
  },

  // Builds a menu and a menupopup. not connected to any conf variables
  // Returns the menupopup, into which you can then add other menus, or
  // menuitems
  menu: function (surface, label, attrs) {
    if (!attrs )
        attrs = {};
    if (label )
        attrs.label = label;
    let menu = xmlHelper.appendNode(surface, "menu", null, attrs );
    let pop = xmlHelper.appendNode(menu, "menupopup", null );
    pop.cf_menu = menu; // keep a reference, so we can change the label
    menu.cf_menupopup = pop; // and back again
    return pop;
  },

  // Builds a label and a popup menu for it
  // Popup menus need a unique id, so we keep a global counter here
  nextpopupmenuid: 1,
  
  popupmenu: function (surface, label, attrs) {
    let menuid = "popupmenu" + xulHelper.nextpopupmenuid++ ;
    logger.debug("Popup menu id=" + menuid);
    let popupset = xmlHelper.appendNode(surface, "popupset" );
    let pop = xmlHelper.appendNode(popupset, "menupopup", null,
                                      { id:menuid } );
    if (!attrs )
        attrs = {};
    attrs.popup = menuid;
    let disp = xmlHelper.appendNode(surface, "label", label, attrs);
    pop.cf_label = disp;
    return pop;
  },
  
  // Change the label of a menu. Works for things created with menu or
  // popupmenu above.
  changemenulabel: function( menupop, label) {
    if ( !menupop ) {
      logger.debug("xulHelper: changemenulabel called with no menu " +
        "(and label '" + label + "'). Can not change");
    }
    if ( menupop.cf_menu )
      menupop.cf_menu.label = label;
    else if ( menupop.cf_label )
      menupop.cf_label.value = label;
    else      
      logger.debug("xulHelper: changemenulabel: no cf_menu in menupopup, " +
        "can not change label to '" + label + "'");
  },
  
  // Adds a menu item into the menu
  menuitem: function( menu, label, attrs) {
    if ( !attrs )
      attrs = {};
    if ( label && ! attrs.label )
      attrs.label = label;
    let item = xmlHelper.appendNode(menu, "menuitem", null, attrs);
    return item;
  },

  // Adds a menu separator into the menu
  menuseparator: function( menu, label) {
    let item = xmlHelper.appendNode(menu, "menuseparator", null,
                                           { label: label } );
    return item;
  },

} // xulHelper

} /* END BUILDER ONLY WRAPPER */
