#!/bin/sh
# assumes pwd is engine/src
DIR=`dirname $0`
PLAINDIR=`basename $DIR`
echo "running regression in $DIR"
GRET=0
: ${diff_opt="-u"}
: ${REGRESSION_FATAL=false}
: ${MAKE_OUT=false}

error () {
    $REGRESSION_FATAL && exit 1
    GRET=1
}

# TODO - Thetest-ws script assumes a keyword search only, so
# we can not do multipel queries here. Too bad...

: ${CF_CONNECTORS=../../connectors}

for cfile in $CF_CONNECTORS/*.cf $CF_CONNECTORS/$PLAINDIR/*.cf; do
    c=`basename $cfile .cf`
    CFWS_URL=http://localhost:9070/connector ./test-ws.sh water $cfile >$DIR/$c.log
    RC=$?
    if test $RC -ne 0 ; then
        echo "$c FAIL!"
        echo "test-ws.sh exited with $RC"
        error 1
    fi
    if test -f $DIR/$c.out; then
	diff $diff_opt $DIR/$c.out $DIR/$c.log
	if test $? -ne 0; then
	    echo "$c: differ"
            error
	else
	    echo "  $c: OK"
	fi
    elif $MAKE_OUT; then
        echo "$c Making first time"
        cp $DIR/$c.log $DIR/$c.out
        error 
    else
        echo "$c FAIL!"
        echo "  Missing file: $c.out"
        echo "  Please check that $c.log looks right, and copy it to $c.out"
        echo "  And add it to git with "
        echo "    cd $DIR; git add $c.out"
        error
    fi
done
exit $GRET
