<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns="http://www.loc.gov/MARC21/slim" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" exclude-result-prefixes="dc">
    <xsl:output method="xml" indent="yes"/>
    
    <xsl:template match="/record">
        <record xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="http://www.loc.gov/MARC21/slim http://www.loc.gov/standards/marcxml/schema/MARC21slim.xsd" >
            <xsl:element name="leader">
                <xsl:variable name="type" select="dc:type"/>
                <xsl:variable name="leader06">a</xsl:variable>
                <xsl:variable name="leader07">m</xsl:variable>
                <xsl:value-of select="concat('      ',$leader06,$leader07,'         3u     ')"/>
            </xsl:element>

            <xsl:for-each select="author[1]">
                <datafield tag="100" ind1=" " ind2=" ">
                    <subfield code="a">
                        <xsl:value-of select="."/>
                    </subfield>
                </datafield>
            </xsl:for-each>

            <xsl:for-each select="author[position() > 1]">
                <datafield tag="700" ind1=" " ind2=" ">
                    <subfield code="a">
                        <xsl:value-of select="."/>
                    </subfield>
                </datafield>
            </xsl:for-each>

            <xsl:for-each select="date">
                <datafield tag="260" ind1=" " ind2=" ">
                    <subfield code="c">
                        <xsl:value-of select="."/>
                    </subfield>
                </datafield>
            </xsl:for-each>    

            <xsl:for-each select="description">
                <datafield tag="520" ind1=" " ind2=" ">
                    <subfield code="a">
                        <xsl:value-of select="."/>
                    </subfield>
                </datafield>
            </xsl:for-each>
            
            <xsl:for-each select="url">
                <datafield tag="856" ind1="4" ind2="0">
                    <subfield code="u">
                        <xsl:value-of select="."/>
                    </subfield>
		    <xsl:if test="//dc:format">
		      <subfield code="q">
		        <xsl:value-of select="//dc:format"/>
		      </subfield>
		    </xsl:if>
                </datafield>
            </xsl:for-each>

            <xsl:for-each select="//dc:publisher">
                <datafield tag="260" ind1=" " ind2=" ">
                    <subfield code="b">
                        <xsl:value-of select="."/>
                    </subfield>
                </datafield>
            </xsl:for-each>

            <xsl:for-each select="subject">
                <datafield tag="653" ind1=" " ind2=" ">
                    <subfield code="a">
                        <xsl:value-of select="."/>
                    </subfield>
                </datafield>
            </xsl:for-each>
                                                                                            
            <xsl:for-each select="title[1]">
                <datafield tag="245" ind1="0" ind2="0">
                    <subfield code="a">
                        <xsl:value-of select="."/>
                    </subfield>
                </datafield>
            </xsl:for-each>

        </record>
    </xsl:template>
</xsl:stylesheet>
