/* This file is part of the Connector Framework
 * Copyright (C) 2008-2013 Index Data
 * See the file LICENSE for details.
 */
/**
 * \file cf_embed.h
 * \brief CF_Embed header
 */
#include <unistd.h>
#include <yaz/wrbuf.h>
#include <yaz/timing.h>
#include <string>
#include "cf_logger.h"
#include "cf_display.h"

class CF_Engine;
/**
 * Connector Session Embedding Implementation
 */
class CF_Embed : public CF_Logger
{
    friend class CF_Engine;
public:
    CF_Embed(const char *loglevel, const char *a_sesname, int fd);
    ~CF_Embed();
    bool spawn_fork(std::string &err_msg,
                    const char *module_path,
                    const char *app_path, const char *cfmain_path,
                    const char *proxy, int capt_fd);
    void main();
    bool wait_result_parent(const char **output, int timeout_ms, bool *sys_err);
    void get_result_parent(const char *default_msg, const char **output);
    void load_cf_parent(const char *cf_file, const char *session_json = 0);
    void save_cf_parent(const char *cf_file);
    void run_script_parent(const char *script_file);
    void run_task_parent(const char *taskName, bool optional, const char *input,
                         const char **output);
    bool run_tests_parent(const char *task_order);
    bool unit_test_parent(const char *name);
    void printf(const char *module, int level, const char *fmt, ...);
private:
    bool wait_init_handshake(std::string &error_msg);
    void copy_initial_js_files(const char *a_profile_path,
                               const char *a_app_path,
                               const char *loglevel);
    void write_response(const void *buf, size_t count);
    void write_response_cstr(const char *cstr);
    bool screen_shot_parent(const char *filename);
    void dom_string_parent(char **retval);
    int write_request(WRBUF w);
    std::string sesname;
    char *profile_path;
    int profile_temp;
    int request_fd[2];
    int response_fd[2];
    pid_t pid;
    WRBUF result_wrbuf;
    WRBUF current_task;
    unsigned long main_window_xid;
    CF_Display display;
};

/*
 * Local variables:
 * c-basic-offset: 4
 * c-file-style: "Stroustrup"
 * indent-tabs-mode: nil
 * End:
 * vim: shiftwidth=4 tabstop=8 expandtab
 */

