/* This file is part of the Connector Framework
 * Copyright (C) 2008-2013 Index Data
 * See the file LICENSE for details.
 */
/**
 * \file cf_factory.h
 * \brief Engine factory
 */

#ifndef CF_FACTORY_H
#define CF_FACTORY_H

#include <yaz/wrbuf.h>
#include <yaz/xmltypes.h>
#include "cf_engine.h"

/**
 * Engine factory
 *
 * The Engine may throw a CF_Engine_Error exception.
 */
class CF_Factory {
public:
    /**
     * Constructor
     *
     */
    CF_Factory(const xmlNode *n);

    /**
     * Constructor
     *
     */
    ~CF_Factory();

    /**
     * Factory method
     *
     */
    CF_Engine *create(enum CF_Engine::Flags, const char *proxy,
                      const char *loglevel,
                      const char *sesname, int capt_fd);

    WRBUF get_cf_file(WRBUF username, WRBUF password,
                      const char *db, int *http_status);

    void auth(WRBUF username, WRBUF password, int *http_status);

    int get_cf_tmp_dir(WRBUF w);
private:
    WRBUF get_cf_via_url(WRBUF username, WRBUF password,
                         const char *db, int *http_status);

    WRBUF cf_module_path;
    WRBUF cf_app_path;
    WRBUF cf_profile_path;
    WRBUF cf_connector_path;
    WRBUF cf_repo_fetch_url;
    WRBUF cf_repo_auth_url;
    WRBUF cf_repo_proxy;
    WRBUF cfmain_path;
    WRBUF tmp_dir;
};

#endif
/*
 * Local variables:
 * c-basic-offset: 4
 * c-file-style: "Stroustrup"
 * indent-tabs-mode: nil
 * End:
 * vim: shiftwidth=4 tabstop=8 expandtab
 */

