/* This file is part of the Connector Framework
 * Copyright (C) 2008-2013 Index Data
 * See the file LICENSE for details.
 */
/**
 * \file cf_main.h
 * \brief CF_Main header
 */
#include <unistd.h>
#include <pthread.h>
#include <glib.h>
#include <gdk/gdkx.h>
#include <yaz/wrbuf.h>
#include <yaz/timing.h>
#include <string>
#include "cf_logger.h"
#include "nsStringAPI.h"

class ConnectorWrap;
class MozApp;
/**
 * Connector Session Embedding Implementation
 */
class CF_Main : public CF_Logger // default logger
{
public:
    CF_Main(int argc, char **argv, const char *module_path,
            const char *app_path, const char *profile_path,
            const char *proxy, const char *loglevel, const char *ses_name,
            int read_fd, int write_fd);
    ~CF_Main();
    const char *get_module_path();
    void main();
    void input_handler(GIOChannel *source);
    void browser_ready(ConnectorWrap *connector);
    void browser_failure(const char *msg);
    void result_handler(bool success, const char *str);
    CF_Logger *logger; // passed logger in constructor or itself
    void printf(const char *module, int level, const char *fmt, ...);
private:
    void write_response_cstr(const char *cstr);
    void write_response(const void *buf, size_t count);
    char *module_path;
    char *app_path;
    char *profile_path;
    char *proxy_host;
    int proxy_port;
    int read_fd;
    int write_fd;
    ConnectorWrap *connector;
    WRBUF result_wrbuf;
    int argc;
    char **argv;
    MozApp *mozApp;
    char *ses_name;
    yaz_timing_t task_timing;
    WRBUF current_task;
    XID main_window_xid;
};

CF_Main *get_CF_Main();

/*
 * Local variables:
 * c-basic-offset: 4
 * c-file-style: "Stroustrup"
 * indent-tabs-mode: nil
 * End:
 * vim: shiftwidth=4 tabstop=8 expandtab
 */

