Components.utils.import("resource://gre/modules/XPCOMUtils.jsm");

// This is the main program! It reads command line arguments
// and does something with them

var debug = 0;
// file descriptors. Will be opened as /proc/self/fd/XXX
var infd = "0"; // where to read commands from. file desc number, 0=stdin
var outfd = "1"; // where to write the output. 1=stdout, 2=stderr, etc


function CommandLineHandler() {
}

// Helpers to open input and output file streams
// Mostly stolen from
//   https://developer.mozilla.org/en/Code_snippets/File_I//O
function openinput( fdnum ) {
    var fpath = "/proc/self/fd/" + fdnum;
    if (debug) dump("Opening input " + fpath + "\n");
    var localFile = Components.classes["@mozilla.org/file/local;1"]
        .createInstance(Components.interfaces.nsILocalFile);
    localFile.initWithPath( fpath );
    if (debug) dump("  ..inited local file " + fpath + "\n");
    var fstream = Components.
        classes["@mozilla.org/network/file-input-stream;1"].
        createInstance(Components.interfaces.nsIFileInputStream);
    fstream.init(localFile, -1, 0, 0);
    if (debug) dump("  ..inited fstream\n");
    var cstream = Components.
        classes["@mozilla.org/intl/converter-input-stream;1"].
        createInstance(Components.interfaces.nsIConverterInputStream);
    cstream.init(fstream, "UTF-8", 0, 0);
    if (debug) dump("  ..Inited cstream\n");
    return cstream;
} // openinput

function openoutput( fdnum ) {
    var fpath = "/proc/self/fd/" + fdnum;
    if (debug) dump("Opening input " + fpath + "\n");
    var localFile = Components.classes["@mozilla.org/file/local;1"]
        .createInstance(Components.interfaces.nsILocalFile);
    localFile.initWithPath( fpath );
    if (debug) dump("  ..inited local file " + fpath + "\n");
    var foStream = Components.
        classes["@mozilla.org/network/file-output-stream;1"].
        createInstance(Components.interfaces.nsIFileOutputStream);

    // use 0x02 | 0x10 to open file for appending.
    // use 0x02 | 0x08 | 0x20 for write, create, truncate
    foStream.init(localFile, 0x02 | 0x08 | 0x20, 0666, 0);
    if (debug) dump("  ..inited output stream\n");
    var converter = Components.
        classes["@mozilla.org/intl/converter-output-stream;1"].
        createInstance(Components.interfaces.nsIConverterOutputStream);
    converter.init(foStream, "UTF-8", 0, 0);
    if (debug) dump("  ..inited converter\n");
    return converter;
}

CommandLineHandler.prototype.handle = function(aCmdLine){
    var oktorun = 1;
    try {

        dump("Hello, Heikki's js engine starting\n");

        if ( aCmdLine.handleFlag("debug", false) )
            debug = 1;
        var infdflag = aCmdLine.handleFlagWithParam("infd", false);
        if ( infdflag )
            infd = "" + infdflag ; // as a string
        var outfdflag = aCmdLine.handleFlagWithParam("outfd", false);
        if ( outfdflag )
            outfd = "" + outfdflag ; // as a string
        if (oktorun) {
            var infstream = openinput( infd );
            var outfstream = openoutput( outfd );
            // We initiate the conversation with a simple OK
            outfstream.writeString("OK \n");
            var str = {};
            nread = 0;
            do {
                var maxread = 1024*1024; // commands are short, 1M must be enough
                read = infstream.readString(maxread, str);
                var line = str.value;
                if (line) {
                    if (debug) dump ("Received '" + line + "'\n");
                    line = "OK " + line;
                    outfstream.writeString(line);
                }
            } while (read != 0);
            if(debug) dump("closing files \n");
            infstream.close();
            outfstream.close();
        } // oktorun
    } catch (e) {
        dump("Exception : \n" + e + "\n" +e.stack);
        throw Components.results.NS_ERROR_ABORT;
    }
}

// TODO - Does not work
// See https://developer.mozilla.org/en/Chrome/Command_Line
CommandLineHandler.prototype.helpInfo = 
            "Simple js engine\n" +
            "  -help    display this text \n" +
            "  -debug   enable debug output \n" +
            "  -infd  N specify input file handle (default to stdin)\n" +
            "  -outfd N specify output file handle (default to stdout)\n";
  
CommandLineHandler.prototype.classDescription = "Headless xulrunner Command Line Handler",
CommandLineHandler.prototype.contractID = "@mozilla.org/headless/app-clh;1",
CommandLineHandler.prototype.classID = Components.ID("{b3633310-adcc-11de-8a39-0800200c9a66}"),
CommandLineHandler.prototype.QueryInterface = XPCOMUtils.generateQI([Components.interfaces.nsICommandLineHandler]),
CommandLineHandler.prototype._xpcom_categories = [{ category: "command-line-handler", entry: "x-headless" }]


function NSGetModule(compMgr, fileSpec)
  XPCOMUtils.generateModule([CommandLineHandler]);

