#!/bin/sh
# Copyright (c) 2010-2012 by Index Data ApS, http://www.indexdata.com
#
# mp-start.sh - start metaproxy for regression tests
#

if test -z `which Xvfb`; then
    echo "Xvfb not found"
    exit 1
fi
if test -z "$MP_PROG"; then
    for f in ../../../metaproxy/src/metaproxy /usr/bin/metaproxy; do
	if test -x "$f"; then
	    MP_PROG=$f
	    break
	fi
    done
fi
if ! command -v "$MP_PROG"; then
    echo "MP_PROG=$MP_PROG does not exist"
    exit 1
fi

case `uname` in 
    FreeBSD ) export LD_LIBRARY_PATH=../../../opt/lib:$LD_LIBRARY_PATH ;;
esac

if test -e mp.pid && kill -0 $(cat mp.pid); then
    echo "A metaproxy process is already running in this directory $(pwd)"
    echo ""
    exit 0
fi

it=0
maxit=240
while true; do
    rm -f mp.log
    CF_DISPLAY_LOCK=/tmp/cf-xvfb-$(whoami) CF_APP_PATH=`pwd` CF_TMP_DIR=`pwd` \
	$MP_PROG -c mp_config.xml -D -l mp.log -p mp.pid
    if test $? -eq 0; then
	break
    fi
    if test $it -eq 0; then
	echo "MP could not be started. Perhaps the port is in use"
	tail -3 mp.log
	echo ""
	echo "Waiting for the port to be available."
	echo "Just stop this script Ctrl-C if you don't want to wait"
    fi
    if test $it -ge $maxit; then
	echo "MP could not be started after $it seconds. Giving up"
	exit 1
    fi
    it=`expr $it + 10`
    sleep 10
done
    
sleep 0.2

if test -e mp.pid && ps -p $(cat mp.pid) >/dev/null 2>&1
then
    echo MP started
else
    echo "MP could not be started."
    if test -e mp.log; then
	echo ">>>>>>>>>>>>> $(pwd)/mp.log "
	tail mp.log
	echo "<<<<<<<<<<<<< $(pwd)/mp.log "
	echo ""
    fi
    exit 1
fi
