# Makefile to build xulrunner 10 and all depeneding components on systems
# that don't have GTK 2.10 or later.

# Everything will be installed here.. Can be a user directory so that
# no root privilege is required
prefix=/home/adam/cf

# libdir
libdir=$(prefix)/lib

# Environment that we need to use for configure and make operations
ENV_DEF=PKG_CONFIG_PATH=$(libdir)/pkgconfig:/opt/gnome/lib64/pkgconfig:/usr/lib64/pkgconfig LD_LIBRARY_PATH=$(libdir) PATH=$(prefix)/bin:/usr/X11R6/bin:$$PATH

# Beware that in some cases changing these versions means that the
# download location differs in wget below.
YAZ=yaz-4.2.33
YAZPP=yazpp-1.3.0
METAPROXY=metaproxy-1.3.37
PIXMAN=pixman-0.24.4
CAIRO=cairo-1.12.2
GLIB=glib-2.33.2
ATK=atk-2.4.0
PANGO=pango-1.30.1
GTK=gtk+-3.3.20
XULRUNNER=10.0.2

.PHONY: all requirements cf install-xulrunner install-metaproxy

all: requirements stamp-install-xulrunner stamp-install-metaproxy

install-metaproxy: stamp-install-metaproxy

install-xulrunner: stamp-install-xulrunner

cf:
	cd src
	$(ENV_DEF) $(MAKE) 

stamp-install-xulrunner: stamp-configure-xulrunner
	cd mozilla; $(ENV_DEF) $(MAKE) -f client.mk build
	cd mozilla; $(ENV_DEF) $(MAKE) install
	touch $@

stamp-configure-xulrunner: stamp-install-gtk
	for d in mozilla*; do \
		if test $$d; then rm -fr $$d; fi; \
	done
	tar jxf xulrunner-$(XULRUNNER)-source.tar.bz2
	for d in mozilla-*; do \
		if test $$d; then ln -s $$d mozilla; fi; \
	done
	/bin/echo -e "\
ac_add_options --enable-application=xulrunner\n\
mk_add_options MOZ_CO_PROJECT=xulrunner\n\
mk_add_options MOZ_MAKE_FLAGS=-j4\n\
ac_add_options --prefix=$(prefix)\n\
ac_add_options --libdir=$(libdir)\n\
ac_add_options --disable-crashreporter\n\
ac_add_options --disable-dbus\n\
ac_add_options --disable-debug\n\
ac_add_options --disable-gconf\n\
ac_add_options --disable-gnomevfs\n\
ac_add_options --disable-gnomeui\n\
ac_add_options --disable-javaxpcom\n\
ac_add_options --disable-libjpeg-turbo\n\
ac_add_options --disable-libnotify\n\
ac_add_options --disable-necko-wifi\n\
ac_add_options --disable-ogg\n\
ac_add_options --disable-printing\n\
ac_add_options --disable-svg\n\
ac_add_options --disable-wave\n\
ac_add_options --disable-webm\n\
ac_add_options --disable-methodjit\n\
">mozilla/.mozconfig
	touch $@

stamp-install-gtk: stamp-install-pango stamp-install-atk
	rm -fr $(GTK)
	unxz -c $(GTK).tar.xz|tar xf -
	cd $(GTK); $(ENV_DEF) ./configure --prefix=$(prefix) --libdir=$(libdir)
	cd $(GTK); $(ENV_DEF) $(MAKE) install
	touch $@

stamp-install-pango: stamp-install-cairo stamp-install-glib
	rm -fr $(PANGO)
	unxz -c $(PANGO).tar.xz|tar xf -
	cd $(PANGO); $(ENV_DEF) ./configure --prefix=$(prefix) --libdir=$(libdir) \
		--with-included-modules=yes --with-dynamic-modules=no
	cd $(PANGO); $(ENV_DEF) $(MAKE) install
	touch $@

stamp-install-atk: stamp-install-glib
	rm -fr $(ATK)
	unxz -c $(ATK).tar.xz|tar xf -
	cd $(ATK); $(ENV_DEF) ./configure --prefix=$(prefix) --libdir=$(libdir)
	cd $(ATK); $(ENV_DEF) $(MAKE) install
	touch $@

stamp-install-glib: stamp-download-xulrunner
	rm -fr $(GLIB)
	unxz -c $(GLIB).tar.xz|tar xf -
	cd $(GLIB); $(ENV_DEF) ./configure --prefix=$(prefix) --libdir=$(libdir)
	cd $(GLIB); $(ENV_DEF) $(MAKE) install
	touch $@

stamp-install-cairo: stamp-install-pixman
	rm -fr $(CAIRO)
	unxz -c $(CAIRO).tar.xz|tar xf -
	cd $(CAIRO); $(ENV_DEF) ./configure --prefix=$(prefix) --libdir=$(libdir)
	cd $(CAIRO); $(ENV_DEF) $(MAKE) install
	touch $@

stamp-install-pixman: stamp-download-xulrunner
	rm -fr $(PIXMAN)
	tar zxf $(PIXMAN).tar.gz	
	cd $(PIXMAN); $(ENV_DEF) ./configure --prefix=$(prefix) --libdir=$(libdir)
	cd $(PIXMAN); $(ENV_DEF) $(MAKE) install
	touch $@

stamp-install-metaproxy: stamp-install-yazpp
	rm -fr $(METAPROXY)
	tar zxf $(METAPROXY).tar.gz
	cd $(METAPROXY); $(ENV_DEF) ./configure --prefix=$(prefix) --libdir=$(libdir) --with-yazpp=$(prefix)/bin
	cd $(METAPROXY); $(ENV_DEF) $(MAKE) install
	touch $@

stamp-install-yazpp: stamp-install-yaz
	rm -fr $(YAZPP)
	tar zxf $(YAZPP).tar.gz	
	cd $(YAZPP); $(ENV_DEF) ./configure --prefix=$(prefix) --libdir=$(libdir) --with-yaz=$(prefix)/bin
	cd $(YAZPP); $(ENV_DEF) $(MAKE) install
	touch $@

stamp-install-yaz: stamp-download-metaproxy
	rm -fr $(YAZ)
	tar zxf $(YAZ).tar.gz	
	cd $(YAZ); $(ENV_DEF) ./configure --prefix=$(prefix) --libdir=$(libdir)
	cd $(YAZ); $(ENV_DEF) $(MAKE) install
	touch $@

stamp-download-metaproxy:
	gunzip -t $(YAZ).tar.gz || wget -O $(YAZ).tar.gz http://ftp.indexdata.dk/pub/yaz/$(YAZ).tar.gz
	gunzip -t $(YAZPP).tar.gz || wget -O $(YAZPP).tar.gz http://ftp.indexdata.dk/pub/yazpp/$(YAZPP).tar.gz
	gunzip -t $(METAPROXY).tar.gz || wget -O $(METAPROXY).tar.gz http://ftp.indexdata.dk/pub/metaproxy/$(METAPROXY).tar.gz
	touch $@

stamp-download-xulrunner:
	gunzip -t $(PIXMAN).tar.gz || wget -O $(PIXMAN).tar.gz http://www.cairographics.org/releases/$(PIXMAN).tar.gz
	xz -t $(CAIRO).tar.xz || wget -O $(CAIRO).tar.xz http://www.cairographics.org/releases/$(CAIRO).tar.xz
	xz -t $(GLIB).tar.xz || wget -O $(GLIB).tar.xz http://ftp.gnome.org/pub/gnome/sources/glib/2.33/$(GLIB).tar.xz
	xz -t $(ATK).tar.xz || wget -O $(ATK).tar.xz http://ftp.gnome.org/pub/gnome/sources/atk/2.4/$(ATK).tar.xz
	xz -t $(PANGO).tar.xz || wget -O $(PANGO).tar.xz http://ftp.gnome.org/pub/gnome/sources/pango/1.30/$(PANGO).tar.xz
	xz -t $(GTK).tar.xz || wget -O $(GTK).tar.xz http://ftp.gnome.org/pub/gnome/sources/gtk+/3.3/$(GTK).tar.xz
	if bunzip2 -t xulrunner-$(XULRUNNER).source.tar.bz2; then \
		echo OK;  \
	else \
		wget -O xulrunner-$(XULRUNNER).source.tar.bz2 http://ftp.indexdata.dk/pub/support/xulrunner-$(XULRUNNER).source.tar.bz2; \
	fi
	touch $@

clean:
	rm -f stamp-*

requirements:
	if test -f /etc/SuSE-release && grep -q 'VERSION = 10' /etc/SuSE-release ; then \
		rpm -q gcc gcc-c++ pkgconfig xorg-x11-devel zip \
			fam-devel cups-devel libtiff-devel libjpeg-devel \
			openssl-devel libidl-devel libpng-devel \
			libjasper libxslt-devel libxml2-devel ; \
	fi

