#!/bin/sh
# Copyright (c) 2010-2012 IndexData ApS, http://indexdata.com
#
# hudson.sh - wrapper for testing CF build
#

RET=0
dir=`pwd`
: ${make=make}
: ${make_opt=""}

# run on different port and display
: ${CF_REGRESSION_NUMBER=""}
: ${CF_CONNECTORS=../../connectors}

#CF_REGRESSION_NUMBER=79

if [ -n "$CF_REGRESSION_NUMBER" ]; then
    _cf_connenctors=$(mktemp -d connectors.XXXXXX)
    CF_CONNECTORS=../../${_cf_connenctors}
    rmdir ${_cf_connenctors}
    cp -a connectors ${_cf_connenctors}
    _mp_port=90${CF_REGRESSION_NUMBER}; export _mp_port
    CF_CONNECTORS=$CF_CONNECTORS ./engine/src/change-regression-port.sh ${_mp_port}
    CF_DISPLAY_START=4${CF_REGRESSION_NUMBER}; export CF_DISPLAY_START
    CF_CONNECTOR_PATH=$(pwd)/${_cf_connenctors}; export CF_CONNECTOR_PATH
    echo "Run metaproxy on port ${_mp_port}, xvfb on display: $CF_DISPLAY_START, from ${_cf_connenctors}"
fi

############################################################
# cf/engine
#
cd engine/src
for d in ../../../../yaz_distcheck/workspace ../../../yaz; do
	if test -d $d; then
		YAZ_CONFIG=$d/yaz-config
	fi
done
if test -z "$YAZ_CONFIG"; then
	echo 'YAZ not found'
	echo 'compile yaz, yazpp and metaproxy along with cf'
	exit 1
fi
for d in ../../../../metaproxy_distcheck/workspace  ../../../metaproxy; do
	if test -d $d; then
		METAPROXY_CONFIG=$d/metaproxy-config
		MP_PROG=$d/src/metaproxy
	fi
done
if test -z "$METAPROXY_CONFIG"; then
	echo 'metaproxy-config not found'
	exit 1
fi
PKG_CONFIG_PATH=/usr/cf-xulrunner/lib/pkgconfig
if test -d /usr/cf-xulrunner/lib64/pkgconfig; then
	PKG_CONFIG_PATH=/usr/cf-xulrunner/lib64/pkgconfig
fi
if test ! -d $PKG_CONFIG_PATH; then
	echo 'No $PKG_CONFIG_PATH (cf-xulrunner10-dev missing?)'
	exit 1
fi
if test ! -x "$MP_PROG"; then
	echo 'metaproxy daemon not found (not compiled?)'
	exit 1
fi
if test $RET -eq 0; then
	$make $make_opt \
	PKG_CONFIG_PATH=$PKG_CONFIG_PATH \
		MP_PROG=$MP_PROG \
		YAZ_CONFIG=$YAZ_CONFIG \
		MP_CONFIG=$METAPROXY_CONFIG \
		clean
	test $? -ne 0 && RET=1
fi


######################################################################
# you may want to stop the regression tests at first error with:
# REGRESSION_FATAL=true ./hudson.sh
#
if test $RET -eq 0; then
	echo ">>> Run regression and unit tests <<<"
	$make $make_opt \
	PKG_CONFIG_PATH=$PKG_CONFIG_PATH \
		MP_PROG=$MP_PROG \
		YAZ_CONFIG=$YAZ_CONFIG \
		MP_CONFIG=$METAPROXY_CONFIG \
		CF_CONNECTORS=$CF_CONNECTORS \
		check
	test $? -ne 0 && RET=1
fi

cd ../doc
$make $make_opt clean
cd ../..
if test $RET -eq 0; then
	echo ">>> Run package building tests <<<"
	echo -n "  mkdist.sh "
	if ./mkdist.sh >/dev/null 2>&1; then
	    echo "Ok"
	else
	    echo "Failed"
	    RET=1
	fi
fi

############################################################
# cf/builder
#
echo ">>> Run builder.xpi tests <<<"
echo -n "  builder.xpi "
cd $dir/builder
if $make $make_opt dist; then
    echo "Ok"
else
    echo "Failed"
    RET=1
fi

if [ -n "$CF_REGRESSION_NUMBER" ]; then
    echo "test output is in ${_cf_connenctors}"
fi

echo "hudson finished at `date`"
exit $RET

