#!/bin/bash
# Put a horrible load to a cf-zserver to see if it crashes

# To clean up properly:
# rm core; ./mp-stop.sh; killall metaproxy Xvfb zoomsh

# A nice thing to keep running in another terminal:
# while true; do  MP=`ps ax | grep metaproxy | grep -v grep | wc -l` ; ZS=`ps ax | grep zoomsh | grep -v grep | wc -l`; date "+%R:%S mp:$MP zs:$ZS"; ls -l core 2>/dev/null ;sleep 2; done

NUM=90  # remember to adjust the thread count in mp_config.xml
# if MP has more threads, you should not see (many) errors.
# if less, you'll see connection timeouts etc
DIR=zoomload.out
STOPFILE=zoomload.stop
SUMMARY=zoomload.summary.log
ENG="../../engine/src"
CORE="$ENG/core"
mkdir -p $DIR
rm -f $STOPFILE

if [ -f $CORE ]
then
  echo "Found a core file! Not starting"
  ls -l $CORE
  exit 1
fi

rm -f $SUMMARY
touch $SUMMARY


( cd $ENG;
  ulimit -c 99999999
  ./mp-stop.sh
  killall metaproxy
  rm -f *.log
  echo "$NUM zoomshells" 
  grep thread mp_config.xml
  sleep 1
  ./mp-start.sh
  sleep 0.3
  echo "Started MP at `cat mp.pid`"
  curl -q localhost:9070 > /dev/null # make a dummy request
)

MPP=`head -5 $ENG/mp.log | grep HTTP_Request | cut -d' ' -f2 | head -1`
echo "File handles of $MPP before firsrt zoom request"
ls -l /proc/$MPP/fd

sleep 3

rm -f $DIR/*.out
echo "Starting client loops"
for (( c=1; c<=$NUM; c++ ))
do
    OUT=$DIR/$c.out
    (
        while [ ! -f $STOPFILE -a ! -f $CORE ]
        do
            zoomsh \
                "open localhost:9070/cftest-02-indexdata-com" \
                "find @attr 1=keyword water" \
                "quit" >$OUT 2>&1
            echo "$c: " `date +%c` `cat $OUT` >> $SUMMARY
            grep -v "10 hits" $OUT
            rm $OUT
            sleep 0.1  # in case we get in a tight loop
        done
    ) &
done
echo "Waiting for them to get going"
sleep 5

while [ ! -f $STOPFILE -a ! -f $CORE ]
do
    N=`cat $SUMMARY | wc -l`
    E=`cat $SUMMARY | grep -v "10 hits" | wc -l`
    H=`ls /proc/$MPP/fd | wc -l`
    date  "+%c After $N runs, $E errors. $H file handles in use"
    if [ "$N" == "$E" ]
    then
        echo "Nothing seems to work. Giving up!"
        touch $STOPFILE
    fi
    # Sleep some seconds, but exit quickly if stopping
    for D in 1 2 3 4 5 6 7 8 9 10
    do
      if [ ! -f $STOPFILE -a ! -f $CORE ]
      then
        sleep 1
      fi
    done
done

if [ -f $CORE ]
then
  echo "Found a core file! Aborting"
else
  echo "Stop file found. Exiting"
fi

echo "Waiting for clients to die"
wait


echo Some selected error counts of `wc -l $SUMMARY` lines
for E in home tmp destination pipe Timeout creation
do
  echo `grep $E $SUMMARY | wc -l` `grep $E  $SUMMARY| head -1 | cut -c 47-` $E
  
done
echo "Not stopping metaproxy, so we can see file handles"
ls -l /proc/$MPP/fd

#( cd $ENG; ./mp-stop.sh )

