#!/bin/bash
# Put a horrible load to a cf-zserver to see if it crashes

# To clean up properly:
# rm core; ./mp-stop.sh; killall metaproxy Xvfb zoomsh

# A nice thing to keep running in another terminal:
# while true; do  MP=`ps ax | grep metaproxy | grep -v grep | wc -l` ; ZS=`ps ax | grep zoomsh | grep -v grep | wc -l`; date "+%R:%S mp:$MP zs:$ZS"; ls -l core 2>/dev/null ;sleep 2; done

NUM=150  # remember to adjust the thread count in mp_config.xml
# if MP has more threads, you should not see (many) errors.
# if less, you'll see connection timeouts etc
DIR=zoomload.out
STOPFILE=zoomload.stop
SUMMARY=zoomload.summary.log
ENG="../../engine/src"
CORE="$ENG/core"
mkdir -p $DIR
rm -f $STOPFILE

#if [ ! -z "$1" ]
#then
  echo "Fresh start, removing $SUMMARY"
  rm -f $SUMMARY
#fi

( cd $ENG;
  ulimit -c 99999999 ;
  ./mp-stop.sh;
  rm -f *.log;
  echo "$NUM zoomshells" ;
  grep thread mp_config.xml; 
  sleep 1;
  ./mp-start.sh )

while [ ! -f $STOPFILE -a ! -f $CORE ]
do
  rm -f $DIR/*.out
  for (( c=1; c<=$NUM; c++ ))
  do
    OUT=$DIR/$c.out
    (
    zoomsh \
         "open localhost:9070/cftest-02-indexdata-com" \
         "find @attr 1=keyword water" \
         "quit" 
    )  >$OUT 2>&1 &
  done
  wait
  cat $DIR/*.out >> $SUMMARY
  cat $DIR/*.out | grep -v "10 hits"
  N=`cat $SUMMARY | wc -l`
  E=`cat $SUMMARY | grep -v "10 hits" | wc -l`
  date  "+%c After $N runs, $E errors"
  if [ "$N" == "$E" ]
  then
    echo "Nothing seems to work. Giving up!"
    cd $ENG;
    ./mp-stop.sh
    exit 1
  fi
done

if [ -f $CORE ]
then
  echo "Found a core file! Aborting"
else
  echo "Stop file found. Exiting"
fi

echo Some selected error counts:
for E in home tmp destination pipe Timeout
do
  echo `grep $E zoomload.summary.log | wc -l` `grep $E  zoomload.summary.log | head -1 | cut -c 47-` $E
  
done
( cd $ENG; ./mp-stop.sh )

