use 5.008;
use ExtUtils::MakeMaker;
# See lib/ExtUtils/MakeMaker.pm for details of how to influence
# the contents of the Makefile that is written.
WriteMakefile(
    NAME         => 'Masterkey::Admin',
    VERSION_FROM => 'lib/Masterkey/Admin.pm', # finds $VERSION
    PREREQ_PM    => {
	Apache2::Cookie => 0,
	Apache2::Request => 0,
	Carp => 0,
	Encode => 0,
	Exporter => 0,
	HTML::Entities => 0,
	LWP => 0,
	Scalar::Util => 0,
	URI::Escape => 0,
	XML::Simple => 0, # Only needed for testing XML::LibXML::Simple
	Net::Z3950::ZOOM => 1.24,
	HTML::TagCloud => 0.34,
	File::Slurp => 9999.12,
	XML::LibXML::Simple => 0.13,
	FreezeThaw => 0.43,
	HTML::Mason => 0.00,
	Time::Piece => 0,
	Time::HiRes => 0,
    },
    ($] >= 5.005 ?     ## Add these new keywords supported since 5.005
      (ABSTRACT  => 'Administrative Web UI for MasterKey metasearcher',
       AUTHOR    => 'Mike Taylor <mike@indexdata.com>') : ()),
    EXE_FILES    => [ 'bin/ndbm-dump-sessions', 'bin/select-targets',
		      'bin/test-usi-targets', 'bin/torus-sed',
		      'bin/remove-mk2-orphans', 'bin/translate-mk-config' ],

    # This next line is the only way I know to turn off the stupid
    # PERL_DL_NONLAZY setting, which makes APR::Request::Apache2 fail
    # to load thanks to modperl_xs_sv2request_rec failage.  This
    # setting is hardwired into ExtUtils/MM_Unix.pm version 6.42 with
    # the oh-so-informative comment "For some reason which I forget,
    # Unix machines like to have PERL_DL_NONLAZY set for tests."
    FULLPERL => "PERL_DL_NONLAZY=0 /usr/bin/perl",
);


sub MY::postamble { q[debian: debian/output

debian/output:
	dpkg-buildpackage -us -uc -rfakeroot
	rm -rf debian/output
	mkdir debian/output
	mv ../masterkey-admin_*.deb \
           ../masterkey-admin_*.dsc \
           ../masterkey-admin_*.tar.gz \
           ../masterkey-admin_*.changes \
		debian/output
	lintian debian/output/*.deb
#	(cd debian/output; for i in *.deb; do name=`echo $$i | sed 's/\.deb$$//'`; dpkg-deb -c $$i > $$name.list; done)

debclean:
	rm -rf debian/output build-stamp install-stamp \
		debian/files \
		debian/masterkey-admin.substvars \
		debian/masterkey-admin \
		debian/*.log

debinstall: debian/output
	sudo dpkg -i debian/output/*.deb

debuninstall:
	sudo dpkg -r masterkey-admin

# It's incredibly dumb that we need to do this by hand
really_uninstall:
	$(ABSPERLRUN) "-MExtUtils::Install" -e 'uninstall("$(SITEARCHEXP)/auto/$(FULLEXT)/.packlist")'

GENERATED_PROFILES = \
config/system/profile/identity.torus-profile config/system/include/identity-fields.config doc/data-manual-identity.html config/system/web/home/fields-identity.html \
config/system/profile/searchable.torus-profile config/system/include/searchable-fields.config doc/data-manual.html config/system/web/home/data-manual.html

# There HAS to be a better way to add something to "make"
makemakerdflt: $(GENERATED_PROFILES)

# I can't find a way to make "make clean" do this
clean-profiles:
	rm -f $(GENERATED_PROFILES)

# General cases:
config/system/profile/%.torus-profile: config/system/profile/%-profile.yaml
	ruby bin/translate-mk-config -p $? > $@

config/system/include/%-fields.config: config/system/profile/%-profile.yaml
	ruby bin/translate-mk-config -m $? > $@

doc/data-manual-%.html: config/system/profile/%-profile.yaml
	ruby bin/translate-mk-config -H $? > $@

config/system/web/home/fields-%.html: config/system/profile/%-profile.yaml
	ruby bin/translate-mk-config -h $? > $@

### Four horrible special cases here: bring them in line with the general case later
config/system/profile/searchable.torus-profile: config/system/profile/target-profile.yaml
	ruby bin/translate-mk-config -p $? > $@

config/system/include/searchable-fields.config: config/system/profile/target-profile.yaml
	ruby bin/translate-mk-config -m $? > $@

doc/data-manual.html: config/system/profile/target-profile.yaml
	ruby bin/translate-mk-config -H $? > $@

config/system/web/home/data-manual.html: config/system/profile/target-profile.yaml
	ruby bin/translate-mk-config -h $? > $@

];
}
