<%args>
$param => "homeHtml"
</%args>


<%perl>
use Data::Dumper;

$m->comp("/mc/setup.mc");
my $user = $m->comp("/mc/utils/user.mc");
if (!defined $user) {
   print qq[How did you get here when you're not <a href="/console/">logged on</a>?\n];
   return;
}

my $admin = $m->notes("admin");
my $html = $admin->configValue($param);
my $identityId = $user->field("identityId");

my $debug = $admin->configValue("BillingDebug") || 0;

my @format = (
    ["csv", "CSV"],
    ["html", "HTML"],
);

my %default = (
    'date_range_selected' => 'alias',
    'date' => "last_quarter",
    'format' => "html",
    'supported_formats' => "csv html",
    'details' => "yes",
    'creation' => "",
    'details_enabled' => "1",
    'creation_enabled' => "1",
    'library_only' => "0",
);


$default{'format'} = $admin->configValue("BillingFormat") if defined $admin->configValue("BillingFormat");
$default{'supported_formats'} = $admin->configValue("BillingSupportedFormats") if defined $admin->configValue("BillingSupportedFormats");
$default{'details_enabled'} = $admin->configValue("BillingDetailsEnabled") if defined $admin->configValue("BillingDetailsEnabled");
$default{'date_aliases'} = $admin->configValue("serviceProxyBillingDateRangeAliases") if defined $admin->configValue("serviceProxyBillingDateRangeAliases");

#$default{'date_aliases'} = "today yesterday 7days month last_month quarter last_quarter all_time";
$default{'library_only'} = $admin->configValue("BillingLibraryOnly") if defined $admin->configValue("BillingLibraryOnly");

my @details = (['' => 'none'], ['yes' => 'with libraries?']);
my @creations = (['yes' => 'yes'], ['' => 'no']);

</%perl>

<h2>Billing Target Report for <% $user->displayName() %></h2>

% if (!$admin->configValue("BillingEnabled")) {
   <p>Sorry, the billing statistic is not enabled for this site. Please contact your MK2 administrator!</p>
% return; }


<form action="billing-q.cgi" >
  <table>
  <tr>
  <th></th>
  <!-- <th>x-axis</th> -->
  <!-- <th>y-axis</th>  -->
  </tr>

  </table>

<%perl>
my %supported_formats = map { $_ => 1 } split /\s+/, $default{'supported_formats'};
foreach my $f (@format) {
    my ($key, $value) = @$f;

    next if !$supported_formats{$key};
    my $selected = $key eq $default{'format'} ? qq{checked="checked"} : "";

    print qq{<input type="radio" name="output_format" value="$key" $selected>$value</input>\n};
}

</%perl>

<!-- <input type="checkbox" name="billing_confirmed" value="billing"></input> Mark as billed (here are dragons!) <br/> -->

<%perl>
if (0 && $default{'details_enabled'}) {
    print "<p>Details:";
    foreach my $f (@details) {
        my ($key, $value) = @$f;
        my $selected = $key eq $default{'details'} ? qq{checked="checked"} : "";
        print qq{<input type="radio" name="details" value="$key" $selected>$value</input>\n};
    }
}
if (0 && $default{'creation_enabled'}) {
    print "<p>Only new created targets:";
    foreach my $f (@creations) {
        my ($key, $value) = @$f;
        my $selected = $key eq $default{'creation'} ? qq{checked="checked"} : "";
        print qq{<input type="radio" name="creation" value="$key" $selected>$value</input>\n};
    }
}

</%perl>

% if (!$default{'library_only'}) {
</p>
<p>Exclude libraries by name:
<input name="excluded" value=""></input>
</p>
% } else {
<br/>
% }


% $m->comp("/mc/date.mc", %default);

<input type="submit" name="submit" value="Generate Statistics" />
</form>

<p/>
