function maybeFill (node, targetId) {
    var target = document.getElementById(targetId);
    if (target.value == "")
	target.value = node.value.toLowerCase().replace(/[^a-z0-9]/ig, "_");
}

function toggle (targetId) {
    var target = document.getElementById(targetId);
    var oldval = target.value;
    target.value = (oldval == 0 ? 1 : 0);
    //alert("changed " + targetId + " from " + oldval + " to " + target.value);
}

function okToChange () {
    return confirm("STOP! \
\
IMPORTANT MESSAGE: \
\
Resources available for selection by your library are LIMITED to: \
\
  Titles for which your library maintains a current license or subscription; \
  Titles designated as selected free web resources; \
  Library OPACs. \
\
SELECTING RESOURCES OTHER THAN THOSE LISTED ABOVE IS A VIOLATION OF EXISTING LICENSE AGREEMENTS!");

}

function rewriteValue (elem, targetId, sep) {
    var value = "";
    if (!sep) sep = ",";

    for (var i = 0; i < elem.length; i++) {
        var opt = elem.options[i];
        if (opt.selected) {
            if (value) value = value + sep;
            value = value + opt.value;
        }
    }

    var target = document.getElementById(targetId);
    target.value = value;
    //alert("rewrote value for " + targetId + " as '" + value + "'");
}

/*
 * This function knows about the layout of the editing form, and it
 * thus closely tied to mc/edit.mc
 */
function maybeDeleteOverride (fieldname, displayName) {
  var field = document.getElementById("input-" + fieldname);
  var Ofield = document.getElementById("O" + fieldname);
  var Dfield = document.getElementById("D" + fieldname);

  if (field.value == "" && Ofield.value != "") {
    deleteOverride = confirm("Do you wish to delete the override for " +
                             displayName + " completely?  " +
                             "If you do, the base value will be used; " +
                             "otherwise, the field will be empty.");
    Dfield.value = deleteOverride ? "1" : "0";
  }
}

/*
 * Date range helper: if you change a date range value, then
 * also pre-select the simple/custom date radio button
 */

function selectRadioButton (id) {
    var button = document.getElementById(id);
    if (button)
    	button.checked = "checked";
}

/*
 * (un)select all targets
 *
 */

function toggleSelected () {
    var checkboxes = document.getElementsByTagName("input");
    var checked, unchecked = 0;

    // if all boxes are checked, do an uncheck. Otherwise to a check.
    for (var i = 0; i < checkboxes.length; i++) {
        var c = checkboxes[i];
        if (c.type != "checkbox") {
            continue;
        }
        if (!c.checked) unchecked++;
    }

    // if all targets are unselected, start with select
    var toggleSelectedStatus = unchecked == 0 ? 1 : 0;

    for (var i = 0; i < checkboxes.length; i++) {
        var c = checkboxes[i];
        if (c.type != "checkbox") {
            continue;
        }

        if (toggleSelectedStatus) {
            if (c.checked) {
                c.removeAttribute("checked");
                c.onchange();
            }

        } else {
            if (!c.checked) {
                c.setAttribute("checked","0");
                c.onchange();
            }
        }
    }
}
