<%args>
$file => "/tmp/affiliation.csv"
$debug => 0
</%args>
<%once>
use Masterkey::Admin::Report;
use IO::File;
</%once>


<%perl>
my $file_tmp = $file . ".tmp.$$";

warn "Re-generate '$file_tmp'\n" if $debug;
my $fh = new IO::File $file_tmp, "w";

if (!defined $fh) {
    die "open $file_tmp: $!\n";
}
	
$m->comp("/mc/setup.mc");
my $admin = $m->notes("admin");
my $user = $m->comp("/mc/utils/user.mc") or return;

my $report = new Masterkey::Admin::Report();
my $rs = $report->itorus()->records("admin", undef, undef, 1);
my $identities = $rs->records();
### Should we uniquify on realm?
my @identities = sort { $a->displayName() cmp $b->displayName() } @$identities;

foreach my $identity (@identities) {
    my $name = $identity->displayName();
    my $realm = $identity->field("identityId");
    print $fh $report->row($realm, $name);
}

$fh->close;
rename($file_tmp, $file) or die "rename $file_tmp -> $file: $!\n";

</%perl>
