<%args>
$facets
$cloud
$query
</%args>

<%perl>
my $admin = $m->notes("admin");
my $showFacets = $admin->configValue("showFacets");
my $showTagCloud = $admin->configValue("showTagCloud");

if ($showFacets || $showTagCloud) {
    # Finding the correct torus to load category ID->Name maps from is
    # awkward.  The torus is specified in the appropriate categories
    # tab's configuration, but to determine which tab that is, we need
    # to look at how this tab's configuration says to edit the
    # categories field.  If there is no such configuration, then we do
    # no mapping.
    my %categoryId2name;
    my $tab = $admin->configValue("field.categories.editType");
    if ($tab) {
	$tab =~ s/.* //;
	#warn "getting category mapping from tab '$tab'";
	my $user = $m->comp("/mc/utils/user.mc", require => 1);
	my $sadmin = new Masterkey::Admin($tab);
	my $rs = $sadmin->torus()->records($user->field("identityId"));
	my $catList = $rs->records();
	foreach my $cat (@$catList) {
	    my $id = $cat->field("categoryId");
	    $categoryId2name{$id} = $cat->displayName();
	    #warn "mapped '$id' -> '", $categoryId2name{$id}, "'";
	}
    }

    my $f = "";
    ### FOR NOW, skip facets if they have not been provided.  This works around bug #4270
    if ($showFacets && $facets->{"serviceProvider"}) {
        $f .= ("<hr>" .
	       "<p>Service Provider</p>" .
	       $facets->{"serviceProvider"}->html_js(query => $query, 'max'=>20, 'cql_field' => 'serviceProvider==') .
	       "<p>Categories</p>" .
	       $facets->{"categories"}->html_js(query => $query, 'cql_field' => 'categories=',
						map_function => sub { $categoryId2name{$_[0]} || "[" . $_[0] . "]" } ) .
	       "<p>Opac Vendor</p>" .
	       $facets->{"opacVendor"}->html_js(query => $query, 'max'=>10, 'cql_field' => 'opacVendor=='));
    }

    ### Test on $cloud is another bug #4270 workaround
    if ($showTagCloud && $cloud) {
        $f .= "<hr>" . $cloud->html_and_css_js(42); 
    }
    $f .= "<hr>";
</%perl>

<script type="text/javascript">
//<![CDATA[
        var facets = document.getElementById("facets");
        if (facets) {
            facets.innerHTML = '<% $f %>';
        }
//]]>
        </script>
% }

