<%args>
$query => ""
$days => undef
$current => undef
</%args>

<%perl>
sub jsQuote {
    my($s) = @_;

    $s =~ s/&#39;/'/g;
    $s =~ s/&#34;/"/g;
    $s =~ s/&quot;/"/g;
    $s =~ s/(['"])/\\$1/g;
    return $s;
}


my $fullquery = $m->comp("/mc/make-fullquery.mc", query => $query, days => $days);

my $admin = $m->notes("admin");
my $pluralType = $m->notes("pluralType");
print "   <h2>", $admin->caption("listObjects", "My $pluralType"), "</h2>\n";
my $user = $m->comp("/mc/utils/user.mc", require => 1) or return;

my($nadded, $ndeleted);
if ($ARGS{submit}) {
    ($nadded, $ndeleted) = $m->comp("submit-changes", %ARGS);
}

my $realm = $user->field("identityId");
my $startFrom = $ARGS{start};
my $pageSize = $ARGS{num} || $admin->configValue("pageSize") || 50;
my $rs;
eval {
    $rs = $admin->torus()->sortedMerged($realm, $fullquery, $user, $startFrom, $pageSize);
}; if ($@) {
    print $admin->exception2error($@);
    return;
}
my $alln = $rs->alln();

my $rn = $admin->caption("recordName", "target");
my $rnp = $admin->caption("recordNamePlural", "targets");

my $fieldList = $admin->configValue("fieldList");
my @fields;
if (defined $fieldList) {
    @fields = split(/,\s*/, $fieldList);
} elsif ($admin->configValue("showProvider")) {
    @fields = ("serviceProvider");
} else {
    @fields = ();
}

if ($nadded) {
    print "<p><b>Added $nadded ", ($nadded==1 ? $rn : $rnp), "</b><p>\n";
}
if ($ndeleted) {
    print "<p><b>Deleted $ndeleted ", ($ndeleted==1 ? $rn : $rnp), "</b><p>\n";
}

my ($start_record, $last_record, $__UNUSED_pageSize, $pagingHTML, $rangeHTML) =
    $m->comp("paging.mc", r => $r, alln => $alln, query => $fullquery);

$m->comp("facets_output.mc", facets => $rs->facets(), cloud => $rs->cloud(), query => $fullquery);
</%perl>

<& /mc/form.mc, action => "checklist.html", query => $query, days => $days &>
   <p><!-- Selected <% $rs->myn() %> of <% $alln %> <% $alln==1 ? $rn : $rnp %><%
defined $fullquery && $fullquery ne "" ? " matching query" : "" %>.<br /> -->
<% $rangeHTML %>

% my $onsubmit = $admin->configValue("form.onsubmit");
   <form method="POST" action="checklist.html"<% defined $onsubmit ? " onsubmit='$onsubmit'" : "" %>>

% my $spos = $admin->configValue("submitPosition");
% if (defined $spos && ($spos eq "top" || $spos eq "both")) {
<& buttons &>
% }

<% $pagingHTML %>

   <table class="list">
    <tr>
     <th><% $admin->caption("nameObject", "Name") %></th>
% foreach my $field (@fields) {
     <th><% $m->comp("caption.mc", field => $field) %></th>
% }
     <th><span onclick="toggleSelected();" title="(un)select all targets"><% $admin->caption("selected", "") %></span></th>
% if (!$admin->configValue("linkToEdit") && !$admin->configValue("disableEdit")) {
     <th><% $admin->caption("editObject", "") %></th>
% }
% my $loginFor = $admin->configValue("listLoginFor");
% if (defined $loginFor) {
     <th><% $admin->caption("actAs", "Act as") %></th>
% }
    </tr>

<%perl>
foreach my $i ($start_record .. $last_record) {
    my $rec = $rs->record($i);
    my $isWorldRecord = $rec->isWorldRecord();
    my $isDisabled = !$isWorldRecord && $rec->field("disabled");
    my $isCurrent = defined $current && $current eq $rec->field("id");
    my $type = ($isWorldRecord ? "worldId" : "id");
    my $id = $rec->field("id");
    my $idTypeAndVal = encode_entities("$type=$id");
    my $idTypeAndQuotedVal = encode_entities("$type=" . uri_escape_utf8($id));
    my $idTypeAndJSVal = encode_entities("$type=" . jsQuote($id));
</%perl>
    <tr>
     <td>
% print "<b>" if $isCurrent;
% my $action = $admin->configValue("linkToEdit") && !$isWorldRecord ? "edit" : "single";
      <a href="<% $action %>.html?<% $idTypeAndQuotedVal
	%>"><% encode_entities($rec->displayName()) %></a>
% print "</b>" if $isCurrent;
     </td>
% foreach my $field (@fields) {
<%perl>
my $val;
if ($field eq '_auth') {
    $val = $m->comp("authValue.mc", rec => $rec);
} else {
    $val = encode_entities($rec->field($field));
    my $sep = $admin->configValue("field.$field.breakAfterChar");
    if (defined $sep) {
	# Each occurrence of the separator is followed by a zero-width space
	$val =~ s/\Q$sep\E/$&&#x200b;/g;
    }
}
</%perl>
     <td>
      <% $val %>
     </td>
% }
     <td>
      <input type="checkbox" class="selected"<% !$isWorldRecord && !$isDisabled ? ' checked="1"' : ''
%> onchange="toggle('<% $idTypeAndJSVal %>')"/>
      <input type="hidden" id="<% $idTypeAndVal %>" name="<% ($isDisabled ? "D" : "") . $idTypeAndVal %>" value="<% !$isWorldRecord && !$isDisabled ? 1 : 0 %>"/>
      <% $isDisabled ? "<span title='disabled'>*</span>" : "" %>
     </td>
% if (!$admin->configValue("linkToEdit") && !$admin->configValue("disableEdit")) {
     <td>
% if (!$isWorldRecord) {
<& /mc/link/edit.mc, context => "list", id => $rec->field("id") &>
% }
     </td>
% }
<& /mc/link/actas.mc, context => "list", rec => $rec, loginFor => $loginFor &>
    </tr>
% }
% if (!$admin->configValue("disableCreate")) {
    <tr>
     <td colspan="2" class="right"><% $admin->caption("createLink", "Create") %>
	&nbsp;&nbsp;&nbsp;&nbsp;</td>
     <td>
<& /mc/link/new.mc, context => "list" &>
     </td>
    </tr>
% }
   </table>

   <% $pagingHTML %>
% if (!defined $spos || ($spos eq "bottom" || $spos eq "both")) {
<& buttons &>
% }
   <input type="hidden" name="query" value="<% encode_entities($query) %>"/>
   <input type="hidden" name="days" value="<% encode_entities($days) %>"/>
   <input type="hidden" name="start" value="<% encode_entities($startFrom) %>"/>
   </form>

<%def submit-changes>
<%perl>
my $torus = $m->notes("admin")->torus();
my $user = $m->notes("user");
my $realm = $user->field("identityId");
my($nadded, $ndeleted) = (0, 0);

# I don't know why, but utf8param() does not find POSTed arguments,
# only GETted ones.  So we need to use HTML::Mason's %ARGS instead.
foreach my $name (sort keys %ARGS) {
    my($type, $id) = ($name =~ /(.*)=(.*)/);
    if (!defined $type) {
	# Simple parameters such as "submit" and "query"
	next;
    }

    # Compound parameters such as "worldId=B.C.812-0" and "id=B.C.671-0-0"
    my $val = $ARGS{$name};
    #warn "submit-changes: type='$type', id='$id', val='$val'";

    my $torusVer = $torus->torusVer();
    if (!defined $torusVer) {
	# No operation has yet happened on the Torus: force one
	$torus->records($realm, "id=123noXsuchXid");
	$torusVer = $torus->torusVer()
	    or die "still no torusVer after forced fetch";
    }

    if ($type eq "id" && $val == 0 && $torusVer >= 2.13) {
	$torus->disable($realm, $id);
	#warn "disabled '$id'\n";
	$ndeleted++;
    } elsif ($type eq "id" && $val == 0) {
	$torus->delete($realm, $id);
	#warn "deleted '$id'\n";
	$ndeleted++;
    } elsif ($type eq "worldId" && $val == 1) {
	$torus->add($realm, $id, $user);
	#warn "added '$id'\n";
	$nadded++;
    } elsif ($type eq "Did" && $val == 1) {
	# Previously disabled record, now being re-enabled
	$torus->enable($realm, $id);
	#warn "enabled '$id'\n";
	$nadded++;
    }
}
return ($nadded, $ndeleted);
</%perl>
</%def>
<%def buttons>
   <p>
    <button type="button" onclick="selectAll()">Select all</button>
    <input type="submit" name="submit" value="Submit changes"/>
   </p>
</%def>
<script type="text/javascript">
function selectAll() {
    var elements = document.getElementsByClassName('selected');
    for (var i = 0; i < elements.length; i++) {
	var elem = elements[i];
	if (!elem.checked)
	    elements[i].click();
    }
}
</script>
