<%args>
$id => undef;
</%args>

<%once>
### It may be possible to invert this component to use the record.mc skeleton
# Special fields which should not be edited
my @protected = qw(worldId id identity realm originalUri creationDate lastModified);

use CGI;
</%once>
<%perl>

our $q = $m->notes("q");
my $admin = $m->notes("admin");
my $user = $m->comp("/mc/utils/user.mc", require => 1) or return;

my $nupdates = undef;
my $cancelled = 0;
my $record;
my %data;
my $goneHash = {};

my $debug = 1;

sub utf8param_post {
    my($r, $key, $value) = @_;

    if (defined $value) {
	warn "Warning -  setting key: $key => $value works only inside CGI.pm!\n";
        return decode_utf8 ($q->param($key, encode_utf8($value)));
    } elsif(!defined $key) {
	# list of keywords
        return map { decode_utf8($_) } $q->param();
    } else {
	return decode_utf8( $q->param($key) );
    }
}

eval {
    #warn "utf8param_post(Submit) = '", utf8param_post($r, "Submit"), "'; q->param(Submit) = '", $q->param("Submit"), "'";
    if (defined $q->param("Submit")) {
	foreach my $key (utf8param_post($r)) {
	    next if $key eq "Submit";
	    next if $key =~ /^[OD]/;
	    next if $key =~ /^ignored-/;
	    if (utf8param_post($r, "D$key")) {
		$goneHash->{$key} = 1;
		utf8param_post($r, $key, ""); # Don't display old value
		next;
	    }
	    my $new = utf8param_post($r, $key);
	    my $old = utf8param_post($r, "O$key");
	    if (!defined $old || $new ne $old) {
		$data{$key} = $new;
	    }
	}
	delete $data{id};
	foreach my $i (1..1) {
	    my $name = delete $data{"name$i"};
	    my $value = delete $data{"value$i"};
	    if (defined $name && $name =~/[^a-z0-9_-]/i) {
		die "Invalid fieldname '$name'";
	    } elsif (defined $name && $name ne "" && defined $value &&
		!grep { $_ eq $name } @protected) {
		$data{$name} = $value;
	    }
	}
	warn "%data has ", scalar(keys %data), " keys: [", join(", ", map { "'$_'='" . $data{$_} . "'" } sort keys %data), "]\n";
	$nupdates = keys(%data) + keys(%$goneHash);
	my $identity = $user->field("identityId");
	if ($nupdates == 0) {
	    # Do nothing
	} elsif (defined $id && $id ne "") {
	    $record = $admin->modify_record($identity, $id, undef,
					    $goneHash, %data);
	} else {
	    $id = $admin->make_record($identity, $user, %data);
	}
    } elsif (defined utf8param_post($r, "Cancel")) {
	$cancelled = 1;
    }

    # Record may already have been returned as part of update validation
    $record = $admin->torus()->record($user->field("identityId"), $id)
	if defined $id && !defined $record;;
}; if ($@) {
    print $admin->exception2error($@);
    return;
}
</%perl>
% if (defined $id) {
   <h2><% $admin->configValue("disableRecordType") ? "" :
	encode_entities($record->type()) . ": " %><%
	encode_entities($record->displayName()) %></h2>
% } else {
   <h2><% $admin->caption("createRecord", "Create new record") %></h2>
% }
% my $simpleEdit = $admin->configValue("simpleEditForm");
% my $needbase = defined $id && !$admin->configValue("noworld") && !$simpleEdit;
% if ($cancelled) {
   <p class="error">
    Changes cancelled
   </p>
% } elsif (defined $nupdates && $nupdates > 0 && !defined $id) {
   <p class="error">
    Record not added
   </p>
% } elsif (defined $nupdates && $nupdates == 0) {
   <p>
    <b>No changes!</b>
   </p>
% } elsif (defined $nupdates) {
   <p>
    <b><% $nupdates == 1 ? "1 update has" : "$nupdates updates have" %>
	been noted.</b><br/>
% if (%data) {
    Modified field<% keys(%data) == 1 ? "" : "s" %>:
    <% join(", ", sort map { encode_entities($admin->fieldname($_)) } keys %data) %>.<br/>
% }
% if (%$goneHash) {
    Deleted field<% keys(%$goneHash) == 1 ? "" : "s" %>:
    <% join(", ", sort map { encode_entities($admin->fieldname($_)) } keys %$goneHash) %>.<br/>
% }
   </p>
% }
<& toolbar, id => $id, record => $record &>
   <form method="post" action="<% $r->uri %>">
    <table class="editform" border="1" cellpadding="3" cellspacing="1">
     <tr>
      <th class="right">Field</th>
% if ($needbase) {
      <th><% $admin->caption("baseValue", "Base value") %></th>
% }
      <th>
       <% $needbase ? $admin->caption("localValue", "Local value") : "Value" %>
<& submit-button, id => $id &>
      </th>
     </tr>
<%perl>
# Gather fields: all those in the profile, then any that are not in
# the profile; this list is then reordered by pulling any protected
# fields to the top.
my $profile = $m->notes("admin")->config()->profile();
my @fields = $m->comp("fields.mc", profile => $profile, record => $record,
		      protected => \@protected);
</%perl>
% foreach my $field (@fields) {
% my $mandatory = $profile->mandatory($field);
% my $displayAnyway = ($mandatory && (!defined $record || !$record->field($field, "final")));
% $displayAnyway = $admin->configValue("defaultFullRecord");
% my $visible = $admin->configValue("field.$field.visible") || $displayAnyway;
% if (!$admin->configValue("disableSections")) {
%   my $section = $admin->configValue("field.$field.startSection");
%   if (defined $section) {
     <tr<% $displayAnyway || $admin->config()->sectionHasVisibleFields($field) ? "" : ' class="hidden"' %>>
      <th colspan="<% $needbase ? 3 : 2 %>" class="subhead">
       <% encode_entities($section) %>
      </th>
     </tr>
%   }
% }
     <tr<% $visible ? "" : ' class="hidden"' %>>
      <td class="field-name"><% encode_entities($admin->fieldname($field)) %><%
	$mandatory ? "<span class='error'>*</span>" : "" %>
      </td>
% my $oval = defined $record ? $record->field($field, "override") : "";
% if ($needbase) {
      <td class="base-value<% defined $oval ? ' disabled' : '' %>"><%
	encode_entities($record->field($field, "original")) %></td>
% }
      <td>
% my $protected = !!(grep { $_ eq $field } @protected);
<& input.mc, field => $field, record => $record, user => $user, protected => $protected, seeBase => $simpleEdit &>
% my $qfield = encode_entities($field);
       <input type="hidden" name="O<% $qfield %>" id="O<% $qfield
	%>" value="<% encode_entities($oval) %>">
% if (defined $oval && $needbase && !$protected) {
       <br/>
       <input type="checkbox" name="D<% $qfield %>" id="D<% $qfield %>">
       <label for="D<% $qfield %>">
        <small>Remove override</small>
       </label>
% }
% if (defined utf8param_post($r, "Submit") && $mandatory &&
%      (!defined $data{$field} || $data{$field} eq "") &&
%      (!$record || !defined $record->field($field) || $record->field($field) eq "")) {
       <br/>
       <span class="error">Please fill this field in!</span>
% }
      </td>
     </tr>
% }
     <tr <% $admin->configValue("defaultFullRecord") ? "" : ' class="hidden"' %>>
      <td colspan="<% $needbase ? 3 : 2 %>">
       <small><% $admin->caption("addFields", "Add new fields below: specify both name and value") %></small>
      </td>
     </tr>
% foreach my $i (1..1) {
     <tr <% $admin->configValue("defaultFullRecord") ? "" : ' class="hidden"' %>>
      <td>
       <input class="editable" type="text" name="name<% $i %>" size="12"/>
      </td>
% if ($needbase) {
      <td>
      </td>
% }
      <td>
       <input class="editable" type="text" name="value<% $i %>" size="45"/>
      </td>
     </tr>
% }
     <tr>
      <td colspan="3" align="right">
<& submit-button, id => $id &>
      </td>
     </tr>
    </table>
   </form>
<& toolbar, id => $id, record => $record &>
<%def submit-button>
<%args>
$id
</%args>
% my $admin = $m->notes("admin");
% my $pos = $admin->configValue("button.save.position") || "right";
       <input type="submit" name="Submit" value="<%
	defined $id ? "Save Changes" : "Add Record"
	%>" class="<% $pos %>" style="float: <% $pos %>"/>
% $pos = $admin->configValue("button.cancel.position") || "hidden";
       <input type="submit" name="Cancel" value="<%
	defined $id ? "Cancel Changes" : "Abandon Record"
	%>" class="<% $pos %>" style="float: <% $pos %>"/>
</%def>
<%def toolbar>
<%args>
$id
$record
</%args>
% my $admin = $m->notes("admin");
% return if $admin->configValue("disableActionBar");
   <p style="padding-top: 1em; padding-bottom: 2em">
    <span style="float:left">
<& /mc/showhide-fields.mc &>
    <button type="button" onclick="window.location.href='single.html?id=<% encode_entities($id) %>'">Show record</button>
    <button type="button" onclick="window.location.href='<% $admin->configValue("listPage") %>'">List records</button>
    </span>
% if (defined $id) {
    <span style="float:left">
    &nbsp;
<& /mc/link/actions.mc, context => "toolbar/edit", user => $m->notes("user"), record => $record &>
<& showuri.mc, uri => $record->uri() &>
% }
    </span>
   </p>
</%def>
