<%args>
$query => undef
$days => undef
$current => undef
</%args>
<%perl>
my $fullquery = $m->comp("/mc/make-fullquery.mc", query => $query, days => $days);

my $q = $m->notes("q");
my $admin = $m->notes("admin");
my $pluralType = $m->notes("pluralType");
</%perl>
   <h2><% $admin->caption("myObjects", "My $pluralType") %></h2>
<%perl>
$m->comp("/mc/form.mc", action => "my.html", query => $query, days => $days);
if (!defined $query) {
    return;
}

my $user = $m->comp("/mc/utils/user.mc", require => 1) or return;
my $rs;
eval {
    my $realm = $user->field("identityId");
    $rs = $admin->torus()->sortedRecords($realm, $fullquery, $user, utf8param($q, "start"), $admin->configValue("pageSize") || 50);
}; if ($@) {
    print $admin->exception2error($@);
    return;
}

my ($start_record, $last_record, $pageSize, $pagingHTML, $rangeHTML) =
    $m->comp("paging.mc", r => $r, alln => $rs->alln(), query => $fullquery);

$m->comp("facets_output.mc", facets => $rs->facets(), cloud => $rs->cloud(), query => $fullquery);

my $fieldList = $admin->configValue("fieldList");
my @fields;
if (defined $fieldList) {
    @fields = split(/,\s*/, $fieldList);
} elsif ($admin->configValue("showProvider")) {
    @fields = ("serviceProvider");
} else {
    @fields = ();
}
</%perl>
   <% $rangeHTML %>
   <% $pagingHTML %>

   <table class="list">
    <tr>
     <th><% $admin->caption("nameObject", "Name") %></th>
% foreach my $field (@fields) {
     <th><% $m->comp("caption.mc", field => $field) %></th>
% }
% if (!$admin->configValue("linkToEdit") && !$admin->configValue("disableEdit")) {
     <th><% $admin->caption("editObject", "") %></th>
% }
     <th><% $admin->caption("deleteObject", "") %></th>
% my $loginFor = $admin->configValue("listLoginFor");
% if (defined $loginFor) {
     <th><% $admin->caption("actAs", "Act as") %></th>
% }
    </tr>
<%perl>
 foreach my $i ($start_record .. $last_record) {
     my $rec = $rs->record($i);
</%perl>

    <tr>
     <td>
% my $isWorld = $rec->field('realm') eq 'world';
% my $linkField = $isWorld ? 'worldId' : 'id';
% print "<b>" if defined $current && $current eq $rec->field("id");
% my $action = $admin->configValue("linkToEdit") ? "edit" : "single";
      <a href="<% $action %>.html?<% $linkField %>=<% encode_entities(uri_escape_utf8($rec->field("id")))
	%>"><% encode_entities($rec->displayName()) %></a>
% print "</b>" if defined $current && $current eq $rec->field("id");
     </td>
% foreach my $field (@fields) {
<%perl>
my $val;
if ($field eq '_auth') {
    $val = $m->comp("authValue.mc", rec => $rec);
} else {
    $val = encode_entities($rec->field($field));
}
</%perl>
     <td>
      <% $val %>
     </td>
% }
% if (!$admin->configValue("linkToEdit") && !$admin->configValue("disableEdit")) {
     <td>
% if (!$isWorld) {
<& /mc/link/edit.mc, context => "list", id => $rec->field("id") &>
% }
     </td>
% }
     <td>
% if (!$isWorld) {
<& /mc/link/delete.mc, context => "list", id => $rec->field("id"), query => $fullquery &>
% }
     </td>
<& /mc/link/actas.mc, context => "list", rec => $rec, loginFor => $loginFor &>
    </tr>
% }
% if (!$admin->configValue("disableCreate")) {
    <tr>
     <td class="right"><% $admin->caption("createLink", "Create") %>
	&nbsp;&nbsp;&nbsp;&nbsp;</td>
     <td colspan="3">
<& /mc/link/new.mc, context => "list" &>
     </td>
    </tr>
% }
   </table>

   <% $pagingHTML %>

% if ($admin->configValue("mkWidgets")) {
   <p>
    <a href="mkwidget.html<% !$query ? "" :
	("?query=" . encode_entities(uri_escape_utf8($query)))
	%>">Create auto-search widget</a>
   </p>
% }
