# For use instead of Masterkey::Admin for standalone utilities such as 
# ../../../bin/test-usi-targets that want to use the Torus library
# without bringing the whole MKAdmin machinery to bear.

package Masterkey::Admin::Dummy;

use strict;
use warnings;

use Masterkey::Admin::LogLevel;

sub new {
    my $class = shift();
    my $this = bless { @_ }, $class;
    my $l = $this->{loglevel};
    if (defined $l && $l !~ /^\d+$/) {
	$this->{loglevel} = Masterkey::Admin::LogLevel::num($l);
    }
    return $this;
}

sub conf {
    my $this = shift();
    my($key, $default) = @_;
    my $val = $this->{$key};
    if (defined $val) {
	#warn "conf($key) -> '$val'";
    } elsif (defined $default) {
	$val = $default;
	#warn "conf($key) undefined, default to '$val'";
    } else {
	#warn "conf($key) undefined";
    }

    return $val;
}

# A simple alias for these purposes
sub option { shift()->conf(@_) }

### Should really delegate to a separate Log package
sub log {
    my $this = shift();
    my($level, @args) = @_;

    if ($this->option("loglevel") & $level) {
	my $label = Masterkey::Admin::LogLevel::label($level);
	print STDERR $this->option("logprefix"), " ($label): ", @args, "\n";
    }
}

sub dump {
    my $this = shift();
    use Data::Dumper;
    local $Data::Dumper::Indent = 1;
    return Dumper(@_);
}


1;
