package Masterkey::Admin::Test::USI;
use Masterkey::Admin::Test;
our @ISA = qw(Masterkey::Admin::Test);

# Objects for testing target functionality: USI version

use strict;
use warnings;

use HTML::Entities;
use ZOOM;


sub new {
    my $class = shift();
    my($admin, $usiParam, $record) = @_;

    my $useUSI = $usiParam || $admin->conf("usiBaseUrl");
    die "Huh?" if !$useUSI;

    my $this = bless {
	admin => $admin,	# A Masterkey::Admin object
	usiParam => $usiParam,	# Whatever was supplied in the URL
	record => $record,	# Description of target to test
    }, $class;

    return $this;
}


sub useUSI { 1 }
sub caption { "USI" }


sub zurlAndAuth {
    my $this = shift();
    my($out, $adminUser) = @_;

    my $admin = $this->admin();
    my $record = $this->record();
    my $usiLoginFromTab = $admin->conf("usiLoginFromTab");

    my ($zurl, %auth);

    my $realm = $adminUser->field("identityId");
    my $usiParam = $this->usiParam();
    my $usiBaseUrl = (defined $usiParam && $usiParam =~ /^http:/) ?
	$usiParam : $admin->conf("usiBaseUrl");
    $out->item("Using usiBaseUrl '$usiBaseUrl'");
    $zurl = $usiBaseUrl . "/" . $record->field("udb");
    $usiLoginFromTab = $admin->conf("usiLoginFromTab");
    $zurl .= ",realm=$realm" if !$usiLoginFromTab;

    if ($usiLoginFromTab) {
	my $admin2 = new Masterkey::Admin($usiLoginFromTab);
	my $torusRealm = $admin2->conf("torusRealm");
	my $torus2 = $admin2->torus();
	my $rs = $torus2->records($torusRealm, undef, $adminUser);
	die "no identity record to test this target with" if $rs->count() == 0;
	warn "multiple identity records; using first" if $rs->count() > 1;
	my $record2 = $rs->record(0);
	$auth{user} = $record2->field("userName");
	$auth{password} = $record2->field("password");
    }

    return ($zurl, %auth)
}


sub sruSetting {
    my $this = shift();

    return "get";
}


sub backendAuth {
    my $this = shift();
    my($out, $zurl) = @_;

    # The USI does back-end authentication for us.
    return $zurl;
}


sub _append_zurl {
    my($out, $zurl, $key, $value) = @_;

    if (!defined $value) {
	$out->item("(No ZURL component for $key)");
    } else {
	if ($zurl !~ /,/) {
	    # First component
	    $zurl .= ",";
	} else {
	    # Already got one or more components
	    $zurl .= "&";
	}
	$zurl .= "$key=$value";
	$out->item("Added rich-DB component $key=" . encode_entities($value));
    }
    return $zurl;
}


#   ###	This is a hacky way to do things.  The following table is more
#	or less the inverse of the list of <fieldmap> directives in
#	the ZOOM-filter definition of
#	ebsco-usi/config/metaproxy/metaproxy-filter-usi.xml
#
our %ccl2cql_index = (
    # No need to handle "term"
    au => "dc.creator",
    ti => "dc.title",
    su => "dc.subject",
    isbn => "bath.isbn",
    issn => "bath.issn",
    date => "dc.date",
    type => "dc.format",
    jt => "dc.source",
    src => "dc.source",
    publisher => "dc.publisher",
    peerreviewed => "id.peerReviewed",
    fulltext => "id.fullText",
    description => "dc.description",
    language => "dc.language",
    localID => "rec.identifier",
);


# Translate the MasterKey name of an index (e.g. "au") to the form
# that is required in queries (e.g. "cql.creator" for USI targets or
# "au" for CCL translation)
#
sub queryIndex {
    my $this = shift();
    my($index) = @_;

    return $ccl2cql_index{$index}
}


sub makeQuery {
    my $this = shift();
    my($qstr, $conn) = @_;

    # We could use CCL2RPN, but don't need to
    return new ZOOM::Query::CQL($qstr, $conn);
}


1;
