<%args>
$param => "homeHtml"
</%args>

<%perl>
$m->comp("/mc/setup.mc");
my $user = $m->comp("/mc/utils/user.mc");
if (!defined $user) {
   print qq[How did you get here when you're not <a href="/console/">logged on</a>?\n];
   return;
}

my $admin = $m->notes("admin");
my $html = $admin->conf($param);
my $debug = $admin->conf("serviceProxyStatisticDebug") || 0;

my $report_order = "searches clicks_through full_record_view search_failures search_zerohits sessions counter_report";
$report_order = $admin->conf("serviceProxyStatisticReportOrder") if defined $admin->conf("serviceProxyStatisticReportOrder");

my ($r, @column9) = $m->comp("/mc/reports.mc", 'report_order' => [ split /\s+/, $report_order ] );

</%perl>

<h2>All Statistics Reports</h2>

<p>View single reports <a href="statistic.html">on a page</a></p>

<%perl>
  print qq{<table>\n};
  my $counter = 0;
  my $space = "&nbsp;&nbsp;&nbsp;";

  # print list of reports
  foreach my $tr (@column9) {
    my ($key, $value, $todo) = @$tr;
    next if $key ne '_line' && $todo && !$debug;

    # do not display counter reports
    next if $key =~ /^counter_db/ || ($key eq '_line' && $value =~ /^counter/i);

    print qq[<tr>]; 

    if ($key eq '_line') {
        print qq{<td></td></tr><tr>\n};
        print qq{<td><b>$value</b></td>\n};
    } else {
       $counter++;
  	print qq[<td>$space $counter. $value</td>\n];
    }
    print qq[</tr>\n];
  }
  print qq{</table><p/>\n};

  # call reports via an iframe
  $counter = 0;
  my $last;
  foreach my $tr (@column9) {
    my ($key, $value) = @$tr;
  
    # do not display counter reports
    next if $key =~ /^counter_db/;

    if ($key eq '_line') {
        print qq{<td><hr/></td>\n};
	$last = $value;
    } else {
       $counter++;
       print qq{<p/><span name="$counter">$counter.&nbsp;$last $value</span><br/>\n};
       print qq{<iframe width="100%" height="320" style="min-height:300px;" frameborder="2" \nsrc="sp-statistic.cgi?statistic=$key;dateRange.dateRangeType=simple;dateRange.simpleDate=none;dateRange.customDate.start.day=1;dateRange.customDate.start.month=8;dateRange.customDate.start.year=2011;dateRange.customDate.end.day=24;dateRange.customDate.end.month=8;dateRange.customDate.end.year=2011;output_format=html;submit=Generate+Statistics"></iframe>\n};
   }
  }
</%perl>

