package Masterkey::Admin::Utils;

use strict;
use warnings;
use Apache2::Request;
use Encode;
use Carp;

use Exporter 'import';
our @EXPORT_OK = qw(utf8param);

# Debugging wrapper: rename to utf8param() if needed
sub utf8param_wrapper {
    my($r, $key, $value) = @_;
    if (!defined $key) {
	my @res = _utf8param(@_);
	warn("utf8param(", join(", ", @_), ") ", @res ? ("-> '" . @res . "'") : "undefined");
	return @res;
    } else {
	my $res = _utf8param(@_);
	warn("utf8param(", join(", ", @_), ") ", $res ? ("-> '" . $res . "'") : "undefined");
	return $res;
    }
}

# Under Apache 2/mod_perl 2, the ubiquitous $r is no longer an
# Apache::Request object, nor even an Apache2::Request, but an
# Apache2::RequestReq ... which, astonishingly, doesn't have the
# param() method.  You make an Apache2::Request out of it, but even
# then you can't use it to SET parameter values, and it sometimes
# fails mysteriously, as in bug MKII-1475. For all these reasons,
# we're dumping it, and reverting to the boring old CGI module.

sub utf8param {
    my($q, $key, $value) = @_;

    confess("utf8param(): \$q undefined") if !defined $q;
    confess("utf8param(): \$q $q is not a CGI object") if ref $q ne "CGI";

    if (!defined $key) {
	# Request for all parameters in one go
	return map { decode_utf8($_) } $q->param();
    }

    my $raw = $q->param($key, $value);
    #warn("_utf8param[scalar]('$key') -> ", defined $raw ? "'$raw'" : "undef");

    return undef if !defined $raw;
    my $cooked = decode_utf8($raw);
    #warn "converted '$raw' to '", $cooked, "'\n" if $cooked ne $raw;
    return $cooked;
}


1;
