<%args>
$merged => 0
</%args>
<%once>
use File::stat;
use Time::Seconds;
use Time::Piece;
use Text::CSV;
use HTTP::Date;
use Data::Dumper;
use CGI;

use Masterkey::Admin::Utils qw(utf8param);
</%once>
<%perl>

$m->comp("/mc/setup.mc");
my $admin = $m->notes("admin");
my $user = $m->comp("/mc/utils/user.mc");

my @date = (
    ["today", "Today"],
    ["yesterday", "Yesterday"],
    ["7days", "7 days"],
    ["month", "Month"],
    ["last_month", "Last Month"],
    ["last_quarter", "Last Quarter"],
    ["last_last_quarter", "Last Last Quarter"],
    ["quarter", "Quarter"],
    ["anniversary_quarter", "Anniversary Quarter"],
    ["all_time", "All Time"],
);
my %date = map { $_->[0] => $_->[1] } @date;

my $debug = $admin->configValue("BillingDebug") || 0;
my $billing_enabled = $admin->configValue("BillingEnabled") || 0;
my $customer = $admin->configValue("BillingCustomer") || "";
my $history_enabled = $admin->configValue("BillingHistoryEnabled") || 1;
my $history_directory = $admin->configValue("BillingHistoryDirectory") || "/var/tmp";
my @supported_formats = split( /\s+/, $admin->configValue("BillingSupportedFormats") || "html csv");
my $billing_token = $admin->configValue("BillingToken") || "";
my $billing_excluded_libraries = $admin->configValue("BillingExcludedLibraries") || "";
my $select_all = $admin->configValue("BillingSelectAll") || "0";

my $fulltable = defined $admin->configValue("BillingOutputFulltable") ? $admin->configValue("BillingOutputFulltable") : 0;
my $databases_per_row = defined $admin->configValue("BillingOutputDatabasesPerRow") ? $admin->configValue("BillingOutputDatabasesPerRow") : 1;
my $databases_per_row_column = 1;
my $library_only = $admin->configValue("BillingLibraryOnly") if defined $admin->configValue("BillingLibraryOnly");

# supported only, not all
my $target_supported = defined $admin->configValue("BillingOutputTargetSupported") ? $admin->configValue("BillingOutputTargetSupported") : 1;

my $unique = 0; 	# unique CSV row output
my $unique_month = 0; 	# unique month CSV row output (last value only of a month)
$debug = 1;

warn "Billing customer: $customer\n" if $debug;
my $q = CGI->new($r);
my $token_param = utf8param($q, "token") || "";
my $user_param = utf8param($q, "user") || "";
my $creation = utf8param($q, "creation") || "";
our $counter_prefix = utf8param($q, "counter_prefix") || 0;
$creation = "" if $creation ne 'yes';

$history_enabled = 0;

if (utf8param($q, "excluded")) {
    $billing_excluded_libraries = utf8param($q, "excluded") || "";
}
if ($billing_excluded_libraries) {
   eval { "." =~ /$billing_excluded_libraries/i };
   if ($@) {
	warn "Ignore broken billing regex '$billing_excluded_libraries'\n";
	$billing_excluded_libraries = "";
   }
}

my $filter_date = utf8param($q, "filter_date");
my $filter_type = utf8param($q, "dateRange.dateRangeType");

my $date_start;
my $date_end;
my $billing_confirmed = utf8param($q, "billing_confirmed") || "";

if ($billing_confirmed eq 'billing') {
   warn "Billing date set. here are dragons!\n";
}

if ($filter_type eq 'simple') {
  $filter_date = utf8param($q, "dateRange.simpleDate");
  if  (!grep { $_ eq $filter_date } qw/today yesterday 7days month last_month all_time quarter last_last_quarter last_quarter anniversary_quarter none/) {
     warn "Unknown filter date: '$filter_date'\n";
     $filter_date = "none"
  }
} else {

  # date with leading zero: "7" => "07"
  sub zero_date { my $d = shift; $d < 10 ? "0".$d  : $d };

  $date_start =
              utf8param($q, "dateRange.customDate.start.year") .
        "-" . zero_date(utf8param($q, "dateRange.customDate.start.month")) .
        "-" . zero_date(utf8param($q, "dateRange.customDate.start.day"));

  $date_end =
              utf8param($q, "dateRange.customDate.end.year") .
        "-" . zero_date(utf8param($q, "dateRange.customDate.end.month")) .
        "-" . zero_date(utf8param($q, "dateRange.customDate.end.day"));
  $filter_date = $date_start . '..' . $date_end;
}


my $identityId;
if ($user) {
    $identityId = $user->field("identityId");
}

if ($user_param) {
   $user = $user_param;
   $identityId = $user;
   $library_only = 1;
}
if ($token_param && $token_param eq $billing_token) {
    if (!$user_param) {
       $user =  "billing";
       $identityId = $user;
    }
}
warn "Run as user '$identityId'\n" if $debug >= 1;

if (!defined $user || !$billing_enabled) {
   print $q->content_type("text/html");
   print "<html>\n<body>\n";

   if (!defined $user) {
       print "<p>How did you get here when you're not logged on?\n</p>";
       print qq{<p>Please <a href="../">login</a> first! </p>\n};
   } else {
       print qq{<p>Sorry, the billing statistic is not enabled for this site. Please contact your MK2 administrator!</p>};
   }

   print "<hr/></body></html>\n";
   return;
}


my $output_format = utf8param($q, "output_format") || "csv";
my $details = defined utf8param($q, "details") ? utf8param($q, "details") : "yes";

my $format = $output_format;
if  (!grep { $_ eq $format } @supported_formats) {
   warn "Unknown format: '$format'\n";
   $format = "csv";
}

my $http_format = $format;

# set the CSV filename to save output locally
my $disposition = qq{inline; filename=billing-$customer} . ($creation ? "-creation" : "") . qq{.$http_format};

$r->content_type("text/$http_format");
$r->err_headers_out->add('Content-disposition' => $disposition) if $output_format eq 'csv';

my $t = localtime;
my $month = $t->mon . "/" . $t->year;

use Masterkey::Admin::Report;
my $report = new Masterkey::Admin::Report();

my @table_header = ("Library/month", "Z39.50 unsupported", "Z39.50 supported", "CF targets unsupported", "CF targets supported",
	            "Total Targets", "CF Connector unsupported", "CF Connector supported", "Total Connectors", "Total Supported", "Target Names");
@table_header = ("Library/month", "Total Targets", "Total Connectors", "Total Supported", "Target Names (supported)") if !$fulltable;

push (@table_header, ("UDB (supported)", "Date")) if $databases_per_row_column;
my @table = [@table_header];

my $rs = $report->itorus()->records("admin", undef, undef, 1);
my $identities = $rs->records();
### Should we uniquify on realm?
my @identities = sort { $a->displayName() cmp $b->displayName() } @$identities;

my %total;
my %total_cf;
my %total_unique;

# SLA
my @types = qw/z3950_unsupported z3950_supported cf_target_unsupported cf_target_supported/;
my @types2 = @types;
@types = () if !$fulltable;

# CF connectors, not targets
# Note: A CF Connector can support multiple targets.
my @types_cf = qw/cf_connector_unsupported cf_connector_supported/;
my @types_cf2 = @types_cf;
@types_cf = () if !$fulltable;

my @types_supported = qw/cf_connector_supported z3950_supported/;

# return unique sorted list
sub unique {
    my @list = @_;

    # %hash = map { $_ => 1 } @list;
    my %hash;
    for(my $i = 0; $i <= $#list; $i++) {
	my $data = $list[$i];

	if (exists $hash{ $data }) {
	    #warn "Duplicate: $data\n" if $debug >= 2;
	}
	$hash{ $data } = 1;
    }

    return sort keys %hash;
}

sub get_target_name {
    my ($name, $counter, $databases_per_row_column) = @_;

    if (!$databases_per_row_column) {
	return $counter_prefix ? "$counter. $name" : $name;
    } else {
	my @list = split "\t", $name;
	$list[0] = "$counter. " . $list[0] if $counter_prefix;
	return @list;
    }
}

my %hash_total;

sub month {
    my $time = shift || localtime;

    my $t = localtime($time);
    my $month = $t->mon . "/" . $t->year;

    return $month;
}

sub quarter {
    my $time = shift || localtime;

    my $t = localtime($time);
    my $month = $t->mon <=3 ? "first quarter" :
		$t->mon <= 6 ? "second quarter" :
		$t->mon <= 9 ? "third quarter" :
	        "forth quarter";

    return $month;
}

sub last_quarter_number {
    my $t = shift;
    return quarter_number($t - ONE_MONTH * 3);
}

sub quarter_number {
    my $t = shift;

    my $quarter = int (($t->mon - 1)/ 3) + 1;

    return $quarter;
}

sub filter_date {
    my $date = shift;

    my $t_start = localtime(0);
    my $t_end  = localtime();
    my $t;
    my $m;

    $t = localtime;
    if ($date eq 'today') {
	$t_start = Time::Piece->strptime($t->ymd, "%Y-%m-%d");
	$t_end = localtime();
    } elsif ($date eq 'yesterday') {
	$t -= ONE_DAY;
	$t_start = Time::Piece->strptime($t->ymd, "%Y-%m-%d");
	$t = localtime;
	$t_end = Time::Piece->strptime($t->ymd, "%Y-%m-%d");
    } elsif ($date eq '7days') {
	$t -= ONE_DAY * 7;
	$t_start = Time::Piece->strptime($t->ymd, "%Y-%m-%d");
	$t_end = localtime;
    } elsif ($date eq 'month') {
	my $m = $t->ymd;
	$m =~ s/-\d+$//;
	$t_start = Time::Piece->strptime($m, "%Y-%m");
	$t_end = localtime;
    } elsif ($date eq 'last_month') {
	$t -= ONE_MONTH;
	$m = $t->ymd;
	$m =~ s/-\d+$//;
	$t_start = Time::Piece->strptime($m, "%Y-%m");

	$t = localtime;
	$m = $t->ymd;
	$m =~ s/-\d+$//;
	$t_end = Time::Piece->strptime($m, "%Y-%m");
    } elsif ($date eq 'quarter') {
	my $q = $t->mon % 3;
	$q = $q == 0 ? 2 : $q - 1;
	$t -= ONE_MONTH * $q;
	$m = $t->ymd;
	$m =~ s/\-\d+$//;
	$t_start = Time::Piece->strptime($m, "%Y-%m");
	$t_end = localtime;
    } elsif ($date eq 'last_quarter') {
	$t -= ONE_MONTH * 3;
	my $q = $t->mon % 3;
	$q = $q == 0 ? 2 : $q - 1;
	$t -= ONE_MONTH * $q;
	$m = $t->ymd;
	$m =~ s/-\d+$//;
	$t_start = Time::Piece->strptime($m, "%Y-%m");

        $t = localtime();
	$q = $t->mon % 3;
	$q = $q == 0 ? 2 : $q - 1;
	$t -= ONE_MONTH * $q;
	$m = $t->ymd;
	$m =~ s/\-\d+$//;
	$t_end = Time::Piece->strptime($m, "%Y-%m");
    } elsif ($date eq 'last_last_quarter') { # keep in sync with last_quarter!
	$t -= ONE_MONTH * 6;
	my $q = $t->mon % 3;
	$q = $q == 0 ? 2 : $q - 1;
	$t -= ONE_MONTH * $q;
	$m = $t->ymd;
	$m =~ s/-\d+$//;
	$t_start = Time::Piece->strptime($m, "%Y-%m");

        $t = localtime();
	$q = $t->mon % 3;
	$q = $q == 0 ? 2 : $q - 1;
	$t -= ONE_MONTH * $q + ONE_MONTH * 3;
	$m = $t->ymd;
	$m =~ s/\-\d+$//;
	$t_end = Time::Piece->strptime($m, "%Y-%m");
    } elsif ($date eq 'all_time') {
	$t_start = localtime(0);
	$t_end = localtime();
    } elsif ($date eq 'anniversary_quarter') {
	# older than one year, in a quarter
        $t = localtime() - ONE_YEAR;
	my $q = $t->mon % 3;
	$q = $q == 0 ? 2 : $q - 1;
	$t -= ONE_MONTH * $q;
	$m = $t->ymd;
	$m =~ s/\-\d+$//;
	$t_end = Time::Piece->strptime($m, "%Y-%m");
    } elsif ($date eq 'all_time') {
	$t_start = localtime(0);
    }

    warn "BBB date: $date, m: $m, diff: $t_start - $t_end\n";
    return ($t_start, $t_end);
}

#
# for each library, count the targets,
# calculate the type of target (supported, unsupported), and filter connector names,
# and filter unique targets (consortia)
#
my $counter = 0;

my $t_start;
my $t_end;
if ($filter_type eq 'simple') {
    ($t_start, $t_end) = &filter_date($filter_date);
    warn "filter_date: $filter_date $date_start $date_end\n";
} else {

    if ($date_start) {
	$t_start = Time::Piece->strptime($date_start, "%Y-%m-%d");
    }
    if ($date_end){
	$t_end = Time::Piece->strptime($date_end, "%Y-%m-%d");
    }
}

my $t_end_billing = $t_end - 1;
if ($billing_confirmed) {
    warn "Use billing time: ", $t_end_billing->strftime(), "\n";
}

warn "filter_date: $filter_date, date_start: $date_start, t_start: $t_start, date_end: $date_end, t_end: $t_end\n" if $debug;

my $this_month = $t_start->ymd . ' .. ' . $t_end->ymd;

my $this_month_iso = "$t_start .. $t_end";
$this_month_iso .= " ($date{$filter_date})" if $filter_type eq 'simple' && $filter_date;
if ($filter_type eq 'simple' && $filter_date eq 'anniversary_quarter') {
    my $t = localtime;
    $this_month_iso .= " " . last_quarter_number($t) . "th quarter";
    $this_month .= " " . last_quarter_number($t) . "th quarter";
}
$month = $this_month;
$month .=  " ". $date{$filter_date};

foreach my $identity (@identities) {
    my $name = $identity->displayName();
    my $realm = $identity->field("identityId");
    warn "realm: $realm, name: $name\n" if $debug;

    my @row;

    if (!defined $realm || $realm eq "") {
        warn "ignoring identity '$name' with no realm";
        next;
    }
    if ($billing_excluded_libraries && $name =~ /$billing_excluded_libraries/i) {
	warn "Ignore test libarary '$name'\n" if $debug >= 1;
	next;
    }

    # library level only, /console/lreports/
    if ($library_only && $identityId ne $realm) {
	warn "Ignore library identity: $identityId <=> $realm\n" if $debug >= 1;
	next;
    }

    push @row, "$name ($month)";

    my $rs = $select_all ? $report->storus()->world($realm) : $report->storus()->records($realm);
    my $list = $rs->records();
    my @list = sort { lc($a->displayName()) cmp lc($b->displayName()) } @$list;

    my %hash;
    my %hash_cf;

    warn "name: $name\n" if $debug >= 2;
    my $billingDate;
    my $today_t = localtime;

    my @list2;
    foreach my $searchable (@list) {

	my $date;
	my $udb = $searchable->field("udb");
	my $disabled = $searchable->field("disabled");
	my $display_name = $searchable->displayName();

	if (defined $disabled && $disabled eq 'yes') {
	    warn "Ignored disabled $display_name, udb: $udb\n" if $debug >= 1;
	    next;
        }


	# count only new created targets
	$billingDate = $searchable->field("billingDate");
	my $flag = 0;
	if ($billingDate) {
	    warn "xxx: got billing date: $billingDate\n" if $debug >= 2;
	} else {
	    $billingDate = $searchable->field("creationDate");
	    $flag++;
	}

	if (!$billingDate) {
	    warn "xxx: $display_name\n" if $debug >= 2;
	    # toroid? Fall back to lastModified
	    $billingDate = $searchable->field("lastModified");
	    $flag++;
	} else {
	    warn "yyy $billingDate $display_name\n" if $debug >= 2;
	}

	next if !$billingDate;

	if ($billing_confirmed eq 'billing') {
	    warn "set billing date for: $display_name\n";
	    my %data = ('billingDate' => $t_end_billing->strftime());
	    #$admin->modify_record($identity, $searchable->field("id"), undef, {}, %data);
	}

	my $time = str2time($billingDate);



	my $create_t = localtime($time);
	$udb .= $udb ? " " : "no_udb ";
	#$udb .= " quarter: " . last_quarter_number ($create_t) . " ";

	# inside date range
	if ($create_t >= $t_start && ($create_t < $t_end)) {
	    # older than a year, same (last) quarter
	    if ($filter_date eq 'anniversary_quarter') {
		next if quarter_number($create_t) != last_quarter_number($today_t);
	    }

	    warn "zzz $time $this_month $create_t\n" if $debug >= 2;
	    #$date = $create_t->mdy("/"); # US date format
	    $date = $create_t->ymd;
	}

	# out of date range
	else {
	    next;
	}

	push @list2, $searchable;

	my $zurl = $searchable->field("zurl");
	my $supported = $searchable->field("supported") || 0;

	warn "supported: $supported: $zurl\n" if $debug >= 3;
	my $target_name = $searchable->displayName() || "";

	#
        # targets based on connectors
        # matching is done by hostnames (connect.indexdata.com) or
        # port 9000 (metaproxy) or 9003 (cf-zserver)
	#
        if ($zurl =~ m,(\.[a-z]+|localhost|127\.0\.0\.1):900[03]/, || $zurl =~ /connect.*.indexdata.com/ ) {
	    $supported ? $hash{cf_target_supported}++ : $hash{cf_target_unsupported}++;
	    $supported ? $hash_total{cf_target_supported}{$zurl}++ : $hash_total{cf_target_unsupported}{$zurl}++;

	    # count by connector and ignore subdatabases
            my $z = $zurl;
	    $z =~ s/\?.*//;

	    $supported ? $hash{cf_connector_supported}++ : $hash{cf_connector_unsupported}++;
	    $supported ? $hash_total{cf_connector_supported}{$z}++ : $hash_total{cf_connector_unsupported}{$z}++;

	    $hash_total{_total_cf}{$z}++;
        }

	# z39.50 targets
        else {
	    $supported ? $hash{z3950_supported}++ : $hash{z3950_unsupported}++;
	    $supported ? $hash_total{z3950_supported}{$zurl}++ : $hash_total{z3950_unsupported}{$zurl}++;
        }

	$hash_total{_total}{$zurl}++;
	$hash_total{_total_supported}{$zurl}++ if $supported;
	my $target_name2 = "$target_name ($udb$date)";
	if ($databases_per_row_column) {
	    $target_name2 = join "\t", $target_name, $udb, $date;
	}
	push @{$hash{_target}}, "$target_name2" if $target_name ne "";
	push @{$hash{_target_supported}}, "$target_name2" if $supported;
    }

    # customer: targets columns
    foreach my $type (@types2) {
	push @row, ($hash{$type} || 0) if @types;

        $total{$type} += $hash{$type};
    }

    # customer: targets total
    push @row, scalar(@list2);
    $total{_total} += scalar(@list2);


    # customer: connector columns
    my $total_x = 0;
    foreach my $type (@types_cf2) {
	push @row, ($hash{$type} || 0) if @types_cf;
        $total{$type} += $hash{$type};
	$total_x += $hash{$type};
    }

    # customer: total connectors column
    push @row, $total_x;
    $total{_total_cf} += $total_x;

    # customer: connector columns
    my $total_s = 0;
    foreach my $type (@types_supported) {
	$total_s += $hash{$type};
    }

    # customer: total supported column
    push @row, $total_s;
    $total{_total_supported} += $total_s;


    my @databases;
    my $column_counter = scalar(@row);

    sub column_padding {
	my $column_counter = shift;
	my @data;

	# empty columns except the last one
	foreach (1 .. $column_counter) {
	    push @data, "";
	}

	return @data;
    }

    my $type = $target_supported ? "_target_supported" : "_target";
    if (exists $hash{$type}) {
	push @table, [ @row ];
	@row = &column_padding($column_counter);

    	@databases = @{$hash{$type}};
	if ($databases_per_row) {
	    # put the first lib in the last column
	    push @row, get_target_name(shift(@databases), 1, $databases_per_row_column);
	} else {
	    # put all libs in the last columns
	    push @row, join ("; ", @{$hash{$type}});
	}
    } else {
	push @row, "";
    }

    push @table, \@row;

    # put the row on the list
    if ($databases_per_row) {
	my $counter = 1;
	foreach my $db (@databases) {
	    my @data;
	    $counter++;
	    push @data, &column_padding($column_counter);
	    push @data, get_target_name($db, $counter, $databases_per_row_column);

	    push @table, \@data;
	}
    }

    push @{$total{_target}}, @{$hash{_target} } if exists $hash{_target};

    #my @last;
    #foreach my $type (@types, "_total", @types_cf, "_total_cf", "_total_supported" ) {
    #   push @last, scalar (keys %{$hash_total{$type}});
    #}
    #warn join (" ", @last), "\n";
    #if ($counter >= 14) {
    #	if ($counter == 14) {
    #		warn "YYY $name: ", join ("\n", map { $_->field("zurl") } @list), "\n";
    # }
    #	last;
    #}
    $counter++;
}

# if a target is supported *and* unsupported, count only the supported one in total list
foreach my $key (keys %{$hash_total{z3950_unsupported}}) {
    if (exists $hash_total{z3950_supported}{$key}) {
	delete $hash_total{z3950_unsupported}{$key};
    }
}
foreach my $key (keys %{$hash_total{cf_target_unsupported}}) {
    if (exists $hash_total{cf_target_supported}{$key}) {
	delete $hash_total{cf_target_unsupported}{$key};
    }
}
foreach my $key (keys %{$hash_total{cf_connector_unsupported}}) {
    if (exists $hash_total{cf_connector_supported}{$key}) {
	delete $hash_total{cf_connector_unsupported}{$key};
    }
}



if ($details ne 'yes') {
   # keep only header line
   @table = shift @table;

   my $file = $history_enabled ? get_csv_filename('dir' => $history_directory, 'creation' => $creation  ) : "";
   if (-f $file ) {
	warn "open history file $file\n" if $debug;
	my $fh = IO::File->new($file, "r") or die "open $file: $!\n";
	binmode $fh, ":utf8";

        my $csv = get_csv_obj();
	# skip header line
	$csv->getline($fh);

  	while(my $row = $csv->getline($fh)) {
	    if ($unique_month) {
		# ignore entries from the same month
		next if $row->[0] eq $month;
	    }
	    push @table, $row;
	}
    }
}

# Total: second last line
my @last;

if ($details eq 'yes') {
    push @last, "Total $month";
    foreach my $type (@types, "_total", @types_cf, "_total_cf", "_total_supported") {
    	push @last, $total{$type};
    }

    push @last, "";
    push @table, [@last];
}

if ($unique) {
    # Total/unique: last line
    @last = $details eq 'yes' ? "Total/unique $month" : $month;
    foreach my $type (@types, "_total", @types_cf, "_total_cf", "_total_supported") {
	push @last, scalar (keys %{$hash_total{$type}});
    }

    push @last, join ("; ", unique (@{$total{_target}}));

    push @table, [@last];
}


#my $xxx = 0;
#foreach my $type (@types) {
#   $xxx += scalar (keys %{$hash_total{$type}});
#}
#warn "xxx: $xxx\n";

sub get_csv_obj {
    my $csv = Text::CSV->new(
        {
            quote_char          => '"',
            escape_char         => '"',
            sep_char            => ',',
            eol                 => '',
            binary              => 1,
            allow_loose_quotes  => 1,
            allow_loose_escapes => 1,
            allow_whitespace    => 1,
            blank_is_undef      => 1,
        }
    );

    return $csv;
}

sub get_csv_filename {
    my %args = @_;

    my $dir = $args{'dir'};
    my $creation = $args{'creation'};

    if (! -e $dir) {
	my @args = ("mkdir", "-p", $dir);
	system(@args) == 0
	  or die "system @args failed: $?\n";
    }

    my $file = "$dir/billing" . ($creation ? "-creation" : "") . ".csv";

    return $file;
}

if ($format eq 'csv') {

    my $csv = get_csv_obj();
    my $row = 0;
    my $file = $history_enabled && $details ne 'yes' ? get_csv_filename('dir' => $history_directory, 'creation' => $creation ) : "";
    my $file_tmp = $file ? "$file.tmp" : "";
    my $fh;

    if ($file_tmp) {
	warn "open $file_tmp\n" if $debug;
	$fh = IO::File->new($file_tmp, "w") or die "open $file_tmp: $!\n";
	binmode $fh, ":utf8";
    }

    my %hash;
    foreach my $line (@table) {
	my $status = $csv->combine(@$line);
	die "CSV error: " . $csv->error_diag . "\n" if !$status;

   	if ($unique) {
   	    my $key = join ":", @$line;
	    next if $hash{$key}++;
   	}
	print $csv->string(), "\n";

	if ($fh) {
	    print $fh $csv->string(), "\n";
	}
    }

    if ($file_tmp) {
    	close $fh;
    	warn "rename $file_tmp to $file\n" if $debug;
    	rename ($file_tmp, $file) or die "rename: $file_tmp -> $file: $!\n";
    }

    return;
}
</%perl>
<!-- HTML -->
<html>
<head>
  <meta http-equiv="Content-Type" content= "text/html; charset=utf-8" />
  <title>Billing</title>
<style>
table { }
td.total { color: #008000 }
tr.total { color: #008000 }
</style>

<style type="text/css" title="currentStyle">
    @import "css/jquery/DataTables/css/demo_page.css";
    @import "css/jquery/DataTables/css/header.ccss";
    @import "css/jquery/DataTables/css/demo_table_jui.css";
    @import "css/jquery/jquery-ui-1.8.4.custom.css";
</style>

<script type="text/javascript" language="javascript" src="js/jquery/jquery-1.8.2.min.js"></script>
<script type="text/javascript" language="javascript" src="js/jquery/jquery.dataTables.min-1.9.4.js"></script>
<script type="text/javascript" language="javascript" src="js/jquery/colResizable-1.3.min.js"></script>
<script type="text/javascript" language="javascript">
$(document).ready(function() {
    oTable = $('table.datatable').dataTable({
		"bJQueryUI": true,
		"iDisplayLength": 100,
	        "bSort": true,
		"aaSorting": [],
		// "oSearch": {"sSearch": stat_query() },
		"sPaginationType": "full_numbers"
    });
});

$(document).ready(function() { $('table').colResizable({ liveDrag: true }); });
</script>
</head>
<body>

<div id="container">
<div id="dt_example">

<h2><a href="./">Connector &amp; Target report</a></h2>

<span style="color:red">
This page is for testing and development only. Please use the <a href="#csv">CSV</a> link at the bottom for billing.
</span>

<p>
Number of <b>supported</b> targets by library. Date range: <% $this_month_iso %><br/>
Connectors with sub-databases are counted by sub-database.
A CF Connector can support multiple targets.
</p>

<!--
<h5>Services Level Agreements (SLA)</h5>

<p>
unsupported target: provided as it is<br/>
supported target: we take care of a target if it is broken, analyze and report back to
the customer in N business days.<br/>
</p>
-->

<table border="1" class="datatable">
<thead>
<%perl>
my %hash;
my $thead_counter = 0;
my $rows = $#{$table[0]};
foreach my $row (@table) {
   my $class = $$row[0] =~ /total/i ? qq{class='total'} : "";

   if ($unique) {
   	my $key = join ":", @$row;
	next if $hash{$key}++;
   }

   my @list = @$row;
   for(my $i = $#list; $i < $rows; $i++) {
	push @list, "";
   }

   print "<tr $class>";
   foreach my $td (@list) {
	print qq{<td>$td</td>}
   }
   print "</tr>\n";

   # after first line close thead
   print "</thead>\n" if $thead_counter++ == 0;
}

</%perl>
</table>

<p>

<%perl>
my $qq = new CGI;
$qq->param("output_format", "csv");
my $url = $qq->url(-query=>1, -relative=>1);
</%perl>

<a name="csv" href="<% $url %>">CSV output</a>

% if ($billing_confirmed) {
<p/>Billing time was set to: <% $t_end_billing->strftime() %>
% }

</p>
<hr/>
<a href="http://indexdata.com">Index Data ApS</a>

</div>
</div>


</body>
</html>
