<%args>
$query => undef
$showURL => 0
$setAuto => undef
</%args>
   <h2>Manage parents</h2>
<%perl>
my @offon = qw(off on);
my @parents;
my $autoInherit;
my $worldURI;
my $admin = $m->notes("admin");

eval {
    my $torus = $admin->torus();
    my $user = $m->comp("/mc/utils/user.mc", require => 1) or return;
    die "you are not authorised to manage parents" if !$user->field("superuser");
    my $realm = $user->field("identityId");

    if (defined $setAuto) {
	print "<p>Turning autoInherit ", $offon[$setAuto], "</p>\n";
	my $torusProperties = $torus->properties($realm);
	$torusProperties->setAutoInherit($setAuto ? "yes" : undef);
	$torusProperties->update();
    }

    $worldURI = $torus->worldURI($realm);
    $worldURI =~ s/\?.*/?recursive=1/;
    @parents = sort { $a->name() cmp $b->name()
	} $torus->parents($realm, $query);
    my $torusProperties = $torus->properties($realm);
    $autoInherit = $torusProperties->autoInherit();
    warn "realm=$realm, autoInherit='$autoInherit'";
}; if ($@) {
    print $admin->exception2error($@);
    return;
}

</%perl>
   <table class="list">
    <tr>
     <th>Name</th>
     <th>Priority</th>
     <th>Refresh</th>
% if ($showURL) {
     <th>URL</th>
% }
     <th>Edit</th>
     <th>Delete</th>
    </tr>
% foreach my $i (0 .. @parents-1) {
%     my $parent = $parents[$i];
    <tr>
     <td><% encode_entities($parent->name()) %></td>
     <td><% encode_entities($parent->priority()) %></td>
     <td><% encode_entities($parent->refreshAfter()) %></td>
% if ($showURL) {
     <td><% encode_entities($parent->url()) %></td>
% }
     <td>
% my $etext = "Edit this parent";
      <a href="editParent.html?id=<% encode_entities($parent->id())
	%>" title="<% $etext %>"><& /mc/link/icon.mc, context => "list", icon => "edit", text => $etext &></a>
     </td>
     <td>
% my $dtext = "Delete this parent";
      <a href="deleteParent.html?id=<% encode_entities($parent->id())
	%>" title="<% $dtext %>"><& /mc/link/icon.mc, context => "list", icon => "delete", text => $dtext &></a>
     </td>
    </tr>
% }
    <tr>
     <td class="right">Add parent</td>
     <td colspan="2"/>
     <td colspan="2">
% my $atext = "Add new parent";
      <a href="addParent.html" title="<% $atext %>"><& /mc/link/icon.mc, context => "list", icon => "new", text => $atext &></a>
     </td>
    </tr>
   </table>
   <p style="padding: 2em 0em">
     AutoInherit is <% $offon[$autoInherit] %>.
     <button type="button" onclick="window.location.href='parents.html?setAuto=<% $autoInherit ? 0 : 1 %>'">Turn it <% $offon[!$autoInherit] %></button>
   </p>
   <p>
% if ($showURL) {
    <button type="button" onclick="window.location.href='parents.html'">Hide URLs</button>
% } else {
    <button type="button" onclick="window.location.href='parents.html?showURL=1'">Show URLs</button>
% }
    <button type="button" id="refresh" onclick="refreshFromParents()">Refresh records from parents</button>
   </p>
<script type="text/javascript">
    function refreshFromParents() {
	var button = document.getElementById("refresh");
	button.innerHTML = "Refreshing ... wait ...";
	// alert('<% $worldURI %>');

	var xmlHttp = new XMLHttpRequest(); 
	xmlHttp.open("GET", '<% $worldURI %>', false);
	xmlHttp.send(null);
	// ### Check for success using xmlHttp.responseText or similar
	alert("Refreshed records from parents");
	button.innerHTML = "Refreshed.";
    }
</script>
