<%args>
$report_order
$sort => 1
</%args>
<%perl>

#
# format: 
#   [ "report_id", "description", todo|id ]
#
#   report_id: name[,x-axis][,y-axis][,switch axis][,customer]
#
# my @column99 = ( 
#    ["_line", "Searches", "searches"],
#    ["database", "Database & Date"], 
#    ["affiliation", "Affiliation & Date"], 
#    ["_line", "Clicks Through", "clicks_through"],
#    ["clicks_through_olinks", "to Olinks Affiliation & Date"],  # xxx
#    ["_line", ""],
#  )


my $r = {
    "searches" => {
        -title   => "Searches",
        -reports => [
            [ "database",                "Database & Date" ],
            [ "affiliation,,,1",         "Affiliation & Date" ],
            [ "category",                "Category & Date" ],
            [ "database,affiliation,,0", "Affiliation & Database" ],
            [ "category,affiliation,,0", "Affiliation & Category" ],
            [ "category,database,,1",    "Database & Category" ],
        ]
    },

    "clicks_through" => {
        -title   => "Clicks Through",
        -reports => [
            [ "clicks_through_olinks,date,affiliation,1,ohio",     "to Olinks Affiliation & Date" ],
            [ "clicks_through_source",                        "to Source Database & Date" ],
            [ "clicks_through_source,date,affiliation,1",     "to Source Affiliation & Date" ],
            [ "clicks_through_source,database,affiliation,1", "to Source Affiliation & Database"],
        ]
    },

    "full_record_view" => {
        -title   => "Full record views",
        -reports => [
            #[ "full_record_view",                        "Database & Date" ],
            [ "full_record_view,,affiliation,1",          "Affiliation & Date" ],
            #[ "full_record_view,affiliation,category,1", "Affiliation & Category" ],
            #[ "full_record_view,affiliation,database,1", "Affiliation & Database" ],
            #[ "full_record_view,database,category,0",    "Category & Database" ],
            #[ "full_record_view,date,category,0",        "Category & Date" ],
        ]
    },

    "search_failures" => {
        -title   => "Source Failures", #  (z39.50 targets)
        -reports => [
            [ "failures",             "Database & Date" ],
            [ "failures,,affiliation,1", "Affiliation & Date" ],
        ]
    },

    "search_zerohits" => {
        -title   => "Search Failures", # zero hits
        -reports => [
            [ "zerohits,,,1", "Affiliation & Date"],
        ]
    },

    "sessions" => {
        -title   => "Sessions",
        -reports => [
            [ "session_database",                "Database & Date" ],
            [ "session_affiliation,,,1",         "Affiliation & Date" ],
            [ "session_database,affiliation,,0", "Affiliation & Database" ],
            [ "session_category,affiliation,,0", "Affiliation & Category" ],
            [ "session_category",                "Category & Date" ],
            [ "session_category,database,,1",    "Database & Category" ],
        ]
    },

    "counter_report" => {
        -title   => "Counter Report",
        -reports => [
            [ "counter_db1", "COUNTER DB1 (Consortial)" ],
            [ "counter_db1,affiliation", "COUNTER DB1 (Library)"],
        ]
    },
};

my @column9;
my @list = @$report_order; #  qw/searches clicks_through full_record_view search_failures sessions counter_report/;

# all available reports
if (@list == 1 && $list[0] eq ':ALL') {
    @list = sort keys %$r;
}

foreach my $section (@list) {
    if (!exists $r->{$section}) {
	warn "Unknown section: '$section'\n";
	next;
    }
    push @column9, ["_line", $r->{$section}->{-title}, $section ];

    if ($sort) {
       push @column9, sort { $a->[1] cmp $b->[1] } @{ $r->{$section}->{-reports}};
    } else {
       push @column9, @{ $r->{$section}->{-reports}};
    }
}

# final last line
push @column9, ["_line", ""],

return ($r, @column9);

</%perl>

