<%args>
$r
$alln
$query
</%args>
<%perl>
my $q = $m->notes("q");
my $admin = $m->notes("admin");
my $pageSize = $admin->conf("pageSize") || 50;
my $start = 0;

if (utf8param($q, "start")) {
    my $s = utf8param($q, "start");
    $start = $s if $s >= 0 && $s <= 20000;
}
if (utf8param($q, "num")) {
    my $num = utf8param($q, "num");
    $pageSize = $num if $num >= 1 && $num <= 200;
}
my $last_record = $pageSize + $start - 1;
$last_record = $alln-1 if $last_record >= $alln;

my $pagingHTML = '<table width="100%" class="paging"><tr><td>';
if ($start > 0) {
    my $s = $start - $pageSize;
    $s = 0 if $s < 0;
    my $url = URI->new($r->unparsed_uri()); $url->query_form('start', $s, 'num', $pageSize, 'query', $query);
    my $link = $url->as_string;
    $pagingHTML .= qq{<a href="$link">&lt;&lt;&nbsp;Prev</a> };
} else {
    $pagingHTML .= qq{<span class="disabled">&lt;&lt;&nbsp;Prev</span> };
}

$pagingHTML .= qq{</td><td align="center">};
if ($admin->conf("showPageList") &&
    ($start > 0 || $pageSize + $start < $alln)) {
    $pagingHTML .= $m->comp("pagelist", whichRecord => $start, count => $alln,
			    pageSize => $pageSize, query => $query);
}

$pagingHTML .= qq{</td><td align="right">};

if ($pageSize + $start < $alln) {
    my $url = URI->new($r->unparsed_uri()); $url->query_form('start', ($pageSize + $start), 'num', $pageSize, 'query', $query);
    my $link = $url->as_string;
    $pagingHTML .= qq{<a href="$link">Next&nbsp;&gt;&gt;</a>};
} else {
    $pagingHTML .= qq{<span class="disabled">Next&nbsp;&gt;&gt;</span>};
}

$pagingHTML .= "</td></tr></table>";

my $rangeHTML;
if ($alln == 0) {
    $rangeHTML = "No records found";
} else {
    $rangeHTML = "Records " . ($start+1) . "&ndash;" . ($last_record+1) . " (of $alln)";
}

return ($start, $last_record, $pageSize, $pagingHTML, "<p>$rangeHTML</p>");
</%perl>

<%def pagelist>
<%args>
$whichRecord
$count
$pageSize
$query
</%args>
<%perl>
my $MAX_PAGES = 20;
my $whichPage = int($whichRecord/$pageSize)+1;
my $npages = int(($count-1)/$pageSize)+1;
my($firstPage, $lastPage);
my($pre, $post);
if ($npages <= $MAX_PAGES) {
    ($firstPage, $lastPage) = (1, $npages);
    ($pre, $post) = ("", "");
    #warn "all MAX=$MAX_PAGES, which=$whichPage, first=$firstPage, last=$lastPage\n";
} elsif ($whichPage <= $MAX_PAGES/2) {
    ($firstPage, $lastPage) = (1, $MAX_PAGES);
    ($pre, $post) = ("", " ...");
    #warn "start MAX=$MAX_PAGES, which=$whichPage, first=$firstPage, last=$lastPage\n";
} elsif ($whichPage >= $npages-$MAX_PAGES/2) {
    ($firstPage, $lastPage) = ($npages-$MAX_PAGES+1, $npages);
    ($pre, $post) = ("... ", "");
    #warn "end MAX=$MAX_PAGES, which=$whichPage, first=$firstPage, last=$lastPage\n";
} else {
    ($firstPage, $lastPage) = ($whichPage-int($MAX_PAGES/2)+1, $whichPage+int($MAX_PAGES/2));
    ($pre, $post) = ("... ", " ...");
    #warn "mid MAX=$MAX_PAGES, which=$whichPage, first=$firstPage, last=$lastPage\n";
}


my $res = $pre;
for (my $i = $firstPage; $i <= $lastPage; $i++) {
    $res .= " " if $i > $firstPage;
    if ($i == $whichPage) {
	$res .= qq{<b>$i</b>};
    } else {
	my $url = URI->new($r->unparsed_uri());
	$url->query_form(start => ($i-1) * $pageSize, num => $pageSize, query => $query);
	my $link = $url->as_string;
	$res .= qq{<a href="$link">$i</a>};
    }
}
return $res . $post;
</%perl>
</%def>
