<%args>
$merged => 0
</%args>
<%once>
use File::stat;
use CGI;
#use Data::Dumper;

use Masterkey::Admin::Utils qw(utf8param);
use Masterkey::Admin::ServiceProxyStatistic;
</%once>
<%perl>

$m->comp("/mc/setup.mc");
my $admin = $m->notes("admin");
my $user = $m->comp("/mc/utils/user.mc");
my $debug = $admin->conf("serviceProxyStatisticDebug") || 0;

if (!defined $user) {
   print "How did you get here when you're not logged on?\n";
   return;
}

my $identityId = $user->field("identityId");

warn "Run as user '$identityId'\n" if $debug >= 1;

my $uadmin = new Masterkey::Admin("identity");
my $rs;
my $fullquery = "identityId==$identityId";
my $realm = $user->field("identityId");
$rs = $uadmin->torus()->sortedRecords($realm, $fullquery, $user);
my $hostName = "";
if ($rs->records() && $rs->records()->[0]) {
    $hostName = $rs->records()->[0]->field("hostName");
}
warn "Run as user '$identityId', hostName='$hostName'\n" if $debug >= 1;

sub report_name {
    my $config = shift;
    my $statistic = shift;

    my $name;
    foreach my $section (keys %$config) {
    	foreach my $report (@ { $config->{$section}->{-reports}} ) {
	    if ($report->[0] eq $statistic) {
		return $config->{$section}->{-title} .": ". $report->[1];
	    }
    	}
    }

    return "";
}

my $q = CGI->new($r);
my $output_format = utf8param($q, "output_format");
my $format = $output_format;
if  (!grep { $_ eq $format } qw/excel csv xml json text sutrs html/) {
   warn "Unknown format: '$format'\n";
   $format = "csv";
}

my $param_statistic = utf8param($q, "statistic");
my ($statistic, $column2, $column3, $switch_axis2) = split ",", $param_statistic;
my @args;

my %default = ('report_order' => "searches clicks_through full_record_view search_failures search_zerohits sessions counter_report");

my ($config, @column9) = $m->comp("/mc/reports.mc", 'report_order' => [':ALL']) ;

if ($statistic eq 'counter_db1') {
    $format = 'excel' if !($format eq 'excel' || $format eq 'xml');
    undef $column2;
}

push @args, "--filter-user=$identityId" if $identityId ne 'admin';

my $file_format_mapping = { "text" => "txt", "excel" => "xls", "sutrs" => "txt" };
my $file_format = exists $file_format_mapping->{$format} ? $file_format_mapping->{$format} : $format;
my $disposition = qq{inline; filename=sp-statistic.$file_format};
$r->err_headers_out->add('Content-disposition' => $disposition);


my $filter_session = 0;
# use pseudy filter session
if ($statistic =~ s/^session_//) {
    $filter_session = 1;
}

my $filter_date = utf8param($q, "filter_date");
my $filter_type = utf8param($q, "dateRange.dateRangeType");

if ($filter_type eq 'simple') {
  $filter_date = utf8param($q, "dateRange.simpleDate");
  if  (!grep { $_ eq $filter_date } qw/today yesterday 7days month last_month all_time none/) {
     warn "Unknown filter date: '$filter_date'\n";
     $filter_date = "none"
  }
} else {

  # date with leading zero: "7" => "07"
  sub zero_date { my $d = shift; $d < 10 ? "0".$d  : $d };

  my $date_start =
              utf8param($q, "dateRange.customDate.start.year") .
	"-" . zero_date(utf8param($q, "dateRange.customDate.start.month")) .
	"-" . zero_date(utf8param($q, "dateRange.customDate.start.day"));

  my $date_end =
              utf8param($q, "dateRange.customDate.end.year") .
	"-" . zero_date(utf8param($q, "dateRange.customDate.end.month")) .
	"-" . zero_date(utf8param($q, "dateRange.customDate.end.day"));
  $filter_date = $date_start . '..' . $date_end;
}

# if the user select the switch axis flag, revert
# the standard option
my $switch_axis = utf8param($q, "switch_axis") || "";
if ($switch_axis ne "") {
   $switch_axis2 = !$switch_axis2;
}
my $sort_by = utf8param($q, "sort_by") || "";

my $http_format_mapping = { "text" => "plain", "sutrs" => "plain" };
my $http_format = exists $http_format_mapping->{$format} ? $http_format_mapping->{$format} : $format;

if ($statistic eq 'failures') {
    push @args, "--filter-state=Client_Error";
}

if ($statistic eq 'zerohits') {
    push @args, "--filter-hits=0";
    $statistic = "affiliation";
}

if (!grep { $_ eq $statistic } qw/database affiliation session full_record_view clicks_through_olinks clicks_through_source category counter_db1/) {
   warn "Unknown statistic: $statistic\n";
   $statistic = "database";
}

my $stat = Masterkey::Admin::ServiceProxyStatistic->new('admin' => $admin, 'debug'=>$debug, 'hostName' => $hostName );

my $libraries_csv =  $stat->get_path('path' =>  $admin->conf("serviceProxyStatisticLibraresCSV"), 'param' => { 'hostName' => $hostName });
my $categories_csv = $stat->get_path('path' =>  $admin->conf("serviceProxyStatisticCategoriesCSV"), 'param' => { 'hostName' => $hostName });
my $provider_csv =   $stat->get_path('path' =>  $admin->conf("serviceProxyStatisticProviderCSV"), 'param' => { 'hostName' => $hostName });
my $platform =       $stat->get_path('path' =>  $admin->conf("serviceProxyStatisticPlatform"), 'param' => { 'hostName' => $hostName });

my $report_name = &report_name($config, $param_statistic);

# cached log files
if ($admin->conf("serviceProxyStatisticCacheLogfileEnabled")) {
   my $uid = $<;

   my $cache = $admin->conf("serviceProxyStatisticCacheLogfile") || "/tmp/service-proxy-%{hostName}.db";
   $cache =  $stat->get_path('path' => $cache, 'param' => { 'hostName' => $hostName });

   my $st = stat($cache);
   my $expire = $admin->conf("serviceProxyStatisticCacheLogExpire") || 600; # in seconds,
   if ($st && $st->mtime() > (time - $expire) ) {
       push @args, "--storable-read=$cache";
   } else {
	warn "Re-generate cache '$cache'\n";
	my @args_cache = (@args, "--storable-write=$cache");
	$stat->out('args' => \@args_cache, 'r'=>$r, 'http_format'=> $http_format);

	if (-f $cache && ($st = stat($cache)) && $st->mtime() > (time - $expire)) {
	    push @args, "--storable-read=$cache";
	} else {
	    warn "Oops, cannot use cache file: '$cache'\n";
	}

        $m->comp("/mc/cache.mc", "debug" => $debug,
   	   "csv_config" => { "libraries" => $libraries_csv, "categories" => $categories_csv, "provider" => $provider_csv } );
   }
} else {
    $m->comp("/mc/cache.mc", "debug" => $debug,
   	"csv_config" => { "libraries" => $libraries_csv, "categories" => $categories_csv, "provider" => $provider_csv } );
}

push @args, ("--output-format=$format", "--filter-date=$filter_date", "--statistic=$statistic");
push @args, "--libraries=$libraries_csv" if -e $libraries_csv;
push @args, "--categories=$categories_csv" if -e $categories_csv;
push @args, "--provider=$provider_csv" if -e $provider_csv;
push @args, "--platform=$platform" if $platform && $statistic eq 'counter_db1' ;
push @args, "--axis-x=$column2" if $column2;
push @args, "--axis-y=$column3" if $column3;
push @args, "--sort-by=$sort_by" if $sort_by;
push @args, "--switch-axis" if $switch_axis2;
push @args, "--filter-session" if $filter_session;
push @args, "--report-name=$report_name" if $report_name;

print $stat->out('r'=> $r, 'http_format'=> $http_format, 'args' => \@args);

</%perl>
