package Masterkey::Admin::Report;

use 5.008;
use strict;
use warnings;

use Masterkey::Admin;


sub new {
    my $class = shift();
    die "$class->new() called with more than one argument: @_" if @_ > 0;

    my $sadmin = new Masterkey::Admin("searchable");
    my $iadmin = new Masterkey::Admin("admin");
    my $uadmin = new Masterkey::Admin("identity");
    my $cadmin = new Masterkey::Admin("cat");
    my $gadmin = new Masterkey::Admin("global");

    return bless {
	# Although client code does not itself need to use the Admin
	# objects, we must keep them inside the new Report object so
	# that they don't get GC'd and the weak references to them in the
	# Torus objects get nulled.
	__UNUSED_sadmin => $sadmin,
	__UNUSED_iadmin => $iadmin,
	__UNUSED_uadmin => $uadmin,
	__UNUSED_cadmin => $cadmin,
	__UNUSED_gadmin => $gadmin,
	storus => $sadmin->torus(),
	itorus => $iadmin->torus(),
	utorus => $uadmin->torus(),
	ctorus => $cadmin->torus(),
	gtorus => $gadmin->torus(),
    }, $class;
}


sub storus { shift()->{storus} }
sub itorus { shift()->{itorus} }
sub utorus { shift()->{utorus} }
sub ctorus { shift()->{ctorus} }
sub gtorus { shift()->{gtorus} }


sub row {
    my $this = shift();
    my(@fields) = @_;

    my $row = "";
    foreach my $i (0 .. $#fields) {
	my $field = $fields[$i];
	if ($field =~ /["",\n]/) {
	    $field =~ s/[""]/""/g;
	    $row .= qq["$field"];
	} else {
	    $row .= $field;
	}
	$row .= ($i == $#fields) ? "\n" : ",";
    }

    return $row;
}


1;
