package Masterkey::Admin::Session;

use 5.008;
use strict;
use warnings;

use Fcntl;   # For O_RDWR, O_CREAT, etc.
use SDBM_File;
use FreezeThaw;

sub _dbfile() {
    # Base SDBM filename on last component of configuration directory
    my $tag = $ENV{MAsessiontag};
    if (!defined $tag) {
	my $dir = $ENV{MAconfigdir} or
	    die "no MAsessiontag or MAconfigdir defined in environment";
	my @comp = split('/', $dir);
	for (my $i = @comp-1; $i >= 0; $i--) {
	    $tag = $comp[$i];
	    last if $tag ne "admin" && $tag ne "mkadmin";
	}
    }
    return "/tmp/mkadmin-sessions-$tag.sdbm";
}

sub new {
    my $class = shift();

    my $chars = join("", "A".."Z", "a".."z", "0".."9", "+", "/");
    my $cookie = "";
    foreach my $i (1..12) {
	$cookie .= substr($chars, int(rand()*64), 1);
    }

    return bless {
	cookie => $cookie,
    }, $class;
}

sub cookie { shift()->{cookie} }
sub user_id { shift()->{user_id} }
sub dest { shift()->{dest} }

sub find {
    my $this = shift();
    my($cookie) = @_;

    my %h;
    my $dbfile = _dbfile();
    if (!tie(%h, "SDBM_File", $dbfile, O_RDONLY, 0666)) {
	return undef if $! =~ /No such file/i;
	die "Couldn't read SDBM file '$dbfile': $!";
    }

    my $val = $h{$cookie};
    untie %h;

    return undef if !defined $val;
    my($session) = FreezeThaw::thaw($val);
    return $session;
}

# Returns the number of fields modified, dies on error
sub update {
    my $this = shift();
    my(%data) = @_;

    my $count = 0;
    foreach my $key (keys %data) {
	if (!defined $this->{$key} || $data{$key} ne $this->{$key}) {
	    $this->{$key} = $data{$key};
	    $count++;
	}
    }

    if ($count > 0) {
	my %h;
	my $dbfile = _dbfile();
	# For some reason, O_WRONLY|O_CREAT fails with ENOENT
	tie(%h, "SDBM_File", $dbfile, O_RDWR|O_CREAT, 0666)
	    or die "Couldn't write SDBM file '$dbfile': $!";

	my $cookie = $this->cookie();
	$h{$cookie} = FreezeThaw::freeze($this);
	untie %h;
    }

    return $count
}

1;
