use Test::More tests => 12;

BEGIN {
    use_ok('Masterkey::Admin::Facets');
}

my $facet_categories = Masterkey::Admin::Facets->new(
    'uri'                 => "http://indexdata2.com/",
    'div_id'             => 'facet_categories2',
    'max'                 => 5,
    'formInputName'       => 'q',
    'sort_by'             => "hits",
    'div_class'          => "facets2",
    'ignore_empty_facets' => 1,
);

for ( 1 .. 3 ) { $facet_categories->add("foo") }
for ( 1 .. 5 ) { $facet_categories->add("bar") }
for ( 1 .. 7 ) { $facet_categories->add("index'data") }
for ( 1 .. 1 ) { $facet_categories->add("") }
for ( 1 .. 1 ) { $facet_categories->add() }

my $html = $facet_categories->html();
like( $html, qr/id="facet_categories2"/,              "facet id test" );
like( $html, qr/class="facets2"/,                     "facet class test" );
like( $html, qr{href="http://indexdata2.com/\?q=%22}, "facet url test" );
like( $html, qr{bar \(5\)},                           "facet hits test" );
unlink( $html, qr{></a>}, "ignore empty facets test" );

isnt( $html, $facet_categories->html_js(), "JavaScript escape test" );

#print $html;

######################################################################
# a hash of objects for multiple facets
my $facet = Masterkey::Admin::Facets->new_group(
    'facets' => [ "categories", "serviceProvider", "opacVendor" ],
    'max'    => 5,
    'uri'    => "http://indexdata.com/"
);

$facet->{"categories"}->add("foo");
$facet->{"categories"}->add("bar");
$facet->{"opacVendor"}->add("bar");

isnt( $facet->{"categories"}->html, "", "facet group test" );
isnt( $facet->{"categories"}->html,      $facet->{"serviceProvider"}->html, "different facets differ 1/3" );
isnt( $facet->{"categories"}->html,      $facet->{"opacVendor"}->html, "different facets differ 2/3" );
isnt( $facet->{"serviceProvider"}->html, $facet->{"opacVendor"}->html, "different facets differ 3/3" );

my $html_js = $facet->{"categories"}->html_js;
$html = $facet->{"categories"}->html;
isnt( $html, $html_js, "JavaScript escape test" );

# no &quot character to escape, everything should be equal except the new lines
$html =~ s/\n/ /g;
is( $html, $html_js, "JavaScript escape test2" );

1;

