<%args>
$merged => 0
</%args>
<%once>
use File::stat;
use Time::Piece;
use Text::CSV;
use HTTP::Date;
use Data::Dumper;
use CGI;

use Masterkey::Admin::Utils qw(utf8param);
</%once>

<%perl>

$m->comp("/mc/setup.mc");
my $admin = $m->notes("admin");
my $user = $m->comp("/mc/utils/user.mc");

my $debug = $admin->conf("BillingDebug") || 0;
my $billing_enabled = $admin->conf("BillingEnabled") || 0;
my $customer = $admin->conf("BillingCustomer") || "";
my $history_enabled = $admin->conf("BillingHistoryEnabled") || 1;
my $history_directory = $admin->conf("BillingHistoryDirectory") || "/var/tmp";
my @supported_formats = split( /\s+/, $admin->conf("BillingSupportedFormats") || "html csv");
my $billing_token = $admin->conf("BillingToken") || "";
my $billing_excluded_libraries = $admin->conf("BillingExcludedLibraries") || "";
my $select_all = $admin->conf("BillingSelectAll") || "0";

my $unique = 1; 	# unique CSV row output
my $unique_month = 1; 	# unique month CSV row output (last value only of a month)

warn "Billing customer: $customer\n" if $debug;
my $q = CGI->new($r);
my $token_param = utf8param($q, "token") || "";
my $creation = utf8param($q, "creation") || "";
$creation = "" if $creation ne 'yes';

if (utf8param($q, "excluded")) {
    $billing_excluded_libraries = utf8param($q, "excluded") || "";
}
if ($billing_excluded_libraries) {
   eval { "." =~ /$billing_excluded_libraries/i };
   if ($@) {
	warn "Ignore broken billing regex '$billing_excluded_libraries'\n";
	$billing_excluded_libraries = "";
   }
}

my $identityId;
if ($user) {
    $identityId = $user->field("identityId");
}

if ($token_param && $token_param eq $billing_token) {
   $user = "billing";
   $identityId = $user;
}
warn "Run as user '$identityId'\n" if $debug >= 1;

if (!defined $user || !$billing_enabled) {
   print $q->content_type("text/html");
   print "<html>\n<body>\n";

   if (!defined $user) {
       print "<p>How did you get here when you're not logged on?\n</p>";
       print qq{<p>Please <a href="../">login</a> first! </p>\n};
   } else {
       print qq{<p>Sorry, the billing statistic is not enabled for this site. Please contact your MK2 administrator!</p>};
   }

   print "<hr/></body></html>\n";
   return;
}


my $output_format = utf8param($q, "output_format") || "csv";
my $details = utf8param($q, "details") || "";

my $format = $output_format;
if  (!grep { $_ eq $format } @supported_formats) {
   warn "Unknown format: '$format'\n";
   $format = "csv";
}

my $http_format = $format;

# set the CSV filename to save output locally
my $disposition = qq{inline; filename=billing-$customer} . ($creation ? "-creation" : "") . qq{.$http_format};

$r->content_type("text/$http_format");
$r->err_headers_out->add('Content-disposition' => $disposition) if $output_format eq 'csv';

my $t = localtime;
my $month = $t->mon . "/" . $t->year;

use Masterkey::Admin::Report;
my $report = new Masterkey::Admin::Report();

my @table_header = ("Library/month", "Z39.50 unsupported", "Z39.50 supported", "CF targets unsupported", "CF targets supported",
	            "Total Targets", "CF Connector unsupported", "CF Connector supported", "Total Connectors", "Target Names");
my @table = [@table_header];

my $rs = $report->itorus()->records("admin", undef, undef, 1);
my $identities = $rs->records();
### Should we uniquify on realm?
my @identities = sort { $a->displayName() cmp $b->displayName() } @$identities;

my %total;
my %total_cf;
my %total_unique;

# SLA
my @types = qw/z3950_unsupported z3950_supported cf_target_unsupported cf_target_supported/;

# CF connectors, not targets
# Note: A CF Connector can support multiple targets.
my @types_cf = qw/cf_connector_unsupported cf_connector_supported/;

# return unique sorted list
sub unique {
    my @list = @_;

    my %hash = map { $_ => 1 } @list;
    return sort keys %hash;
}

my %hash_total;

sub month {
    my $time = shift || localtime;

    my $t = localtime($time);
    my $month = $t->mon . "/" . $t->year;

    return $month;
}

#
# for each library, count the targets,
# calculate the type of target (supported, unsupported), and filter connector names,
# and filter unique targets (consortia)
#
my $counter = 0;
my $this_month = &month();
foreach my $identity (@identities) {
    my $name = $identity->displayName();
    my $realm = $identity->field("identityId");
    warn "realm: $realm\n" if $debug;

    my @row;

    if (!defined $realm || $realm eq "") {
        warn "ignoring identity '$name' with no realm";
        next;
    }
    if ($billing_excluded_libraries && $name =~ /$billing_excluded_libraries/i) {
	warn "Ignore test libarary '$name'\n" if $debug >= 1;
	next;
    }

    push @row, $name;

    my $rs = $select_all ? $report->storus()->world($realm) : $report->storus()->records($realm);
    my $list = $rs->records();
    my @list = sort { lc($a->displayName()) cmp lc($b->displayName()) } @$list;

    my %hash;
    my %hash_cf;

    warn "name: $name\n" if $debug >= 2;
    my $creationDate;

    foreach my $searchable (@list) {
	my $target_name = $searchable->displayName() || "";
	my $disabled = $searchable->field("disabled");

	if (defined $disabled && $disabled eq 'yes') {
            warn "Ignored disabled $target_name\n" if $debug >= 1;
            next;
        }

	# count only new created targets
	if ($creation eq 'yes') {
	    $creationDate = $searchable->field("creationDate");
	    next if !$creationDate;
	    my $time = str2time($creationDate);

	    next if $this_month ne &month($time);
	}

	my $zurl = $searchable->field("zurl");
	my $supported = $searchable->field("supported") || 0;

	warn "supported: $supported: $zurl\n" if $debug >= 3;

	#
        # targets based on connectors
        # matching is done by hostnames (connect.indexdata.com) or
        # port 9000 (metaproxy) or 9003 (cf-zserver)
	#
        if ($zurl =~ m,(\.[a-z]+|localhost|127\.0\.0\.1):900[03]/, || $zurl =~ /connect.*.indexdata.com/ ) {
	    $supported ? $hash{cf_target_supported}++ : $hash{cf_target_unsupported}++;
	    $supported ? $hash_total{cf_target_supported}{$zurl}++ : $hash_total{cf_target_unsupported}{$zurl}++;

	    # count by connector and ignore subdatabases
            my $z = $zurl;
	    $z =~ s/\?.*//;

	    $supported ? $hash{cf_connector_supported}++ : $hash{cf_connector_unsupported}++;
	    $supported ? $hash_total{cf_connector_supported}{$z}++ : $hash_total{cf_connector_unsupported}{$z}++;

	    $hash_total{_total_cf}{$z}++;
        }

	# z39.50 targets
        else {
	    $supported ? $hash{z3950_supported}++ : $hash{z3950_unsupported}++;
	    $supported ? $hash_total{z3950_supported}{$zurl}++ : $hash_total{z3950_unsupported}{$zurl}++;
        }

	$hash_total{_total}{$zurl}++;
	push @{$hash{_target}}, $target_name if $target_name ne "";
    }

    # customer: targets columns
    foreach my $type (@types) {
	push @row, ($hash{$type} || 0);

        $total{$type} += $hash{$type};
    }

    # customer: targets total
    push @row, scalar(@list);
    $total{_total} += scalar(@list);


    # customer: connector columns
    my $total_x = 0;
    foreach my $type (@types_cf) {
	push @row, ($hash{$type} || 0);
        $total{$type} += $hash{$type};
	$total_x += $hash{$type};
    }

    # customer: total connectors column
    push @row, $total_x;
        $total{_total_cf} += $total_x;

    if (exists $hash{_target}) {
    	push @row, join ("; ", @{$hash{_target}});
    } else {
	push @row, "";
    }

    # put the row on the list
    push @table, \@row;
    push @{$total{_target}}, @{$hash{_target} } if exists $hash{_target};

    my @last;
    foreach my $type (@types, "_total", @types_cf, "_total_cf") {
        push @last, scalar (keys %{$hash_total{$type}});
    }
    #warn join (" ", @last), "\n";
    #if ($counter >= 14) {
    #	if ($counter == 14) {
    #		warn "YYY $name: ", join ("\n", map { $_->field("zurl") } @list), "\n";
    # }
    #	last;
    #}
    $counter++;
}

# if a target is supported *and* unsupported, count only the supported one in total list
foreach my $key (keys %{$hash_total{z3950_unsupported}}) {
    if (exists $hash_total{z3950_supported}{$key}) {
	delete $hash_total{z3950_unsupported}{$key};
    }
}
foreach my $key (keys %{$hash_total{cf_target_unsupported}}) {
    if (exists $hash_total{cf_target_supported}{$key}) {
	delete $hash_total{cf_target_unsupported}{$key};
    }
}
foreach my $key (keys %{$hash_total{cf_connector_unsupported}}) {
    if (exists $hash_total{cf_connector_supported}{$key}) {
	delete $hash_total{cf_connector_unsupported}{$key};
    }
}



if ($details ne 'yes') {
   # keep only header line
   @table = shift @table;

   my $file = $history_enabled ? get_csv_filename('dir' => $history_directory, 'creation' => $creation  ) : "";
   if (-f $file ) {
	warn "open history file $file\n" if $debug;
	my $fh = IO::File->new($file, "r") or die "open $file: $!\n";
	binmode $fh, ":utf8";

        my $csv = get_csv_obj();
	# skip header line
	$csv->getline($fh);

  	while(my $row = $csv->getline($fh)) {
	    if ($unique_month) {
		# ignore entries from the same month
		next if $row->[0] eq $month;
	    }
	    push @table, $row;
	}
    }
}

# Total: second last line
my @last;

if ($details eq 'yes') {
    push @last, "Total $month";
    foreach my $type (@types, "_total", @types_cf, "_total_cf") {
    	push @last, $total{$type};
    }

    push @last, "";
    push @table, [@last];
}

# Total: last line
@last = $details eq 'yes' ? "Total/unique $month" : $month;
foreach my $type (@types, "_total", @types_cf, "_total_cf") {
    push @last, scalar (keys %{$hash_total{$type}});
}

push @last, join ("; ", unique (@{$total{_target}}));

push @table, [@last];

#my $xxx = 0;
#foreach my $type (@types) {
#   $xxx += scalar (keys %{$hash_total{$type}});
#}
#warn "xxx: $xxx\n";

sub get_csv_obj {
    my $csv = Text::CSV->new(
        {
            quote_char          => '"',
            escape_char         => '"',
            sep_char            => ',',
            eol                 => '',
            binary              => 1,
            allow_loose_quotes  => 1,
            allow_loose_escapes => 1,
            allow_whitespace    => 1,
            blank_is_undef      => 1,
        }
    );

    return $csv;
}

sub get_csv_filename {
    my %args = @_;

    my $dir = $args{'dir'};
    my $creation = $args{'creation'};

    if (! -e $dir) {
	my @args = ("mkdir", "-p", $dir);
	system(@args) == 0
	  or die "system @args failed: $?\n";
    }

    my $file = "$dir/billing" . ($creation ? "-creation" : "") . ".csv";

    return $file;
}

if ($format eq 'csv') {

    my $csv = get_csv_obj();
    my $row = 0;
    my $file = $history_enabled && $details ne 'yes' ? get_csv_filename('dir' => $history_directory, 'creation' => $creation ) : "";
    my $file_tmp = $file ? "$file.tmp" : "";
    my $fh;

    if ($file_tmp) {
	warn "open $file_tmp\n" if $debug;
	$fh = IO::File->new($file_tmp, "w") or die "open $file_tmp: $!\n";
	binmode $fh, ":utf8";
    }

    my %hash;
    foreach my $line (@table) {
	my $status = $csv->combine(@$line);
	die "CSV error: " . $csv->error_diag . "\n" if !$status;

   	if ($unique) {
   	    my $key = join ":", @$line;
	    next if $hash{$key}++;
   	}
	print $csv->string(), "\n";

	if ($fh) {
	    print $fh $csv->string(), "\n";
	}
    }

    if ($file_tmp) {
    	close $fh;
    	warn "rename $file_tmp to $file\n" if $debug;
    	rename ($file_tmp, $file) or die "rename: $file_tmp -> $file: $!\n";
    }

    return;
}

</%perl>

<!-- HTML -->
<html>
<head>
  <meta http-equiv="Content-Type" content= "text/html; charset=utf-8" />
  <title>Billing</title>
<style>
table { }
td.total { color: #008000 }
tr.total { color: #008000 }
</style>

<style type="text/css" title="currentStyle">
    @import "css/jquery/DataTables/css/demo_page.css";
    @import "css/jquery/DataTables/css/header.ccss";
    @import "css/jquery/DataTables/css/demo_table_jui.css";
    @import "css/jquery/jquery-ui-1.8.4.custom.css";
</style>

<script type="text/javascript" language="javascript" src="js/jquery/jquery-1.8.2.min.js"></script>
<script type="text/javascript" language="javascript" src="js/jquery/jquery.dataTables.min-1.9.4.js"></script>
<script type="text/javascript" language="javascript" src="js/jquery/colResizable-1.3.min.js"></script>
<script type="text/javascript" language="javascript">
$(document).ready(function() {
    oTable = $('table.datatable').dataTable({
		"bJQueryUI": true,
		"iDisplayLength": 100,
	        "bSort": true,
		"aaSorting": [],
		// "oSearch": {"sSearch": stat_query() },
		"sPaginationType": "full_numbers"
    });
});

$(document).ready(function() { $('table').colResizable({ liveDrag: true }); });
</script>

</head>
<body>
<div id="container">
<div id="dt_example">

<h2><a href="./">Connector &amp; Target report</a></h2>

<span style="color:red">
This page is for testing and development only. Please use the <a href="#csv">CSV</a> link at the bottom for billing.
</span>

<p>
Number of selected targets by library. Date range: <% $month %><br/>
Connectors with sub-databases are counted by sub-database.
A CF Connector can support multiple targets.
</p>

<!--
<h5>Services Level Agreements (SLA)</h5>

<p>
unsupported target: provided as it is<br/>
supported target: we take care of a target if it is broken, analyze and report back to
the customer in N business days.<br/>
</p>
-->

<table border="1" class="datatable">
<thead>

<%perl>
my %hash;
my $thead_counter = 0;
my $rows = $#{$table[0]};

foreach my $row (@table) {
   my $class = $$row[0] =~ /total/i ? qq{class='total'} : "";

   if ($unique) {
   	my $key = join ":", @$row;
	next if $hash{$key}++;
   }

   my @list = @$row;
   for(my $i = $#list; $i < $rows; $i++) {
	push @list, "";
   }

   print "<tr $class>";
   foreach my $td (@list) {
        $class = $td =~ /total/i ? qq{class='total'} : "";
	print qq{<td>$td</td>}
   }
   print "</tr>\n";

   # after first line close thead
   print "</thead>\n" if $thead_counter++ == 0;
}

</%perl>
</table>

<p>

<%perl>
my $qq = new CGI;
$qq->param("output_format", "csv");
my $url = $qq->url(-query=>1, -relative=>1);
</%perl>

<a name="csv" href="<% $url %>">CSV output</a>
</p>
<hr/>
<a href="http://indexdata.com">Index Data ApS</a>

</div>
</div>

</body>
</html>
