package Masterkey::Admin::LogLevel;

use strict;
use warnings;

sub CHITCHAT { 1 << 0 }
sub TORUS    { 1 << 3 }		# HTTP methods and URLs invoked on Toruses
sub WSPOST   { 1 << 4 }
sub WSPUT    { 1 << 5 }
sub RECORD   { 1 << 6 }
sub LAYER    { 1 << 7 }
sub COMPRESS { 1 << 8 }
sub CACHE    { 1 << 9 }		### No longer used
sub CONFIG   { 1 << 10 }
sub NOCACHE  { 1 << 11 }	### No longer used
sub TORUSOP  { 1 << 12 }	# API operations on Torus objects

my %str2num = (
	       CHITCHAT => CHITCHAT,
	       TORUS => TORUS,
	       WSPOST => WSPOST,
	       WSPUT => WSPUT,
	       RECORD => RECORD,
	       LAYER => LAYER,
	       COMPRESS => COMPRESS,
	       CACHE => CACHE,
	       CONFIG => CONFIG,
	       NOCACHE => NOCACHE,
	       TORUSOP => TORUSOP,
);

my %num2str = reverse %str2num;
$num2str{CACHE()} .= ' [DEPRECATED]';
$num2str{NOCACHE()} .= ' [DEPRECATED]';
#warn "num2str = { ", join(", ", map { "$_ -> '" . $num2str{$_} . "'" } sort { $a <=> $b } keys %num2str), "}";

sub num {
    my($str) = @_;

    my $num = 0;
    foreach my $comp (split /,/, uc($str)) {
	my $val = $str2num{$comp};
	die "no loglevel called '$comp'" if !defined $val;
	$num += $val;
    }

    return $num;
}

sub label {
    my($level) = @_;

    my @res;

    foreach my $exp (0..31) {
	my $val = 1 << $exp;
	if ($level & $val) {
	    my $str = $num2str{$val};
	    die "no loglevel string for 1<<$exp == $val" if !defined $str;
	    push @res, $str;
	}
    }

    return "[empty]" if @res == 0;
    return join(",", @res);
}

1;
