package Masterkey::Admin::Test::NonUSI;
use Masterkey::Admin::Test;
our @ISA = qw(Masterkey::Admin::Test);

# Objects for testing target functionality: Non-USI version

use strict;
use warnings;

use HTML::Entities;
use ZOOM;


sub new {
    my $class = shift();
    my($admin, $usiParam, $record) = @_;

    my $useUSI = $usiParam || $admin->conf("usiBaseUrl");
    die "Huh?" if $useUSI;

    my $this = bless {
	admin => $admin,	# A Masterkey::Admin object
	usiParam => $usiParam,	# Whatever was supplied in the URL
	record => $record,	# Description of target to test
    }, $class;

    return $this;
}


sub useUSI { 0 }
sub caption { "non-USI" }


sub zurlAndAuth {
    my $this = shift();
    my($out, $adminUser) = @_;

    my $zurl = $this->record()->field("zurl");
    die "no ZURL defined for this record" if !$zurl;
    return $zurl;
}


sub sruSetting {
    my $this = shift();

    return $this->record()->field("sru");
}


sub backendAuth {
    my $this = shift();
    my($out, $zurl) = @_;

    # If cfAuth is defined, then we have a CF connector: username and
    # password from the "authentication" field gets added as
    # rich-database-name parameters and tokens from cfAuth are set as
    # ZOOM options.  Otherwise the username and password from the
    # "authentication" field just go in the ZOOM options.
    # This code should do the same as the corresponding Metaproxy code
    # in filter_zoom.cpp's
    # yf::Zoom::Frontend::get_backend_from_databases() function.

    my $record = $this->record();
    my $cfAuth = $record->field("cfAuth");
    my $auth = $record->field("authentication");
    my %options;

    if ($cfAuth) {
	warn "got non-empty cfAuth '$cfAuth': CF target";
	if ($cfAuth =~ /\//) {
	    warn "cfAuth is both username and password";
	    my($user, $password) = ($cfAuth =~ /(.*)\/(.*)/);
	    $options{user} = $user;
	    $options{password} = $password;
	} else {
	    warn "cfAuth is username alone";
	    $options{user} = $cfAuth;;
	}

	if ($auth) {
	    warn "got non-empty auth '$auth'";
	    if ($auth =~ /\//) {
		warn "auth is both username and password";
		my($user, $password) = ($auth =~ /(.*)\/(.*)/);
		### use append_zurl() in next three lines
		$zurl = _append_zurl($out, $zurl, user => $user);
		$zurl = _append_zurl($out, $zurl, password => $password);
	    } else {
		warn "auth is user alone";
		$zurl = _append_zurl($out, $zurl, user => $auth);
	    }
	}

	$zurl = _append_zurl($out, $zurl, proxy => $record->field("cfProxy"));
	$zurl = _append_zurl($out, $zurl, subdatabase => $record->field("cfSubDB"));

    } else {
	warn "non-CF target";
	if ($auth) {
	    warn "got non-empty auth '$auth'";
	    if ($auth =~ /\//) {
		warn "auth is both username and password";
		my($user, $password) = ($auth =~ /(.*)\/(.*)/);
		$options{user} = $user;
		$options{password} = $password;
	    } else {
		warn "auth is user alone";
		$options{user} = $auth;
	    }
	}
    }

    return ($zurl, %options);
}


sub _append_zurl {
    my($out, $zurl, $key, $value) = @_;

    if (!defined $value) {
	$out->item("(No ZURL component for $key)");
    } else {
	if ($zurl !~ /,/) {
	    # First component
	    $zurl .= ",";
	} else {
	    # Already got one or more components
	    $zurl .= "&";
	}
	$zurl .= "$key=$value";
	$out->item("Added rich-DB component $key=" . encode_entities($value));
    }
    return $zurl;
}


# Translate the MasterKey name of an index (e.g. "au") to the form
# that is required in queries (e.g. "cql.creator" for USI targets or
# "au" for CCL translation)
#
sub queryIndex {
    my $this = shift();
    my($index) = @_;

    return $index;
}


sub makeQuery {
    my $this = shift();
    my($qstr, $conn) = @_;

    return new ZOOM::Query::CCL2RPN($qstr, $conn);
}


1;
