use Test::More tests => 8;    # skip_all => "not running";

BEGIN { use_ok("Masterkey::Admin::TagCloud"); }

use IO::File;
use Masterkey::Admin::TagCloud;
use strict;
use warnings;

my $cloud = new Masterkey::Admin::TagCloud;

isa_ok( $cloud, 'Masterkey::Admin::TagCloud' );
isnt( $cloud, undef, "TagCloud test" );

$cloud->add_term("foo");

$cloud->generate(
    'uri'    => 'http://indexdata.com/',
    'query'  => 'q',
    'levels' => 8
);

my $html    = $cloud->html_and_css;
my $html_js = $cloud->html_and_css_js;
isnt( $html, "", "TagCloud test" );

like( $html, qr/span.tagcloud8 /, "span.tagcloud8 test" );
unlike( $html, qr/span.tagcloud9 /, "span.tagcloud9 test" );

# no &quot character to escape, everything should be equal except the new lines
$html =~ s/\n/ /g;
is( $html, $html_js, "JavaScript escape test2" );

######################################################################
#
# real world test with 300 records from torus
#
my $file = "t/displayName.txt";
my $fd = new IO::File $file, "r" or die "open file '$file': $!\n";

$cloud = new Masterkey::Admin::TagCloud;
while (<$fd>) {
    chomp;

    foreach my $word ( split(/[\W_-]+/) ) {
        if ( length($word) > 1 ) {
            $cloud->add_term($word);
        }
    }
}
close $fd;

$cloud->generate(
    'uri'    => 'http://indexdata.com/',
    'query'  => 'q',
    'levels' => 8
);

my $counter = 64;
foreach my $line ( split( /\n/, $cloud->html_and_css($counter) ) ) {
    $counter-- if $line =~ /<span class="/;
}
is( $counter, 0, "TagCloud counter test" );

$html = $cloud->html_and_css_js;

#print $html;

1;

__DATA__;

