#!/bin/bash

# test for cproxy-mp


# Choose the system-installed MP, or one installed parallel to this project
MP="../../../metaproxy/src/metaproxy"
if [ ! -x $MP ]
then
  MP="metaproxy"
fi
echo "Using metaproxy at `which $MP`"

LOGFILE="mp.log"

SESDIR="/tmp/cproxy"

#.../cproxydebug-7/...
# 1 debug trace
# 2 verbose (implies 1)
# 4 stop after preprocessing, only debug output
# 7 all of above

rm -f debug*.log $LOGFILE
mkdir -p $SESDIR


PIDFILE="./mp.pid"

if [ -f $PIDFILE ]
then
  PID=`cat $PIDFILE`
  echo "Looks like MP is already running at $PID. trying to kill it"
  kill $PID || exit 9;  # hope the kill displayed an error message
  echo "Killed it all right"
  sleep 0.2 # Let the system release the port, etc
fi

if ! $MP -c ./local-config.xml  -p $PIDFILE -l $LOGFILE -D >debug-stdout.log 2>&1
then
  echo "Failed to start MP"
  cat $LOGFILE
  exit 1
fi

PID=`cat $PIDFILE`
echo "MP started. PID=$PID"
sleep 0.1 # let it start up properly

rm -rf $SESDIR/cf.17 $SESDIR/cf.17.dump
cat > $SESDIR/cf.17 <<END
CfSession 17
#Referer http://www.indexdata.com/software/
#Username someuser
#Password secretpassword
#Proxyip 1.2.3.4
#Cookie www.indexdata.com; one=ONE
#Custom-Replacement Index\sData i html  [[Index Data]]
END
echo "Started a test HTTP(s) server"
echo "  curl http://cpxy.indexdata.dk:8999/testdata/index.html"
echo "Created a simple dummy session 17 in $SESDIR"
echo "You can check it with one of these:"
echo "  curl http://cpxy.indexdata.dk:8999/XXX/YYY/17/www.lsd.dk"
echo "  curl http://cpxy.indexdata.dk:8999/XXX/YYY/17/http/www.lsd.dk"
echo "  curl http://cpxy.indexdata.dk:8999/XXX/YYY/cproxydebug-verbose/17/http/www.lsd.dk"
echo "  curl -k https://cpxy.indexdata.dk:8998/XXX/YYY/17/https/www.indexdata.com"
echo "  curl http://cpxy.indexdata.dk:8999/XXX/YYY/17/http/cpxy.indexdata.dk:8999/testdata/index.html"



