#!/bin/bash

# test for cproxy-mp


# Choose the system-installed MP, or one installed parallel to this project
MP="../../../metaproxy/src/metaproxy"
if [ ! -x $MP ]
then
  MP="metaproxy"
fi
echo "Using metaproxy at `which $MP`"

rm -f debug*.log
ulimit -c 999999 # Enable core dumps, in case we have crashes

LOGFILE="debug-yaz.log"
touch $LOGFILE

LOG="-l $LOGFILE"  

#.../cproxydebug-7/...
# 1 debug trace
# 2 verbose (implies 1)
# 4 stop after preprocessing, only debug output
# 7 all of above
# ... See the source

PIDFILE="./mp.pid"

if [ -f $PIDFILE ]
then
  PID=`cat $PIDFILE`
  echo "Looks like MP is running (pid $PID). Trying to stop it first."
  kill $PID ||  echo "Failed to kill it"
  sleep 1; # to be sure the port is free
  echo "Killed $PID"
  rm -f $PIDFILE  # in any case
fi

rm -f debug*.log

if ! $MP -c ./e2config.xml  -p $PIDFILE $LOG -D >debug-stdout.log 2>&1
then
  echo "Failed to start MP"
  cat $LOGFILE
  exit 1
fi

PID=`cat $PIDFILE`
echo "MP started. PID=$PID"
sleep 0.1 # let it start up properly

rm -rf /tmp/cf.17 /tmp/cf.17.dump
cat > /tmp/cf.17 <<END
CfSession 17
#Referer http://www.indexdata.com/software/
#Username someuser
#Password secretpassword
#Proxyip 1.2.3.4
Cookie www.indexdata.com; one=ONE
Custom-Replacement Index\sData i html  [[Index Data]]
END
echo "Created a simple dummy session 17"


