package Masterkey::Admin::Record;

use strict;
use warnings;
use Scalar::Util;
use Masterkey::Admin::Record::Layer;

sub new {
    my $class = shift();
    my($torus, $x, $using_XML_LibXML_Simple) = @_;

    my $this = bless {
	torus => $torus,
	uri => delete $x->{URI},
	type => delete $x->{type},
	layers => {},
    }, $class;

    Scalar::Util::weaken($this->{torus});
    foreach my $y (@{ $x->{layer} }) {
	my $name = $y->{name};
	$this->{layers}->{_default} = $this->{layers}->{$name} = 
	    new Masterkey::Admin::Record::Layer($this, $y,
						$using_XML_LibXML_Simple);
    }

    if (0) {
	use Data::Dumper; local $Data::Dumper::Indent = 1;
	my $tmp = delete $this->{torus};
	print "<pre>", Dumper($this), "</pre>\n";
	$this->{torus} = $tmp;
    }

    if ($this->torus()->admin()->option("loglevel") &
	Masterkey::Admin::LogLevel::RECORD) {
	# It's naughty to peek at the loglevel
	$this->torus()->log(Masterkey::Admin::LogLevel::RECORD,
			    $this->torus()->admin()->dump($x, $this));
    }

    return $this;
}

sub torus { shift()->{torus} }
sub type { shift()->{type} }
sub layer { shift()->{layers}->{_default}->layer() }
sub uri { 
    my $this = shift();
    my($newval) = @_;
    $this->{uri} = $newval if defined $newval;
    return $this->{uri}
}

sub isWorldRecord {
	my $this = shift();
	#warn "*", $this->displayName(), " layer = '", $this->layer(), "' from {", join(",", sort keys %{$this->{layers}}), "}";
	return (!exists $this->{layers}->{override} &&
		!exists $this->{layers}->{'master-override'});
}


# fields() and field() both delegate to a nominated layer, if one is
# specified, or to the default layer if none is.

sub fields {
    my $this = shift();
    my($layer) = @_;

    $layer = "_default" if !defined $layer;
    my $l = $this->{layers}->{$layer};
    return $l->fields() if defined $l;

    warn "$this->fields('$layer') has no layer: use one of (" .
	join(", ", map { "'$_'" } sort keys %{ $this->{layers} }) . ")";
    return ();
}

sub field {
    my $this = shift();
    my($name, $lname) = @_;

    if (!defined $lname && $name eq "id") {
	# Special case: if asking for "id" in a world record (one that
	# has no override layer), be sure to return the ID from the
	# "original" layer rather than the different one in the
	# "final" layer. See bug MKII-1724.
	$lname = "original" if !exists $this->{layers}->{override};
    }

    if (!defined $lname) {
	my $val = $this->field($name, "final");
	#warn "field('$name', 'final') " . _show($val);
	return $val if defined $val;

	# Generate "final" layer by hand
	return ($this->field($name, "override") ||
		$this->field($name, "original"));
    }

    my $layer = $this->{layers}->{$lname};
    return undef if !defined $layer;
    #die "layer '$lname' not defined" if !defined $layer;
    return $layer->field($name);
}

sub setField {
    my $this = shift();
    my($name, $value) = @_;

    # Currently only needed for master records, so to avoid surprises
    # we reject the call if this is not a master.
    
    die "setField() called on non-Master record"
	if !exists $this->{layers}->{'master-override'};


}

sub _show {
    my($val) = @_;
    return "is undefined" if !defined $val;
    return "= '$val'";
}

# This is the displayName field of the object; however, if that name
# has been overridden, then "new name (old name)" is returned.
#
sub displayName {
    my $this = shift();

    my $nval = $this->field("displayName", "override");
    my $oval = $this->field("displayName", "original");


    ### Debugging for a specific problem -- will be removed later
    if (0 && ((defined $oval && $oval =~ /Free/) ||
	      (defined $nval && $nval =~ /Free/))) {
	my($package, $filename, $line) = caller(1);
	warn("displayName(oval" . (defined $oval ? "='$oval'" : " undefined"),
	     ", nval" . (defined $nval ? "='$nval'" : " undefined"), ")",
	     ", caller=$filename:$line\n");
	use Data::Dumper;
	local $Data::Dumper::Indent = 1;
	local $this->{torus} = undef;
	warn Dumper($this);
    }


    if (defined $nval && defined $oval) {
	return "$nval ($oval)";
    } elsif (defined $nval) {
	return $nval;
    } elsif (defined $oval) {
	return $oval;
    } else {
	my $val = $this->field("displayName");
	return $val if defined $val && $val ne "";
	return "[NO NAME]";
    }
}

# Returns a label to be used on-screen for the specified field
sub label {
    my $this = shift();
    my($field, $label) = @_;

    return $label if defined $label;
    $label = $field;
    $label =~ s/_/ /g;
    return ucfirst($label);
}

# Returns a boolean
sub mandatory_field {
    my $this = shift();
    my($name) = @_;

    # Yuck ... that's a lot of indirection
    $this->torus()->admin()->configObject()->profile()->mandatory($name);
}

sub update {
    my $this = shift();
    my(%data) = @_;

    # It turns out (from static analysis of the code) that this is
    # only ever invoked on logged-in user objects, for password
    # changes and suchlike.  Because we know this, we can introduce a
    # hack on the realm we pass to Torus::update(): rather than using
    # $this->field("identity") [i.e. the record's own identity], we
    # can use the authentication realm of the Torus itself.  That
    # means that if we're using a Realm-based Torus and so the Torus's
    # {ws} is complete, we don't pass in the redundant identity of the
    # user record being updated.
    #
    # This is a fix for bug 4413, but not a good one.  I think there
    # must be a better solution that works with, rather than against,
    # the model; but I can't think what it is and I have to make this
    # work.

    # Assert that we really are looking at a user record.
    die "$this->update() called on a non-auth record"
	if !$this->torus()->{isAuth};

    $this->torus()->update(undef,
			   $this->field("id"),
			   $this->type(),
			   {},
			   %data);
}

sub delete {
    my $this = shift();
    my $torus = $this->torus();

    $this->torus()->delete($this->field("realm"), $this->field("id"));
}

sub render {
    my $this = shift();
    my($layer) = @_;

    my $res = "";
    foreach my $field ($this->fields($layer)) {
	$res .= "$field = '" . $this->field($field, $layer) . "'\n";
    }

    return $res;
}

1;
