<%args>
$param => "homeHtml"
</%args>


<%perl>
use Data::Dumper;

$m->comp("/mc/setup.mc");
my $user = $m->comp("/mc/utils/user.mc");
if (!defined $user) {
   print qq[How did you get here when you're not <a href="/console/">logged on</a>?\n];
   return;
}

my $admin = $m->notes("admin");
my $html = $admin->conf($param);
my $identityId = $user->field("identityId");

my $debug = $admin->conf("serviceProxyStatisticDebug") || 0;

my @format = (
    ["excel", "Excel"],
    ["csv", "CSV"],
    ["xml", "XML"],
    ["text", "ASCII"],
    ["html", "HTML"],
    #["json", "JSON"],
);

my %default = (
    'date_range_selected' => 'alias',
    'date' => "all_time",

    'format' => "text",
    'statistic_type' => "database",
    'filter' => "database",
    'sort_by' => "name",
    'switch_axis' => "",
    'supported_formats' => [ qw/excel text csv xml html/ ],
    'report_order' => "searches clicks_through full_record_view search_failures search_zerohits sessions",
);


my @sort_by = (['hits' => 'total hits'], ['name' => 'name']);
my @switch_axis = (['' => 'none'], ['yes' => 'switch x/y axis']);

$default{'sort_by'} = $admin->conf("serviceProxyStatisticSortBy") if defined $admin->conf("serviceProxyStatisticSortBy");
$default{'switch_axis'} = $admin->conf("serviceProxyStatisticSwitchAxis") if defined $admin->conf("serviceProxyStatisticSwitchAxis");
$default{'supported_formats'} = $admin->conf("serviceProxyStatisticSupportedFormats") if defined $admin->conf("serviceProxyStatisticSupportedFormats");
$default{'format'} = $admin->conf("serviceProxyStatisticFormat") if defined $admin->conf("serviceProxyStatisticFormat");
$default{'statistic_type'} = $admin->conf("serviceProxyStatisticType") if defined $admin->conf("serviceProxyStatisticType");
$default{'date_range_selected'} = $admin->conf("serviceProxyStatisticDateRangeSelected") if defined $admin->conf("serviceProxyStatisticDateRangeSelected");
$default{'date'} = $admin->conf("serviceProxyStatisticDateRange") if defined $admin->conf("serviceProxyStatisticDateRange");
$default{'date_aliases'} = $admin->conf("serviceProxyStatisticDateRangeAliases") if defined $admin->conf("serviceProxyStatisticDateRangeAliases");
$default{'report_order'} = $admin->conf("serviceProxyStatisticReportOrder") if defined $admin->conf("serviceProxyStatisticReportOrder");

$default{'switch_axis'} = "" if $default{'switch_axis'} =~ /^(none|no)$/;

</%perl>

<h2>Statistics Reports</h2>

% if (!$admin->conf("serviceProxyStatisticEnabled")) {
   <p>Sorry, the statistic is not enabled for this site. Please contact your MK2 administrator!</p>
% return; }

<form action="sp-statistic.cgi" >
  <table>
  <tr>
  <th></th>
  <!-- <th>x-axis</th> -->
  <!-- <th>y-axis</th>  -->
  </tr>

<%perl>
  my $customer = $admin->conf("serviceProxyStatisticDateCustomer") || "mk2";
  my $counter = 0;
  my $space = "&nbsp;&nbsp;&nbsp;";

  my @report_order = split /\s+/, $default{'report_order'};
  my ($r, @column9) = $m->comp("/mc/reports.mc", report_order => \@report_order );

  foreach my $tr (@column9) {
    my ($key, $value, $todo ) = @$tr;

    next if $key ne '_line' && $todo && !$debug;

    # some statistics should only appears for specific customers
    my ($statistic, $column2, $column3, $switch_axis2, $website) = split (",", $key);
    next if $website && index($customer, $website) < 0;

    my $selected = $key eq $default{'statistic_type'} ? qq{checked="checked"} : "";
    print qq[<tr>];

    if ($key eq '_line') {
	print qq{<td></td></tr><tr>\n};
	print qq{<td><b>$value</b></td>\n};
    } else {
       $counter++;
	if ($key =~ /^counter_db/) {
	    next if $key eq 'counter_db1' && $identityId ne 'admin';
	    next if $key eq 'counter_db1,affiliation' && $identityId eq 'admin';
	}
       print qq[<td>], ($debug >= 2 ? "${counter}." : $space), qq[<input type="radio" name="statistic" value="$key" $selected>$value</input></td>];
    }
    print qq[</tr>\n];
  }
</%perl>

  </table>

<p>
% $m->comp("/mc/date.mc", %default);

<!--
<p/>
Sort first column by:
<%perl>
foreach my $f (@sort_by) {
    my ($key, $value) = @$f;
    my $selected = $key eq $default{'sort_by'} ? qq{checked="checked"} : "";
    print qq{<input type="radio" name="sort_by" value="$key" $selected>$value</input>\n};
}
</%perl>
<br/>

Switch x/y-axis:
<%perl>
foreach my $f (@switch_axis) {
    my ($key, $value) = @$f;
    my $selected = $key eq $default{'switch_axis'} ? qq{checked="checked"} : "";
    print qq{<input type="radio" name="switch_axis" value="$key" $selected>$value</input>\n};
}
</%perl>
-->

<p/>
Format:
<%perl>
my %supported_formats = map { $_ => 1 } split /\s+/, $default{'supported_formats'};
foreach my $f (@format) {
    my ($key, $value) = @$f;

    next if !$supported_formats{$key};
    my $selected = $key eq $default{'format'} ? qq{checked="checked"} : "";

    print qq{<input type="radio" name="output_format" value="$key" $selected>$value</input>\n};
}
</%perl>
</p>
<input type="submit" name="submit" value="Generate Statistics" />
</form>

<p/>
<hr/>
<p>For power users: view all reports <a href="statistic-all.html">on one page</a>. This will take some time, at least a half minute or more.
</p>

<%perl>
my $logfile = $admin->conf("serviceProxyStatisticLogfile");
my $logfile_hostName = $admin->conf("serviceProxyStatisticHostNameLogfile");
</%perl>

<p style="font-size: small; color: grey; padding-top: 0.2em; text-align: right; padding-right: 1em">
<span title="logfile: <% $logfile %>, logfile hostName: <% $logfile_hostName %>" >Running on <% `hostname` %></span>
</p>

% return;

my $sitename = $m->notes("config");
eval {
    $m->comp("/mc/home/$sitename.mc");
}; if ($@ && ref $@ && ref $@ eq "HTML::Mason::Exception" &&
       $@->as_brief() =~ /could not find component/) {
    $m->comp("/mc/error.mc", msg => "No home-page for '$sitename' tab");
} elsif ($@) {
    die $@;
}
</%perl>
