package Masterkey::Admin::Output;

use HTML::Entities;

sub render0 {
    my $this = shift();
    #use Data::Dumper; warn Dumper($this);
    $this->render(0);
}

### Should probably break into little methods in classes
sub render {
    my $this = shift();
    my($level) = @_;

    return if ($this->isa("Masterkey::Admin::List") &&
	       !$this->heading() &&
	       !$this->list());

    my $indent = " " x $level;
    print "$indent<li>" if $level > 0;

    if ($this->isa("Masterkey::Admin::Item")) {
	print $this->text();
    } elsif ($this->isa("Masterkey::Admin::Display")) {
	my $heading = $this->heading();
	print "$heading\n$indent" if $heading;
	print "<pre>", encode_entities($this->text()), "</pre>";
    } elsif ($this->isa("Masterkey::Admin::List")) {
	my $heading = $this->heading();
	print "$heading\n$indent" if $heading;
	print "<ul>\n";
	foreach my $this ($this->list()) {
	    $this->render($level+1);
	}
	print "$indent</ul>";
    } else {
	die "unsupported object $this in list";
    }

    print "</li>" if $level > 0;
    print "\n";
}


# Textual output of tests is represented by a tree of List, Item, and
# Display. Lists contain zero or more Lists, Items and Displays; Items
# are short pieces of wrappable HTML; Displays are longer pieces of
# unwrappable text to be displayed verbatim.

package Masterkey::Admin::Item;
our @ISA = qw(Masterkey::Admin::Output);
sub new {
    my $class = shift();
    my($text) = @_;
    bless {
	text => $text,
    }, $class;
}
sub text { shift()->{text} }


package Masterkey::Admin::Display;
our @ISA = qw(Masterkey::Admin::Output);
sub new {
    my $class = shift();
    my($text, $heading) = @_;
    bless {
	text => $text,
	heading => $heading,
    }, $class;
}
sub text { shift()->{text} }
sub heading { shift()->{heading} }


package Masterkey::Admin::List;
our @ISA = qw(Masterkey::Admin::Output);
sub new {
    my $class = shift();
    my($heading) = @_;
    bless {
	heading => $heading,
	list => [],
    }, $class;
}
sub add     { my $this = shift(); push @{ $this->{list} }, @_ }
sub item    { my $this = shift();
	      die "multiple items" if @_ > 1;
	      $this->add(new Masterkey::Admin::Item(@_)) }
sub display { my $this = shift(); $this->add(new Masterkey::Admin::Display(@_)) }
sub heading { shift()->{heading} }
sub list { @{ shift()->{list} } }

# Sneaky
sub appendToLastItem {
    my $this = shift();
    my($text) = @_;

    my @list = $this->list();
    die "no items in list"
	if !@list;
    my $item = $list[-1];
    die "last item in list is not an Item"
	if !$item->isa("Masterkey::Admin::Item");
    $item->{text} .= $text;
}

1;
