<%args>
$param => "homeHtml"
</%args>


<%perl>
use Data::Dumper;

$m->comp("/mc/setup.mc");
my $user = $m->comp("/mc/utils/user.mc");
if (!defined $user) {
   print qq[How did you get here when you're not <a href="/console/">logged on</a>?\n];
   return;
}

my $admin = $m->notes("admin");
my $html = $admin->conf($param);
my $identityId = $user->field("identityId");

my $debug = $admin->conf("BillingDebug") || 0;

my @format = (
    ["csv", "CSV"],
    ["html", "HTML"],
);

my %default = ( 
    'format' => "html",
    'supported_formats' => "csv html",
    'details' => "",
    'creation' => "",
    'details_enabled' => "1",
    'creation_enabled' => "1",
);


$default{'format'} = $admin->conf("BillingFormat") if defined $admin->conf("BillingFormat");
$default{'supported_formats'} = $admin->conf("BillingSupportedFormats") if defined $admin->conf("BillingSupportedFormats");
$default{'details_enabled'} = $admin->conf("BillingDetailsEnabled") if defined $admin->conf("BillingDetailsEnabled");

my @details = (['' => 'none'], ['yes' => 'with libraries?']);
my @creations = (['yes' => 'yes'], ['' => 'no']);

</%perl>

<h2>Target Report</h2>

% if (!$admin->conf("BillingEnabled")) {
   <p>Sorry, the billing statistic is not enabled for this site. Please contact your MK2 administrator!</p>
% return; }


<form action="billing.cgi" >
  <table>
  <tr>
  <th></th>
  <!-- <th>x-axis</th> -->
  <!-- <th>y-axis</th>  -->
  </tr>

  </table>

<%perl>
my %supported_formats = map { $_ => 1 } split /\s+/, $default{'supported_formats'};
foreach my $f (@format) {
    my ($key, $value) = @$f;

    next if !$supported_formats{$key};
    my $selected = $key eq $default{'format'} ? qq{checked="checked"} : "";

    print qq{<input type="radio" name="output_format" value="$key" $selected>$value</input>\n};
}
</%perl>

<%perl>
if ($default{'details_enabled'}) {
    print "<p>Details:";
    foreach my $f (@details) {
        my ($key, $value) = @$f;
        my $selected = $key eq $default{'details'} ? qq{checked="checked"} : "";
        print qq{<input type="radio" name="details" value="$key" $selected>$value</input>\n};
    }
}
if ($default{'creation_enabled'}) {
    print "<p>Only new created targets:";
    foreach my $f (@creations) {
        my ($key, $value) = @$f;
        my $selected = $key eq $default{'creation'} ? qq{checked="checked"} : "";
        print qq{<input type="radio" name="creation" value="$key" $selected>$value</input>\n};
    }
}
</%perl>
</%perl>

</p>
<p>Exclude libraries by name:
<input name="excluded" value="test"></input>
</p>
<input type="submit" name="submit" value="Generate Statistics" />
</form>

<p/>

