# cd /home/mike/git/work/mkadmin && perl -I lib t/Masterkey-Admin-Record.t

use strict;
use warnings;
use Test::More tests => 47;
use Data::Dumper; $Data::Dumper::Indent = 1;

BEGIN {
    use_ok('Masterkey::Admin::Record');
};

use Masterkey::Admin::Torus; # for globals XMLin and using_XML_LibXML_Simple
use Masterkey::Admin::Torus::Dummy;
my $admin = new Masterkey::Admin::Dummy(logprefix => $0, loglevel => 0);
my $torus = new Masterkey::Admin::Torus::Dummy($admin);
my $abk = 'Aalborg Badger Kennels';

my $r;
$r = test_record('library', 'userName', 'mike', 'mike', 'mike', undef, undef);
$r->setField('userName', 'fiona');
is($r->field('userName', 'override'), 'fiona', 'library: field update');
### We can't do this without specifying the layer: see MKA-173.

test_record('world-record', 'udb', '451_research', undef, undef, '451_research', undef);
test_record('final-only', 'cfSubDB', 'africanamerican', undef, 'africanamerican', undef, undef);
test_record('without-master', 'realm', 'searchable.test_mike', 'searchable.test_mike', 'searchable.test_mike', 'world', undef);
test_record('master', 'displayName', $abk, undef, undef, undef, $abk);
$r = test_record('with-master', 'displayName', $abk, undef, $abk, 'Aalborg Universitetsbibliotek', $abk);
is($r->field('zurl', 'final'), 'water', "field from second master-override layer");
my @layerCounts = ([ override => 1 ],
		   [ final => 1 ],
		   [ original => 1 ],
		   [ 'master-override' => 2 ]);
foreach my $ref (@layerCounts) {
    my($name, $count) = @$ref;
    my @layers = $r->layers($name);
    is(scalar(@layers), $count, "$count layers of type $name");
}
my @layers = $r->layers('master-override');
my($l1, $l2) = @layers;
is($l1->field('displayName'), 'Aalborg Embroidery Club', "1st master-override displayName");
is($l1->field('zurl'), 'water', "2nd master-override zurl");
is($l2->field('displayName'), $abk, "2nd master-override displayName");
is($l2->field('zurl'), undef, "No 2nd master-override zurl");

sub test_record {
    my($label, $key, @values) = @_;
    my @lnames = (undef, qw(override final original master-override));

    my $s = "t/records/$label.xml";
    open F, "<$s" or die "can't open '$s': $!";
    my $xml = join('', <F>);
    close F;
    my $simple = Masterkey::Admin::Torus::XMLin($xml, ForceArray => 1, KeyAttr => []);
    my $r = new Masterkey::Admin::Record($torus, $label eq 'world', $simple,
					 $Masterkey::Admin::Torus::using_XML_LibXML_Simple);
    ok(defined $r, "made $label record");

    for (my $i = 0; $i < @lnames; $i++) {
	my $lname = $lnames[$i];
	my $val = $values[$i];
	is($r->field($key, $lname), $val,
	   ("$label: " . ($val ? '' : 'nothing in ') . ($lname ? "$lname layer" : 'no layer specified')));
    }

    return $r;
}
