#!/usr/bin/perl

use Test::More;    # skip_all => "not running";
use IO::File;
use Masterkey::Admin::ServiceProxyStatistic;

use strict;
use warnings;

plan tests => 5;

my $logfile  = '/var/log/masterkey/service-proxy/quicksearch.statistics.log';
my $hostName = 'testerver';
my $path     = '/var/log/masterkey/service-proxy/%{hostName}.statistics.log';
my $path2    = "/var/log/masterkey/service-proxy/$hostName.statistics.log";

my $sps = Masterkey::Admin::ServiceProxyStatistic->new(
    'logfile'  => $logfile,
    'hostName' => $hostName
);

isa_ok( $sps, 'Masterkey::Admin::ServiceProxyStatistic' );
isnt( $sps, undef, "ServiceProxyStatistic test" );

$sps->read_config();

is( $sps->{'logfile'},  $logfile,  "got logfile" );
is( $sps->{'hostName'}, $hostName, "got hostName" );
is( $sps->get_path( 'path' => $path, 'param' => { 'hostName' => $hostName } ),
    $path2, "got path with %{var}" );

1;

__DATA__;
